/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import java.util.function.Function;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class ConvertNumbersToRealTypes<N extends Number, T extends RealType<T>, I extends IntegerType<I>> {
    public final Function<N, ByteType> numberToByteType = num -> new ByteType(num.byteValue());
    public final Function<N, UnsignedByteType> numberToUnsignedByteType = num -> new UnsignedByteType((int)num.shortValue());
    public final Function<N, ShortType> numberToShortType = num -> new ShortType(num.shortValue());
    public final Function<N, UnsignedShortType> numberToUnsignedShortType = num -> new UnsignedShortType(num.intValue());
    public final Function<N, IntType> numberToIntType = num -> new IntType(num.intValue());
    public final Function<N, UnsignedIntType> numberToUnsignedIntType = num -> new UnsignedIntType(num.longValue());
    public final Function<N, LongType> numberToLongType = num -> new LongType(num.longValue());
    public final Function<N, FloatType> numberToFloatType = num -> new FloatType(num.floatValue());
    public final Function<N, DoubleType> numberToDoubleType = num -> new DoubleType(num.doubleValue());
    public final Function<I, Byte> integerTypeToByte = i -> (byte)i.getIntegerLong();
    public final Function<T, Byte> realTypeToByte = i -> (byte)i.getRealDouble();
    public final Function<I, Short> integerTypeToShort = i -> (short)i.getInteger();
    public final Function<T, Short> realTypeToShort = i -> (short)i.getRealDouble();
    public final Function<I, Integer> integerTypeToInteger = IntegerType::getInteger;
    public final Function<T, Integer> realTypeToInteger = i -> (int)i.getRealDouble();
    public final Function<I, Long> integerTypeToLong = IntegerType::getIntegerLong;
    public final Function<T, Long> realTypeToLong = i -> (long)i.getRealDouble();
    public final Function<T, Float> realTypeToFloat = ComplexType::getRealFloat;
    public final Function<T, Double> realTypeToDouble = ComplexType::getRealDouble;
}

