/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.convolve;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class NaiveConvolutions {
    public static <I extends RealType<I>, K extends RealType<K>> RandomAccessibleInterval<FloatType> convolveNaiveToFloats(@OpDependency(name="create.img") BiFunction<RandomAccessibleInterval<I>, FloatType, RandomAccessibleInterval<FloatType>> creator, RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel, @Nullable OutOfBoundsFactory<I, RandomAccessibleInterval<I>> outOfBoundsFactory) {
        return NaiveConvolutions.convolveNaive(creator, input, kernel, new FloatType(), outOfBoundsFactory);
    }

    public static <I extends RealType<I>, K extends RealType<K>, O extends RealType<O>> RandomAccessibleInterval<O> convolveNaive(@OpDependency(name="create.img") BiFunction<RandomAccessibleInterval<I>, O, RandomAccessibleInterval<O>> creator, RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel, O outType, @Nullable OutOfBoundsFactory<I, RandomAccessibleInterval<I>> outOfBoundsFactory) {
        RandomAccessibleInterval<O> outImg = creator.apply(input, outType);
        if (outOfBoundsFactory == null) {
            RealType type = (RealType)Util.getTypeFromInterval(input);
            outOfBoundsFactory = new OutOfBoundsConstantValueFactory((Object)((RealType)type.createVariable()));
        }
        NaiveConvolutions.convolveNaive(Views.extend(input, outOfBoundsFactory), kernel, outImg);
        return outImg;
    }

    public static <I extends RealType<I>, K extends RealType<K>, O extends RealType<O>> void convolveNaive(RandomAccessible<I> input, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<O> output) {
        long[] min = new long[input.numDimensions()];
        long[] max = new long[input.numDimensions()];
        for (int d = 0; d < kernel.numDimensions(); ++d) {
            min[d] = -kernel.dimension(d);
            max[d] = kernel.dimension(d) + output.dimension(d);
        }
        RandomAccess inRA = input.randomAccess((Interval)new FinalInterval(min, max));
        Cursor kernelC = Views.iterable(kernel).localizingCursor();
        Cursor outC = Views.iterable(output).localizingCursor();
        long[] pos = new long[input.numDimensions()];
        long[] kernelRadius = new long[kernel.numDimensions()];
        for (int i = 0; i < kernelRadius.length; ++i) {
            kernelRadius[i] = kernel.dimension(i) / 2L;
        }
        while (outC.hasNext()) {
            outC.fwd();
            outC.localize(pos);
            float val = 0.0f;
            inRA.setPosition(pos);
            kernelC.reset();
            while (kernelC.hasNext()) {
                kernelC.fwd();
                for (int i = 0; i < kernelRadius.length; ++i) {
                    if (kernelRadius[i] <= 0L) continue;
                    inRA.setPosition(pos[i] + kernelC.getLongPosition(i) - kernelRadius[i], i);
                }
                val += ((RealType)inRA.get()).getRealFloat() * ((RealType)kernelC.get()).getRealFloat();
            }
            ((RealType)outC.get()).setReal(val);
        }
    }
}

