/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom2d;

import java.util.List;
import java.util.function.Function;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.image.geom.GeomUtils;
import org.scijava.ops.spi.OpDependency;

public class DefaultElongation
implements Computers.Arity1<Polygon2D, DoubleType> {
    @OpDependency(name="geom.smallestEnclosingBoundingBox")
    private Function<Polygon2D, Polygon2D> minimumBoundingBoxFunc;

    public void compute(Polygon2D input, DoubleType elongation) {
        double length;
        List<RealLocalizable> minBB = GeomUtils.vertices(this.minimumBoundingBoxFunc.apply(input));
        RealLocalizable p1 = minBB.get(0);
        RealLocalizable p2 = minBB.get(1);
        RealLocalizable p3 = minBB.get(2);
        double width = Math.sqrt(Math.pow(p1.getDoublePosition(0) - p2.getDoublePosition(0), 2.0) + Math.pow(p1.getDoublePosition(1) - p2.getDoublePosition(1), 2.0));
        if (width > (length = Math.sqrt(Math.pow(p2.getDoublePosition(0) - p3.getDoublePosition(0), 2.0) + Math.pow(p2.getDoublePosition(1) - p3.getDoublePosition(1), 2.0)))) {
            double tmp = width;
            width = length;
            length = tmp;
        }
        elongation.set(1.0 - width / length);
    }
}

