/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.ops.image.image.distancetransform.DefaultDistanceTransform;
import org.scijava.ops.image.image.distancetransform.DistanceTransform2D;
import org.scijava.ops.image.image.distancetransform.DistanceTransform3D;

public class DistanceTransformer<B extends BooleanType<B>, T extends RealType<T>>
implements Computers.Arity1<RandomAccessibleInterval<B>, RandomAccessibleInterval<T>> {
    public void compute(RandomAccessibleInterval<B> binaryInput, RandomAccessibleInterval<T> output) {
        long max_dist = 0L;
        for (int i = 0; i < binaryInput.numDimensions(); ++i) {
            max_dist += binaryInput.dimension(i) * binaryInput.dimension(i);
        }
        if ((double)max_dist > ((RealType)Views.iterable(output).firstElement()).getMaxValue()) {
            throw new IllegalArgumentException("The type of the output image is too small to calculate the Distance Transform on this image!");
        }
        switch (binaryInput.numDimensions()) {
            case 2: {
                DistanceTransform2D.compute(binaryInput, output);
                break;
            }
            case 3: {
                DistanceTransform3D.compute(binaryInput, output);
                break;
            }
            default: {
                DefaultDistanceTransform.compute(binaryInput, output);
            }
        }
    }
}

