/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;

class Phase2Runnable3D<T extends RealType<T>>
implements Runnable {
    private final int[][][] tempValues;
    private final int[][][] tempValues_new;
    private final int xPos;
    private final int zPos;
    private final int height;

    public Phase2Runnable3D(int[][][] tempValues, int[][][] tempValues_new, RandomAccessibleInterval<T> raOut, int xPos, int zPos) {
        this.tempValues = tempValues;
        this.tempValues_new = tempValues_new;
        this.xPos = xPos;
        this.zPos = zPos;
        this.height = (int)raOut.dimension(1);
    }

    private int distancefunc(int x, int i, int raOutValue) {
        return (x - i) * (x - i) + raOutValue * raOutValue;
    }

    private double sep(double i, double u, double w, double v) {
        return (u * u - i * i + w * w - v * v) / (2.0 * (u - i));
    }

    @Override
    public void run() {
        int u;
        int[] s = new int[this.height];
        int[] t = new int[this.height];
        int q = 0;
        s[0] = 0;
        t[0] = 0;
        for (u = 1; u < this.height; ++u) {
            while (q >= 0 && this.distancefunc(t[q], s[q], this.tempValues[this.xPos][s[q]][this.zPos]) > this.distancefunc(t[q], u, this.tempValues[this.xPos][u][this.zPos])) {
                --q;
            }
            if (q < 0) {
                q = 0;
                s[0] = u;
                continue;
            }
            double w = 1.0 + this.sep(s[q], u, this.tempValues[this.xPos][u][this.zPos], this.tempValues[this.xPos][s[q]][this.zPos]);
            if (!(w < (double)this.height)) continue;
            s[++q] = u;
            t[q] = (int)w;
        }
        for (u = this.height - 1; u >= 0; --u) {
            this.tempValues_new[this.xPos][u][this.zPos] = this.distancefunc(u, s[q], this.tempValues[this.xPos][s[q]][this.zPos]);
            if (u != t[q]) continue;
            --q;
        }
    }
}

