/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.segment.detectRidges;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPoint;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.OutOfBoundsConstantValue;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.roi.geom.real.DefaultWritablePolyline;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.image.segment.detectRidges.RidgeDetectionMetadata;
import org.scijava.ops.image.segment.detectRidges.RidgeDetectionUtils;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class DefaultDetectRidges<T extends RealType<T>>
implements Functions.Arity5<RandomAccessibleInterval<T>, Double, Double, Double, Integer, List<DefaultWritablePolyline>> {
    double angleThreshold = 100.0;
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, DoubleType, RandomAccessibleInterval<DoubleType>> createOp;
    @OpDependency(name="convert.float64")
    private Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<DoubleType>> convertOp;
    @OpDependency(name="copy.rai")
    private Function<RandomAccessibleInterval<DoubleType>, RandomAccessibleInterval<DoubleType>> copyOp;
    @OpDependency(name="filter.derivativeGauss")
    private Computers.Arity3<RandomAccessibleInterval<DoubleType>, double[], int[], RandomAccessibleInterval<DoubleType>> partialDerivativeOp;

    private void getNextPoint(RandomAccess<DoubleType> gradientRA, RandomAccess<DoubleType> pRA, RandomAccess<DoubleType> nRA, List<RealPoint> points, int octant, double lastnx, double lastny, double lastpx, double lastpy, Double lowerThreshold) {
        Point currentPos = new Point(gradientRA);
        Point salientPoint = new Point(gradientRA);
        double salientnx = 0.0;
        double salientny = 0.0;
        double salientpx = 0.0;
        double salientpy = 0.0;
        double bestSalience = Double.MAX_VALUE;
        boolean lastPointInLine = true;
        double lastAngle = RidgeDetectionUtils.getAngle(lastnx, lastny);
        for (int i = 1; i < 4; ++i) {
            int[] modifier = RidgeDetectionUtils.getOctantCoords(octant + i);
            gradientRA.move(modifier[0], 0);
            gradientRA.move(modifier[1], 1);
            if (((DoubleType)gradientRA.get()).get() > lowerThreshold) {
                long[] vectorArr = new long[]{gradientRA.getLongPosition(0), gradientRA.getLongPosition(1), 0L};
                nRA.setPosition(vectorArr);
                double nx = ((DoubleType)nRA.get()).get();
                nRA.fwd(2);
                double ny = ((DoubleType)nRA.get()).get();
                pRA.setPosition(vectorArr);
                double px = ((DoubleType)pRA.get()).get();
                pRA.fwd(2);
                double py = ((DoubleType)pRA.get()).get();
                double currentAngle = RidgeDetectionUtils.getAngle(nx, ny);
                double subpixelDiff = Math.sqrt(Math.pow(px - lastpx, 2.0) + Math.pow(py - lastpy, 2.0));
                double angleDiff = Math.abs(currentAngle - lastAngle);
                lastPointInLine = false;
                if (subpixelDiff + angleDiff < bestSalience) {
                    salientPoint = new Point(gradientRA);
                    salientnx = nx;
                    salientny = ny;
                    salientpx = px;
                    salientpy = py;
                    bestSalience = subpixelDiff + angleDiff;
                }
                ((DoubleType)gradientRA.get()).set(0.0);
            }
            gradientRA.setPosition((Localizable)currentPos);
        }
        ((DoubleType)gradientRA.get()).setReal(0.0f);
        if (!lastPointInLine) {
            gradientRA.setPosition((Localizable)salientPoint);
            points.add(RidgeDetectionUtils.get2DRealPoint(gradientRA.getDoublePosition(0) + salientpx, gradientRA.getDoublePosition(1) + salientpy));
            double potentialGradient = RidgeDetectionUtils.getAngle(salientnx, salientny);
            if (lastAngle < this.angleThreshold) {
                lastAngle += 360.0;
            }
            if (potentialGradient < this.angleThreshold) {
                potentialGradient += 360.0;
            }
            if (Math.abs(potentialGradient - lastAngle) > this.angleThreshold) {
                salientnx = -salientnx;
                salientny = -salientny;
            }
            this.getNextPoint(gradientRA, pRA, nRA, points, RidgeDetectionUtils.getOctant(salientnx, salientny), salientnx, salientny, salientpx, salientpy, lowerThreshold);
        }
    }

    public List<DefaultWritablePolyline> apply(RandomAccessibleInterval<T> input, Double width, Double lowerThreshold, Double higherThreshold, @Nullable Integer ridgeLengthMin) {
        if (ridgeLengthMin == null) {
            ridgeLengthMin = 1;
        }
        if (input.numDimensions() != 2) {
            throw new IllegalArgumentException("Input image must be of two dimensions!");
        }
        double sigma = width / (2.0 * Math.sqrt(3.0));
        RidgeDetectionMetadata ridgeDetectionMetadata = new RidgeDetectionMetadata(input, sigma, lowerThreshold, higherThreshold, this.convertOp, this.createOp, this.copyOp, this.partialDerivativeOp);
        Img<DoubleType> p_values = ridgeDetectionMetadata.getPValues();
        Img<DoubleType> n_values = ridgeDetectionMetadata.getNValues();
        Img<DoubleType> gradients = ridgeDetectionMetadata.getGradients();
        OutOfBoundsConstantValueFactory oscvf = new OutOfBoundsConstantValueFactory((Object)new DoubleType(0.0));
        OutOfBoundsConstantValue pRA = oscvf.create(p_values);
        OutOfBoundsConstantValue nRA = oscvf.create(n_values);
        OutOfBoundsConstantValue gradientRA = oscvf.create(gradients);
        ArrayList<DefaultWritablePolyline> lines = new ArrayList<DefaultWritablePolyline>();
        gradientRA.setPosition(RidgeDetectionUtils.getMaxCoords(gradients, true));
        while (Math.abs(((DoubleType)gradientRA.get()).get()) > higherThreshold) {
            ArrayList<RealPoint> points = new ArrayList<RealPoint>();
            long[] eigenvectorPos = new long[]{gradientRA.getLongPosition(0), gradientRA.getLongPosition(1), 0L};
            nRA.setPosition(eigenvectorPos);
            double eigenx = ((DoubleType)nRA.get()).getRealDouble();
            nRA.fwd(2);
            double eigeny = ((DoubleType)nRA.get()).getRealDouble();
            pRA.setPosition(eigenvectorPos);
            double px = ((DoubleType)pRA.get()).getRealDouble();
            pRA.fwd(2);
            double py = ((DoubleType)pRA.get()).getRealDouble();
            points.add(RidgeDetectionUtils.get2DRealPoint(gradientRA.getDoublePosition(0) + px, gradientRA.getDoublePosition(1) + py));
            this.getNextPoint((RandomAccess<DoubleType>)gradientRA, (RandomAccess<DoubleType>)pRA, (RandomAccess<DoubleType>)nRA, points, RidgeDetectionUtils.getOctant(eigenx, eigeny), eigenx, eigeny, px, py, lowerThreshold);
            gradientRA.setPosition(new long[]{eigenvectorPos[0], eigenvectorPos[1]});
            Collections.reverse(points);
            eigenx = -eigenx;
            eigeny = -eigeny;
            this.getNextPoint((RandomAccess<DoubleType>)gradientRA, (RandomAccess<DoubleType>)pRA, (RandomAccess<DoubleType>)nRA, points, RidgeDetectionUtils.getOctant(eigenx, eigeny), eigenx, eigeny, px, py, lowerThreshold);
            ((DoubleType)gradientRA.get()).setReal(0.0f);
            if (points.size() > ridgeLengthMin) {
                DefaultWritablePolyline pline = new DefaultWritablePolyline(points);
                lines.add(pline);
            }
            gradientRA.setPosition(RidgeDetectionUtils.getMaxCoords(gradients, true));
        }
        return lines;
    }
}

