/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.project.project;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import org.scijava.function.Computers;

public class ProjectRAIToIterableInterval<T, V>
implements Computers.Arity3<RandomAccessibleInterval<T>, Computers.Arity1<Iterable<T>, V>, Integer, IterableInterval<V>> {
    public void compute(RandomAccessibleInterval<T> input, Computers.Arity1<Iterable<T>, V> op, Integer dim, IterableInterval<V> output) {
        if (input.numDimensions() != output.numDimensions() + 1) {
            throw new IllegalArgumentException("Input must have one more dimension than output!");
        }
        if (dim >= input.numDimensions()) {
            throw new IllegalArgumentException("The dimension provided to compute over does not exist in the input!");
        }
        Cursor cursor = output.localizingCursor();
        RandomAccess access = input.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            for (int d = 0; d < input.numDimensions(); ++d) {
                if (d == dim) continue;
                access.setPosition(cursor.getIntPosition(d - (d > dim ? -1 : 0)), d);
            }
            op.compute((Object)new DimensionIterable(input.dimension(dim.intValue()), access, dim), cursor.get());
        }
    }

    final class DimensionIterable
    implements Iterable<T> {
        private final long size;
        private final RandomAccess<T> access;
        private final int dim;

        public DimensionIterable(long size, RandomAccess<T> access, int dim) {
            this.size = size;
            this.access = access;
            this.dim = dim;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int k = -1;

                @Override
                public boolean hasNext() {
                    return (long)this.k < DimensionIterable.this.size - 1L;
                }

                @Override
                public T next() {
                    ++this.k;
                    DimensionIterable.this.access.setPosition(this.k, DimensionIterable.this.dim);
                    return DimensionIterable.this.access.get();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }
    }
}

