/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.types.maxValue;

import java.math.BigInteger;
import java.util.function.Function;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.logic.BoolType;
import net.imglib2.type.logic.NativeBoolType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.integer.UnsignedVariableBitLengthType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class MaxValueRealTypes {
    final BitType maxBit = new BitType(true);
    public final Function<BitType, BitType> maxBitType = in -> this.maxBit;
    final BoolType maxBool = new BoolType(true);
    public final Function<BoolType, BoolType> maxBoolType = in -> this.maxBool;
    final NativeBoolType maxNativeBool = new NativeBoolType(true);
    public final Function<NativeBoolType, NativeBoolType> maxNativeBoolType = in -> this.maxNativeBool;
    final ByteType maxByte = new ByteType(127);
    public final Function<ByteType, ByteType> maxByteType = in -> this.maxByte;
    final UnsignedByteType maxUnsignedByte = new UnsignedByteType(255);
    public final Function<UnsignedByteType, UnsignedByteType> maxUnsignedByteType = in -> this.maxUnsignedByte;
    final IntType maxInt = new IntType(Integer.MAX_VALUE);
    public final Function<IntType, IntType> maxIntType = in -> this.maxInt;
    final UnsignedIntType maxUnsignedInt = new UnsignedIntType(0xFFFFFFFFL);
    public final Function<UnsignedIntType, UnsignedIntType> maxUnsignedIntType = in -> this.maxUnsignedInt;
    final LongType maxLong = new LongType(Long.MAX_VALUE);
    public final Function<LongType, LongType> maxLongType = in -> this.maxLong;
    final UnsignedLongType maxUnsignedLong = new UnsignedLongType(new UnsignedLongType().getMaxBigIntegerValue());
    public final Function<UnsignedLongType, UnsignedLongType> maxUnsignedLongType = in -> this.maxUnsignedLong;
    final ShortType maxShort = new ShortType(Short.MAX_VALUE);
    public final Function<ShortType, ShortType> maxShortType = in -> this.maxShort;
    final UnsignedShortType maxUnsignedShort = new UnsignedShortType(65535);
    public final Function<UnsignedShortType, UnsignedShortType> maxUnsignedShortType = in -> this.maxUnsignedShort;
    final FloatType maxFloat = new FloatType(Float.MAX_VALUE);
    public final Function<FloatType, FloatType> maxFloatType = in -> this.maxFloat;
    final DoubleType maxDouble = new DoubleType(Double.MAX_VALUE);
    public final Function<DoubleType, DoubleType> maxDoubleType = in -> this.maxDouble;
    final Unsigned2BitType max2Bit = new Unsigned2BitType(3L);
    public final Function<Unsigned2BitType, Unsigned2BitType> max2BitType = in -> this.max2Bit;
    final Unsigned4BitType max4Bit = new Unsigned4BitType(15L);
    public final Function<Unsigned4BitType, Unsigned4BitType> max4BitType = in -> this.max4Bit;
    final Unsigned12BitType max12Bit = new Unsigned12BitType(4095L);
    public final Function<Unsigned12BitType, Unsigned12BitType> max12BitType = in -> this.max12Bit;
    final Unsigned128BitType max128Bit = new Unsigned128BitType(new Unsigned128BitType().getMaxBigIntegerValue());
    public final Function<Unsigned128BitType, Unsigned128BitType> max128BitType = in -> this.max128Bit;
    public final Function<UnsignedVariableBitLengthType, UnsignedVariableBitLengthType> maxVarLengthType = in -> {
        int nBits = in.getBitsPerPixel();
        if (nBits < 64) {
            long maxVal = (1L << nBits) - 1L;
            return new UnsignedVariableBitLengthType(maxVal, nBits);
        }
        BigInteger maxVal = BigInteger.TWO.pow(nBits - 1).subtract(BigInteger.ONE);
        UnsignedVariableBitLengthType typeMax = new UnsignedVariableBitLengthType(nBits);
        typeMax.setBigInteger(maxVal);
        return typeMax;
    };
}

