/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.DanglingReferenceException;
import org.scijava.java3d.utils.scenegraph.io.NamedObjectException;
import org.scijava.java3d.utils.scenegraph.io.UnsupportedUniverseException;
import org.scijava.java3d.utils.scenegraph.io.retained.StreamControl;
import org.scijava.java3d.utils.universe.SimpleUniverse;

public class SceneGraphStreamWriter {
    private StreamControl control;
    private DataOutputStream out;

    public SceneGraphStreamWriter(OutputStream outputStream) throws IOException {
        this.out = new DataOutputStream(outputStream);
        this.control = new StreamControl(this.out);
        this.control.writeStreamHeader();
    }

    public void writeUniverse(SimpleUniverse universe, boolean writeContent) throws IOException, UnsupportedUniverseException {
        this.control.writeUniverse(this.out, universe, writeContent);
    }

    public void writeBranchGraph(BranchGroup graph, HashMap namedObjects) throws IOException, DanglingReferenceException, NamedObjectException {
        this.control.addNamedObjects(namedObjects);
        this.control.writeBranchGraph(graph, null);
    }

    public void close() throws IOException {
        this.control.close();
        this.out.close();
    }
}

