/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class Annotations {
    private static final CacheMap<Field> fieldCache = new CacheMap();
    private static final CacheMap<Method> methodCache = new CacheMap();

    private Annotations() {
    }

    public static <A extends Annotation> List<Method> annotatedMethods(Class<?> c, Class<A> annotationClass) {
        List<Method> methods = methodCache.getList(c, annotationClass);
        if (methods == null) {
            methods = new ArrayList<Method>();
            Annotations.annotatedMethods(c, annotationClass, methods);
        }
        return methods;
    }

    public static <A extends Annotation> void annotatedMethods(Class<?> c, Class<A> annotationClass, List<Method> methods) {
        List<Method> cachedMethods = methodCache.getList(c, annotationClass);
        if (cachedMethods == null) {
            Query query = new Query();
            query.put(annotationClass, Method.class);
            Annotations.cacheAnnotatedObjects(c, query);
            cachedMethods = methodCache.getList(c, annotationClass);
        }
        if (cachedMethods != null) {
            methods.addAll(cachedMethods);
        }
    }

    public static <A extends Annotation> List<Field> annotatedFields(Class<?> c, Class<A> annotationClass) {
        List<Field> fields = fieldCache.getList(c, annotationClass);
        if (fields == null) {
            fields = new ArrayList<Field>();
            Annotations.annotatedFields(c, annotationClass, fields);
        }
        return fields;
    }

    public static <A extends Annotation> void annotatedFields(Class<?> c, Class<A> annotationClass, List<Field> fields) {
        List<Field> cachedFields = fieldCache.getList(c, annotationClass);
        if (cachedFields == null) {
            Query query = new Query();
            query.put(annotationClass, Field.class);
            Annotations.cacheAnnotatedObjects(c, query);
            cachedFields = fieldCache.getList(c, annotationClass);
        }
        if (cachedFields != null) {
            fields.addAll(cachedFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAnnotatedObjects(Class<?> scannedClass, Query query) {
        Class<?> clazz = scannedClass;
        synchronized (clazz) {
            if (scannedClass == Object.class) {
                return;
            }
            HashSet<Class> keysToDrop = new HashSet<Class>();
            for (Class annotationClass : query.keySet()) {
                if (fieldCache.getList(scannedClass, annotationClass) != null) {
                    keysToDrop.add(annotationClass);
                    continue;
                }
                if (methodCache.getList(scannedClass, annotationClass) == null) continue;
                keysToDrop.add(annotationClass);
            }
            for (Class key : keysToDrop) {
                query.remove(key);
            }
            if (query.isEmpty()) {
                return;
            }
            ArrayList inherited = new ArrayList();
            Class<?> superClass = scannedClass.getSuperclass();
            if (superClass != null) {
                Annotations.cacheAnnotatedObjects(superClass, new Query(query));
                inherited.add(superClass);
            }
            for (Class<?> ifaceClass : scannedClass.getInterfaces()) {
                Annotations.cacheAnnotatedObjects(ifaceClass, new Query(query));
                inherited.add(ifaceClass);
            }
            for (Class annotationClass : query.keySet()) {
                Class objectClass = (Class)query.get(annotationClass);
                try {
                    if (Method.class.isAssignableFrom(objectClass)) {
                        Annotations.populateCache(scannedClass, inherited, (Class)annotationClass, methodCache, (AnnotatedElement[])scannedClass.getDeclaredMethods());
                        continue;
                    }
                    if (!Field.class.isAssignableFrom(objectClass)) continue;
                    Annotations.populateCache(scannedClass, inherited, (Class)annotationClass, fieldCache, (AnnotatedElement[])scannedClass.getDeclaredFields());
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static <T extends AnnotatedElement> void populateCache(Class<?> scannedClass, List<Class<?>> inherited, Class<? extends Annotation> annotationClass, CacheMap<T> cacheMap, T[] declaredElements) {
        for (Class<?> inheritedClass : inherited) {
            List<T> annotatedElements = cacheMap.getList(inheritedClass, annotationClass);
            if (annotatedElements == null || annotatedElements.isEmpty()) continue;
            List<T> scannedElements = cacheMap.makeList(scannedClass, annotationClass);
            scannedElements.addAll(annotatedElements);
        }
        if (declaredElements != null && declaredElements.length > 0) {
            List<T> scannedElements = null;
            for (? extends Annotation t : declaredElements) {
                if (t.getAnnotation(annotationClass) == null) continue;
                if (scannedElements == null) {
                    scannedElements = cacheMap.makeList(scannedClass, annotationClass);
                }
                scannedElements.add(t);
            }
        }
        if (cacheMap.getList(scannedClass, annotationClass) == null) {
            cacheMap.putList(scannedClass, annotationClass, Collections.emptyList());
        }
    }

    private static class Query
    extends HashMap<Class<? extends Annotation>, Class<? extends AnnotatedElement>> {
        public Query() {
        }

        public Query(Query query) {
            super(query);
        }
    }

    private static class CacheMap<T extends AnnotatedElement>
    extends HashMap<Class<?>, Map<Class<? extends Annotation>, List<T>>> {
        private CacheMap() {
        }

        public List<T> getList(Class<?> c, Class<? extends Annotation> annotationClass) {
            Map annotationTypes = (Map)this.get(c);
            return annotationTypes == null ? null : (List)annotationTypes.get(annotationClass);
        }

        public void putList(Class<?> c, Class<? extends Annotation> annotationClass, List<T> annotatedElements) {
            HashMap<Class<? extends Annotation>, List<T>> map = (HashMap<Class<? extends Annotation>, List<T>>)this.get(c);
            if (map == null) {
                map = new HashMap<Class<? extends Annotation>, List<T>>();
                this.put(c, map);
            }
            map.put(annotationClass, annotatedElements);
        }

        public List<T> makeList(Class<?> c, Class<? extends Annotation> annotationClass) {
            List<T> elements = this.getList(c, annotationClass);
            if (elements == null) {
                elements = new ArrayList<T>();
                this.putList(c, annotationClass, elements);
            }
            return elements;
        }
    }
}

