/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.closegaps;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.closegaps.GapClosingMethod;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsIO;
import fiji.plugin.trackmate.io.TmXmlReader;
import fiji.plugin.trackmate.visualization.hyperstack.HyperStackDisplayer;
import fiji.plugin.trackmate.visualization.trackscheme.TrackScheme;
import ij.ImageJ;
import ij.ImagePlus;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.util.Util;
import org.jgrapht.graph.DefaultWeightedEdge;

public class CloseGapsByDetection
implements GapClosingMethod {
    public static final String INFO_TEXT = "<html>This method allows to close gaps in tracks by executing a detection in the vicinity of linearly interpolated position over a gap.<p>The same detector and detection settings than for the initial detection step are used. The search volume is built by taking a box of twice the interpolated radius of the source and target spots at the gap.<p>This method is best if there is a single spot near a missed detection that could be recognized by the detection process executed in a smaller region. It is well suited to be used with detectors that use a normalized threshold, like the Hessian detector.</html>";
    public static final String NAME = "Close gaps by detection";
    private final GapClosingMethod.GapClosingParameter radiusFactor = new GapClosingMethod.GapClosingParameter("Radius factor", 2.0, 0.1, 10.0);

    @Override
    public List<GapClosingMethod.GapClosingParameter> getParameters() {
        return Collections.singletonList(this.radiusFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TrackMate trackmate, Logger logger) {
        Model model = trackmate.getModel();
        TrackModel trackModel = model.getTrackModel();
        model.beginUpdate();
        try {
            ArrayDeque<DefaultWeightedEdge> gaps = new ArrayDeque<DefaultWeightedEdge>(GapClosingMethod.getAllGaps(model));
            int progress = 0;
            int nTasks = GapClosingMethod.countMissingSpots(gaps, model);
            block3: while (!gaps.isEmpty()) {
                DefaultWeightedEdge gap = gaps.poll();
                List<Spot> spots = GapClosingMethod.interpolate(model, gap);
                Spot source = trackModel.getEdgeSource(gap);
                for (Spot spot : spots) {
                    logger.setProgress((double)progress++ / (double)nTasks);
                    int t = spot.getFeature("FRAME").intValue();
                    Settings settings = GapClosingMethod.makeSettingsForRoiAround(spot, this.radiusFactor.value, trackmate.getSettings());
                    TrackMate localTM = new TrackMate(settings);
                    localTM.getModel().setLogger(Logger.VOID_LOGGER);
                    localTM.setNumThreads(trackmate.getNumThreads());
                    if (!localTM.execDetection()) {
                        logger.error("Error detecting spots around position " + Util.printCoordinates((RealLocalizable)source) + " at frame " + t + ":\n" + localTM.getErrorMessage());
                        continue;
                    }
                    Spot candidate = null;
                    for (Spot s : localTM.getModel().getSpots().iterable(t, false)) {
                        if (candidate != null && !(s.diffTo(candidate, "QUALITY") > 0.0)) continue;
                        candidate = s;
                    }
                    if (candidate == null) {
                        logger.log("Could not find a suitable spot around position " + Util.printCoordinates((RealLocalizable)spot) + " at frame " + t + ".\n");
                        continue;
                    }
                    model.addSpotTo(candidate, t);
                    DefaultWeightedEdge sourceCandidateEdge = model.addEdge(source, candidate, 1.0);
                    Spot target = trackModel.getEdgeTarget(gap);
                    DefaultWeightedEdge candidateTargetEdge = model.addEdge(candidate, target, 1.0);
                    model.removeEdge(gap);
                    if (GapClosingMethod.countMissingSpots(sourceCandidateEdge, model) > 1) {
                        gaps.push(sourceCandidateEdge);
                    }
                    if (GapClosingMethod.countMissingSpots(candidateTargetEdge, model) <= 1) continue block3;
                    gaps.push(candidateTargetEdge);
                    continue block3;
                }
            }
        }
        finally {
            model.endUpdate();
        }
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    public String toString() {
        return NAME;
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        String filePath = "/Users/tinevez/Desktop/GaelleGapClosingWeirdBug/211116 Movie FDB YFP_Movie 0-01-Scene-64-TR114-zeroed.xml";
        TmXmlReader reader = new TmXmlReader(new File("/Users/tinevez/Desktop/GaelleGapClosingWeirdBug/211116 Movie FDB YFP_Movie 0-01-Scene-64-TR114-zeroed.xml"));
        if (!reader.isReadingOk()) {
            System.err.println(reader.getErrorMessage());
            return;
        }
        Model model = reader.getModel();
        ImagePlus imp = reader.readImage();
        Settings settings = reader.readSettings(imp);
        TrackMate trackmate = new TrackMate(model, settings);
        trackmate.setNumThreads(5);
        settings.detectorSettings.put("RADIUS", 8.0);
        CloseGapsByDetection gapCloser = new CloseGapsByDetection();
        gapCloser.getParameters().get((int)0).value = 2.0;
        gapCloser.execute(trackmate, Logger.DEFAULT_LOGGER);
        SelectionModel selectionModel = new SelectionModel(model);
        DisplaySettings ds = DisplaySettingsIO.readUserDefault();
        ds.setSpotColorBy(DisplaySettings.TrackMateObject.TRACKS, "TRACK_INDEX");
        ds.setTrackColorBy(DisplaySettings.TrackMateObject.TRACKS, "TRACK_INDEX");
        new TrackScheme(model, selectionModel, ds).render();
        new HyperStackDisplayer(model, selectionModel, settings.imp, ds).render();
    }
}

