/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.LogHistogramDataset;
import fiji.plugin.trackmate.gui.components.XYTextSimpleAnnotation;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import fiji.util.NumberParser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class FilterPanel
extends JPanel {
    static final Font FONT = new Font("Arial", 0, 11);
    static final Font SMALL_FONT = FONT.deriveFont(10.0f);
    private static final Color annotationColor;
    private static final long serialVersionUID = 1L;
    private static final String DATA_SERIES_NAME = "Data";
    private final ChangeEvent CHANGE_EVENT = new ChangeEvent(this);
    private final XYPlot plot;
    private final IntervalMarker intervalMarker;
    private double threshold;
    private final Function<String, double[]> valueCollector;
    private final XYTextSimpleAnnotation annotation;
    private final ArrayList<ChangeListener> listeners = new ArrayList();
    final JRadioButton rdbtnAbove;
    final JRadioButton rdbtnBelow;
    final JComboBox<String> cmbboxFeatureKeys;

    public FilterPanel(final Map<String, String> keyNames, Function<String, double[]> valueCollector, FeatureFilter filter) {
        MouseListener[] mls;
        this.valueCollector = valueCollector;
        Dimension panelSize = new Dimension(250, 140);
        Dimension panelMaxSize = new Dimension(1000, 140);
        GridBagLayout thisLayout = new GridBagLayout();
        thisLayout.rowWeights = new double[]{0.0, 1.0, 0.0};
        thisLayout.rowHeights = new int[]{10, 7, 15};
        thisLayout.columnWeights = new double[]{0.0, 0.0, 1.0};
        thisLayout.columnWidths = new int[]{7, 20, 7};
        this.setLayout(thisLayout);
        this.setPreferredSize(panelSize);
        this.setMaximumSize(panelMaxSize);
        this.setBorder(new LineBorder(annotationColor, 1, true));
        DefaultComboBoxModel<String> cmbboxFeatureNameModel = new DefaultComboBoxModel<String>(keyNames.keySet().toArray(new String[0]));
        this.cmbboxFeatureKeys = new JComboBox<String>(cmbboxFeatureNameModel);
        this.cmbboxFeatureKeys.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel lbl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                lbl.setText((String)keyNames.get(value));
                return lbl;
            }
        });
        this.cmbboxFeatureKeys.setFont(FONT);
        this.add(this.cmbboxFeatureKeys, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        LogHistogramDataset dataset = new LogHistogramDataset();
        JFreeChart chart = ChartFactory.createHistogram(null, null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.plot = chart.getXYPlot();
        XYBarRenderer renderer = (XYBarRenderer)this.plot.getRenderer();
        renderer.setShadowVisible(false);
        renderer.setMargin(0.0);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setSeriesOutlinePaint(0, (Paint)new Color(0.2f, 0.2f, 0.2f));
        renderer.setSeriesPaint(0, (Paint)new Color(0.3f, 0.3f, 0.3f, 0.5f));
        this.plot.setBackgroundPaint((Paint)new Color(1, 1, 1, 0));
        this.plot.setOutlineVisible(false);
        this.plot.setDomainCrosshairVisible(false);
        this.plot.setDomainGridlinesVisible(false);
        this.plot.setRangeCrosshairVisible(false);
        this.plot.setRangeGridlinesVisible(false);
        this.plot.getRangeAxis().setVisible(false);
        this.plot.getDomainAxis().setVisible(false);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint((Paint)new Color(0.6f, 0.6f, 0.7f));
        this.intervalMarker = new IntervalMarker(0.0, 0.0, (Paint)new Color(0.3f, 0.5f, 0.8f), (Stroke)new BasicStroke(), (Paint)new Color(0.0f, 0.0f, 0.5f), (Stroke)new BasicStroke(1.5f), 0.5f);
        this.plot.addDomainMarker((Marker)this.intervalMarker);
        final ChartPanel chartPanel = new ChartPanel(chart);
        for (MouseListener ml : mls = chartPanel.getMouseListeners()) {
            chartPanel.removeMouseListener(ml);
        }
        chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                chartPanel.requestFocusInWindow();
                FilterPanel.this.threshold = FilterPanel.this.getXFromChartEvent(e, chartPanel);
                FilterPanel.this.redrawThresholdMarker();
            }
        });
        chartPanel.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                FilterPanel.this.threshold = FilterPanel.this.getXFromChartEvent(e, chartPanel);
                FilterPanel.this.redrawThresholdMarker();
            }
        });
        chartPanel.setFocusable(true);
        chartPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                FilterPanel.this.annotation.setColor(annotationColor.darker());
            }

            @Override
            public void focusGained(FocusEvent e) {
                FilterPanel.this.annotation.setColor(Color.RED.darker());
            }
        });
        chartPanel.addKeyListener((KeyListener)new MyKeyListener());
        this.annotation = new XYTextSimpleAnnotation(chartPanel);
        this.annotation.setFont(SMALL_FONT.deriveFont(1));
        this.annotation.setColor(annotationColor.darker());
        this.plot.addAnnotation((XYAnnotation)this.annotation);
        chartPanel.setPreferredSize(new Dimension(0, 0));
        this.add((Component)chartPanel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        chartPanel.setOpaque(false);
        JButton btnAutoThreshold = new JButton();
        this.add((Component)btnAutoThreshold, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        btnAutoThreshold.setText("Auto");
        btnAutoThreshold.setFont(SMALL_FONT);
        btnAutoThreshold.addActionListener(e -> this.autoThreshold());
        this.rdbtnAbove = new JRadioButton();
        this.add((Component)this.rdbtnAbove, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.rdbtnAbove.setText("Above");
        this.rdbtnAbove.setFont(SMALL_FONT);
        this.rdbtnAbove.addActionListener(e -> this.redrawThresholdMarker());
        this.rdbtnBelow = new JRadioButton();
        this.add((Component)this.rdbtnBelow, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.rdbtnBelow.setText("Below");
        this.rdbtnBelow.addActionListener(e -> this.redrawThresholdMarker());
        this.rdbtnBelow.setFont(SMALL_FONT);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rdbtnAbove);
        buttonGroup.add(this.rdbtnBelow);
        this.cmbboxFeatureKeys.addActionListener(e -> this.comboBoxSelectionChanged());
        this.cmbboxFeatureKeys.setSelectedItem(filter.feature);
        this.rdbtnAbove.setSelected(filter.isAbove);
        this.rdbtnBelow.setSelected(!filter.isAbove);
        if (Double.isNaN(filter.value)) {
            this.autoThreshold();
        } else {
            this.threshold = filter.value;
        }
        this.redrawThresholdMarker();
    }

    public FeatureFilter getFilter() {
        return new FeatureFilter((String)this.cmbboxFeatureKeys.getSelectedItem(), this.threshold, this.rdbtnAbove.isSelected());
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeChangeListener(ChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public Collection<ChangeListener> getChangeListeners() {
        return this.listeners;
    }

    public void refresh() {
        LogHistogramDataset dataset;
        double old = this.threshold;
        String key = (String)this.cmbboxFeatureKeys.getSelectedItem();
        double[] values = this.valueCollector.apply(key);
        if (null == values || 0 == values.length) {
            dataset = new LogHistogramDataset();
            this.annotation.setLocation(0.5f, 0.5f);
            this.annotation.setText("No data");
        } else {
            int nBins = TMUtils.getNBins(values, 8, 100);
            dataset = new LogHistogramDataset();
            if (nBins > 1) {
                dataset.addSeries((Comparable)((Object)DATA_SERIES_NAME), values, nBins);
            }
        }
        this.plot.setDataset((XYDataset)dataset);
        this.threshold = old;
        this.repaint();
        this.redrawThresholdMarker();
    }

    private void fireThresholdChanged() {
        for (ChangeListener al : this.listeners) {
            al.stateChanged(this.CHANGE_EVENT);
        }
    }

    private void comboBoxSelectionChanged() {
        LogHistogramDataset dataset;
        String key = (String)this.cmbboxFeatureKeys.getSelectedItem();
        double[] values = this.valueCollector.apply(key);
        if (null == values || 0 == values.length) {
            dataset = new LogHistogramDataset();
            this.threshold = Double.NaN;
            this.annotation.setLocation(0.5f, 0.5f);
            this.annotation.setText("No data");
            this.fireThresholdChanged();
        } else {
            int nBins = TMUtils.getNBins(values, 8, 100);
            dataset = new LogHistogramDataset();
            if (nBins > 1) {
                dataset.addSeries((Comparable)((Object)DATA_SERIES_NAME), values, nBins);
            }
        }
        this.plot.setDataset((XYDataset)dataset);
        this.resetAxes();
        this.autoThreshold();
    }

    private void autoThreshold() {
        String key = (String)this.cmbboxFeatureKeys.getSelectedItem();
        double[] values = this.valueCollector.apply(key);
        if (null != values && values.length > 0) {
            this.threshold = TMUtils.otsuThreshold(values);
            this.redrawThresholdMarker();
        }
    }

    private double getXFromChartEvent(MouseEvent mouseEvent, ChartPanel chartPanel) {
        Rectangle2D plotArea = chartPanel.getScreenDataArea();
        return this.plot.getDomainAxis().java2DToValue((double)mouseEvent.getX(), plotArea, this.plot.getDomainAxisEdge());
    }

    private void redrawThresholdMarker() {
        String key = (String)this.cmbboxFeatureKeys.getSelectedItem();
        double[] values = this.valueCollector.apply(key);
        if (null == values) {
            return;
        }
        if (this.rdbtnAbove.isSelected()) {
            this.intervalMarker.setStartValue(this.threshold);
            this.intervalMarker.setEndValue(this.plot.getDomainAxis().getUpperBound());
        } else {
            this.intervalMarker.setStartValue(this.plot.getDomainAxis().getLowerBound());
            this.intervalMarker.setEndValue(this.threshold);
        }
        float x = this.threshold > 0.85 * this.plot.getDomainAxis().getUpperBound() ? (float)(this.threshold - 0.15 * this.plot.getDomainAxis().getRange().getLength()) : (float)(this.threshold + 0.05 * this.plot.getDomainAxis().getRange().getLength());
        float y = (float)(0.85 * this.plot.getRangeAxis().getUpperBound());
        this.annotation.setText(String.format("%.2f", this.threshold));
        this.annotation.setLocation(x, y);
        this.fireThresholdChanged();
    }

    private void resetAxes() {
        this.plot.getRangeAxis().setLowerMargin(0.0);
        this.plot.getRangeAxis().setUpperMargin(0.0);
        this.plot.getDomainAxis().setLowerMargin(0.0);
        this.plot.getDomainAxis().setUpperMargin(0.0);
    }

    static {
        Color bgColor = UIManager.getColor("Panel.background");
        boolean bgIsDark = GuiUtils.colorDistance(Color.WHITE, bgColor) > 0.5;
        annotationColor = bgIsDark ? new Color(252, 117, 0).brighter() : new Color(252, 117, 0);
    }

    private final class MyKeyListener
    implements KeyListener {
        private static final long WAIT_DELAY = 1L;
        private static final double INCREASE_FACTOR = 0.1;
        private static final double SLOW_INCREASE_FACTOR = 0.005;
        private String strNumber = "";
        private ScheduledExecutorService ex;
        private ScheduledFuture<?> future;
        private boolean dotAdded = false;
        private final Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    double typedThreshold;
                    FilterPanel.this.threshold = typedThreshold = NumberParser.parseDouble((String)MyKeyListener.this.strNumber);
                    FilterPanel.this.redrawThresholdMarker();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                MyKeyListener.this.ex = null;
                MyKeyListener.this.strNumber = "";
                MyKeyListener.this.dotAdded = false;
            }
        };

        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                FilterPanel.this.threshold = FilterPanel.this.threshold - (e.isControlDown() ? 0.005 : 0.1) * FilterPanel.this.plot.getDomainAxis().getRange().getLength();
                FilterPanel.this.redrawThresholdMarker();
                return;
            }
            if (e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                FilterPanel.this.threshold = FilterPanel.this.threshold + (e.isControlDown() ? 0.005 : 0.1) * FilterPanel.this.plot.getDomainAxis().getRange().getLength();
                FilterPanel.this.redrawThresholdMarker();
                return;
            }
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                FilterPanel.this.threshold = FilterPanel.this.plot.getDomainAxis().getRange().getUpperBound();
                FilterPanel.this.redrawThresholdMarker();
                return;
            }
            if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                FilterPanel.this.threshold = FilterPanel.this.plot.getDomainAxis().getRange().getLowerBound();
                FilterPanel.this.redrawThresholdMarker();
                return;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() < '0' || e.getKeyChar() > '9') {
                if (!this.dotAdded && e.getKeyChar() == '.') {
                    this.dotAdded = true;
                } else {
                    return;
                }
            }
            if (this.ex == null) {
                this.ex = Threads.newSingleThreadScheduledExecutor();
                this.future = this.ex.schedule(this.command, 1L, TimeUnit.SECONDS);
            } else {
                this.future.cancel(false);
                this.future = this.ex.schedule(this.command, 1L, TimeUnit.SECONDS);
            }
            this.strNumber = this.strNumber + e.getKeyChar();
        }
    }
}

