/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.io;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactoryBase;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettingsIO;
import fiji.plugin.trackmate.io.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TmXmlWriter {
    protected final Element root = new Element("TrackMate");
    protected final Logger logger;
    private final File file;

    public TmXmlWriter(File file) {
        this(file, new Logger.StringBuilderLogger());
    }

    public TmXmlWriter(File file, Logger logger) {
        this.root.setAttribute("version", TrackMate.PLUGIN_NAME_VERSION);
        this.logger = logger;
        this.file = file;
    }

    public void writeToFile() throws FileNotFoundException, IOException {
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            this.logger.log("  Writing to file.\n");
            Document document = new Document(this.root);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(document, (OutputStream)fos);
        }
    }

    public String toString() {
        Document document = new Document(this.root);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        StringWriter writer = new StringWriter();
        try {
            outputter.output(document, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public void appendModel(Model model) {
        Element modelElement = new Element("Model");
        modelElement.setAttribute("spatialunits", model.getSpaceUnits());
        modelElement.setAttribute("timeunits", model.getTimeUnits());
        Element featureDeclarationElement = this.echoFeaturesDeclaration(model);
        modelElement.addContent((Content)featureDeclarationElement);
        Element spotElement = this.echoSpots(model);
        modelElement.addContent((Content)spotElement);
        Element trackElement = this.echoTracks(model);
        modelElement.addContent((Content)trackElement);
        Element filteredTrackElement = this.echoFilteredTracks(model);
        modelElement.addContent((Content)filteredTrackElement);
        this.root.addContent((Content)modelElement);
    }

    public void appendSettings(Settings settings) {
        Element settingsElement = new Element("Settings");
        Element imageInfoElement = this.echoImageInfo(settings);
        settingsElement.addContent((Content)imageInfoElement);
        Element cropElement = this.echoCropSettings(settings);
        settingsElement.addContent((Content)cropElement);
        Element detectorElement = this.echoDetectorSettings(settings);
        settingsElement.addContent((Content)detectorElement);
        Element initFilter = this.echoInitialSpotFilter(settings);
        settingsElement.addContent((Content)initFilter);
        Element spotFiltersElement = this.echoSpotFilters(settings);
        settingsElement.addContent((Content)spotFiltersElement);
        Element trackerElement = this.echoTrackerSettings(settings);
        settingsElement.addContent((Content)trackerElement);
        Element trackFiltersElement = this.echoTrackFilters(settings);
        settingsElement.addContent((Content)trackFiltersElement);
        Element analyzersElement = this.echoAnalyzers(settings);
        settingsElement.addContent((Content)analyzersElement);
        this.root.addContent((Content)settingsElement);
    }

    public void appendLog(String log) {
        if (null != log) {
            Element logElement = new Element("Log");
            logElement.addContent(IOUtils.cleanInvalidXmlChars(log));
            this.root.addContent((Content)logElement);
            this.logger.log("  Added log.\n");
        }
    }

    public void appendGUIState(String currentPanelIdentifier) {
        Element guiel = new Element("GUIState");
        guiel.setAttribute("state", currentPanelIdentifier);
        this.root.addContent((Content)guiel);
        this.logger.log("  Added GUI current state.\n");
    }

    public void appendDisplaySettings(DisplaySettings ds) {
        Element dsel = new Element("DisplaySettings");
        DisplaySettingsIO.toXML(ds, dsel);
        this.root.addContent((Content)dsel);
        this.logger.log("  Added display settings.\n");
    }

    private Element echoCropSettings(Settings settings) {
        Element settingsElement = new Element("BasicSettings");
        settingsElement.setAttribute("xstart", "" + settings.getXstart());
        settingsElement.setAttribute("xend", "" + settings.getXend());
        settingsElement.setAttribute("ystart", "" + settings.getYstart());
        settingsElement.setAttribute("yend", "" + settings.getYend());
        settingsElement.setAttribute("zstart", "" + settings.zstart);
        settingsElement.setAttribute("zend", "" + settings.zend);
        settingsElement.setAttribute("tstart", "" + settings.tstart);
        settingsElement.setAttribute("tend", "" + settings.tend);
        this.logger.log("  Added crop settings.\n");
        return settingsElement;
    }

    protected Element echoDetectorSettings(Settings settings) {
        Element el = new Element("DetectorSettings");
        if (null == settings.detectorFactory) {
            return el;
        }
        el.setAttribute("DETECTOR_NAME", settings.detectorFactory.getKey());
        if (null != settings.detectorFactory) {
            String errorMessage = settings.detectorFactory.marshal(settings.detectorSettings, el);
            if (errorMessage != null) {
                this.logger.error(errorMessage);
            } else {
                this.logger.log("  Added detector settings.\n");
            }
        }
        return el;
    }

    protected Element echoTrackerSettings(Settings settings) {
        Element el = new Element("TrackerSettings");
        if (null == settings.trackerFactory) {
            return el;
        }
        el.setAttribute("TRACKER_NAME", settings.trackerFactory.getKey());
        if (null != settings.trackerFactory) {
            String error = settings.trackerFactory.marshal(settings.trackerSettings, el);
            if (error != null) {
                this.logger.error(error);
            } else {
                this.logger.log("  Added tracker settings.\n");
            }
        }
        return el;
    }

    private Element echoTracks(Model model) {
        Element allTracksElement = new Element("AllTracks");
        ArrayList<String> trackFeatures = new ArrayList<String>(model.getFeatureModel().getTrackFeatures());
        trackFeatures.remove("TRACK_ID");
        ArrayList<String> edgeFeatures = new ArrayList<String>(model.getFeatureModel().getEdgeFeatures());
        edgeFeatures.remove("SPOT_SOURCE_ID");
        edgeFeatures.remove("SPOT_TARGET_ID");
        Set<Integer> trackIDs = model.getTrackModel().trackIDs(false);
        for (int trackID : trackIDs) {
            Element trackElement = new Element("Track");
            trackElement.setAttribute("name", model.getTrackModel().name(trackID));
            trackElement.setAttribute("TRACK_ID", Integer.toString(trackID));
            for (String feature : trackFeatures) {
                Double val = model.getFeatureModel().getTrackFeature(trackID, feature);
                if (null == val) continue;
                String str = model.getFeatureModel().getTrackFeatureIsInt().get(feature) != false ? Integer.toString(val.intValue()) : val.toString();
                trackElement.setAttribute(feature, str);
            }
            Set<DefaultWeightedEdge> track = model.getTrackModel().trackEdges(trackID);
            if (track.isEmpty()) continue;
            for (DefaultWeightedEdge edge : track) {
                int targetID;
                int sourceID;
                Element edgeElement = new Element("Edge");
                int sourceFrame = model.getTrackModel().getEdgeSource(edge).getFeature("FRAME").intValue();
                int targetFrame = model.getTrackModel().getEdgeTarget(edge).getFeature("FRAME").intValue();
                if (targetFrame >= sourceFrame) {
                    sourceID = model.getTrackModel().getEdgeSource(edge).ID();
                    targetID = model.getTrackModel().getEdgeTarget(edge).ID();
                } else {
                    sourceID = model.getTrackModel().getEdgeTarget(edge).ID();
                    targetID = model.getTrackModel().getEdgeSource(edge).ID();
                }
                edgeElement.setAttribute("SPOT_SOURCE_ID", Integer.toString(sourceID));
                edgeElement.setAttribute("SPOT_TARGET_ID", Integer.toString(targetID));
                for (String feature : edgeFeatures) {
                    Double val = model.getFeatureModel().getEdgeFeature(edge, feature);
                    if (null == val) continue;
                    String str = model.getFeatureModel().getEdgeFeatureIsInt().get(feature) != false ? Integer.toString(val.intValue()) : val.toString();
                    edgeElement.setAttribute(feature, str);
                }
                trackElement.addContent((Content)edgeElement);
            }
            allTracksElement.addContent((Content)trackElement);
        }
        this.logger.log("  Added tracks.\n");
        return allTracksElement;
    }

    private Element echoFilteredTracks(Model model) {
        Element filteredTracksElement = new Element("FilteredTracks");
        Set<Integer> filteredTrackKeys = model.getTrackModel().trackIDs(true);
        for (int trackID : filteredTrackKeys) {
            Element trackIDElement = new Element("TrackID");
            trackIDElement.setAttribute("TRACK_ID", "" + trackID);
            filteredTracksElement.addContent((Content)trackIDElement);
        }
        this.logger.log("  Added filtered tracks.\n");
        return filteredTracksElement;
    }

    protected Element echoImageInfo(Settings settings) {
        Element imEl = new Element("ImageData");
        String imFileName = settings.imageFileName == null ? "" : settings.imageFileName;
        imEl.setAttribute("filename", imFileName);
        String imFolder = settings.imageFolder == null ? "" : settings.imageFolder;
        imEl.setAttribute("folder", imFolder);
        imEl.setAttribute("width", "" + settings.width);
        imEl.setAttribute("height", "" + settings.height);
        imEl.setAttribute("nslices", "" + settings.nslices);
        imEl.setAttribute("nframes", "" + settings.nframes);
        imEl.setAttribute("pixelwidth", "" + settings.dx);
        imEl.setAttribute("pixelheight", "" + settings.dy);
        imEl.setAttribute("voxeldepth", "" + settings.dz);
        imEl.setAttribute("timeinterval", "" + settings.dt);
        this.logger.log("  Added image information.\n");
        return imEl;
    }

    private Element echoSpots(Model model) {
        SpotCollection spots = model.getSpots();
        Element spotCollectionElement = new Element("AllSpots");
        spotCollectionElement.setAttribute("nspots", "" + spots.getNSpots(false));
        for (int frame : spots.keySet()) {
            Element frameSpotsElement = new Element("SpotsInFrame");
            frameSpotsElement.setAttribute("frame", "" + frame);
            Iterator<Spot> it = spots.iterator(frame, false);
            while (it.hasNext()) {
                Element spotElement = TmXmlWriter.marshalSpot(it.next(), model.getFeatureModel());
                frameSpotsElement.addContent((Content)spotElement);
            }
            spotCollectionElement.addContent((Content)frameSpotsElement);
        }
        this.logger.log("  Added " + spots.getNSpots(false) + " spots.\n");
        return spotCollectionElement;
    }

    private Element echoFeaturesDeclaration(Model model) {
        FeatureModel fm = model.getFeatureModel();
        Element featuresElement = new Element("FeatureDeclarations");
        Element spotFeaturesElement = new Element("SpotFeatures");
        Collection<String> features = fm.getSpotFeatures();
        Map<String, String> featureNames = fm.getSpotFeatureNames();
        Map<String, String> featureShortNames = fm.getSpotFeatureShortNames();
        Map<String, Dimension> featureDimensions = fm.getSpotFeatureDimensions();
        Map<String, Boolean> featureIsInt = fm.getSpotFeatureIsInt();
        for (String string : features) {
            Element fel = new Element("Feature");
            fel.setAttribute("feature", string);
            fel.setAttribute("name", featureNames.get(string));
            fel.setAttribute("shortname", featureShortNames.get(string));
            fel.setAttribute("dimension", featureDimensions.get(string).name());
            fel.setAttribute("isint", featureIsInt.get(string).toString());
            spotFeaturesElement.addContent((Content)fel);
        }
        featuresElement.addContent((Content)spotFeaturesElement);
        Element edgeFeaturesElement = new Element("EdgeFeatures");
        features = fm.getEdgeFeatures();
        featureNames = fm.getEdgeFeatureNames();
        featureShortNames = fm.getEdgeFeatureShortNames();
        featureDimensions = fm.getEdgeFeatureDimensions();
        featureIsInt = fm.getEdgeFeatureIsInt();
        for (String feature : features) {
            Element fel = new Element("Feature");
            fel.setAttribute("feature", feature);
            fel.setAttribute("name", featureNames.get(feature));
            fel.setAttribute("shortname", featureShortNames.get(feature));
            fel.setAttribute("dimension", featureDimensions.get(feature).name());
            fel.setAttribute("isint", featureIsInt.get(feature).toString());
            edgeFeaturesElement.addContent((Content)fel);
        }
        featuresElement.addContent((Content)edgeFeaturesElement);
        Element element = new Element("TrackFeatures");
        features = fm.getTrackFeatures();
        featureNames = fm.getTrackFeatureNames();
        featureShortNames = fm.getTrackFeatureShortNames();
        featureDimensions = fm.getTrackFeatureDimensions();
        featureIsInt = fm.getTrackFeatureIsInt();
        for (String feature : features) {
            Element fel = new Element("Feature");
            fel.setAttribute("feature", feature);
            fel.setAttribute("name", featureNames.get(feature));
            fel.setAttribute("shortname", featureShortNames.get(feature));
            fel.setAttribute("dimension", featureDimensions.get(feature).name());
            fel.setAttribute("isint", featureIsInt.get(feature).toString());
            element.addContent((Content)fel);
        }
        featuresElement.addContent((Content)element);
        this.logger.log("  Added spot, edge and track feature declarations.\n");
        return featuresElement;
    }

    protected Element echoInitialSpotFilter(Settings settings) {
        Element itElement = new Element("InitialSpotFilter");
        itElement.setAttribute("feature", "QUALITY");
        itElement.setAttribute("value", "" + settings.initialSpotFilterValue);
        itElement.setAttribute("isabove", "true");
        this.logger.log("  Added initial spot filter.\n");
        return itElement;
    }

    protected Element echoSpotFilters(Settings settings) {
        List<FeatureFilter> featureThresholds = settings.getSpotFilters();
        Element filtersElement = new Element("SpotFilterCollection");
        for (FeatureFilter threshold : featureThresholds) {
            Element thresholdElement = new Element("Filter");
            thresholdElement.setAttribute("feature", threshold.feature);
            thresholdElement.setAttribute("value", Double.toString(threshold.value));
            thresholdElement.setAttribute("isabove", "" + threshold.isAbove);
            filtersElement.addContent((Content)thresholdElement);
        }
        this.logger.log("  Added spot feature filters.\n");
        return filtersElement;
    }

    protected Element echoTrackFilters(Settings settings) {
        List<FeatureFilter> filters = settings.getTrackFilters();
        Element trackFiltersElement = new Element("TrackFilterCollection");
        for (FeatureFilter filter : filters) {
            Element thresholdElement = new Element("Filter");
            thresholdElement.setAttribute("feature", filter.feature);
            thresholdElement.setAttribute("value", Double.toString(filter.value));
            thresholdElement.setAttribute("isabove", "" + filter.isAbove);
            trackFiltersElement.addContent((Content)thresholdElement);
        }
        this.logger.log("  Added track feature filters.\n");
        return trackFiltersElement;
    }

    protected Element echoAnalyzers(Settings settings) {
        Element analyzersElement = new Element("AnalyzerCollection");
        Element spotAnalyzersEl = new Element("SpotAnalyzers");
        for (SpotAnalyzerFactoryBase<?> spotAnalyzerFactoryBase : settings.getSpotAnalyzerFactories()) {
            Element el = new Element("Analyzer");
            el.setAttribute("key", spotAnalyzerFactoryBase.getKey());
            spotAnalyzersEl.addContent((Content)el);
        }
        analyzersElement.addContent((Content)spotAnalyzersEl);
        Element edgeAnalyzersEl = new Element("EdgeAnalyzers");
        for (EdgeAnalyzer analyzer : settings.getEdgeAnalyzers()) {
            Element el = new Element("Analyzer");
            el.setAttribute("key", analyzer.getKey());
            edgeAnalyzersEl.addContent((Content)el);
        }
        analyzersElement.addContent((Content)edgeAnalyzersEl);
        Element element = new Element("TrackAnalyzers");
        for (TrackAnalyzer analyzer : settings.getTrackAnalyzers()) {
            Element el = new Element("Analyzer");
            el.setAttribute("key", analyzer.getKey());
            element.addContent((Content)el);
        }
        analyzersElement.addContent((Content)element);
        this.logger.log("  Added spot, edge and track analyzers.\n");
        return analyzersElement;
    }

    private static final Element marshalSpot(Spot spot, FeatureModel fm) {
        CharSequence str;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute IDattribute = new Attribute("ID", "" + spot.ID());
        attributes.add(IDattribute);
        Attribute nameAttribute = new Attribute("name", spot.getName());
        attributes.add(nameAttribute);
        for (String feature : spot.getFeatures().keySet()) {
            Double val = spot.getFeature(feature);
            if (null == val) continue;
            str = fm.getSpotFeatureIsInt().getOrDefault(feature, Boolean.FALSE) != false ? Integer.toString(val.intValue()) : val.toString();
            attributes.add(new Attribute(feature, (String)str));
        }
        Element spotElement = new Element("Spot");
        SpotRoi roi = spot.getRoi();
        if (roi != null) {
            int nPoints = roi.x.length;
            attributes.add(new Attribute("ROI_N_POINTS", Integer.toString(nPoints)));
            str = new StringBuilder();
            for (int i = 0; i < nPoints; ++i) {
                ((StringBuilder)str).append(Double.toString(roi.x[i]));
                ((StringBuilder)str).append(' ');
                ((StringBuilder)str).append(Double.toString(roi.y[i]));
                ((StringBuilder)str).append(' ');
            }
            spotElement.setText(((StringBuilder)str).toString());
        }
        spotElement.setAttributes(attributes);
        return spotElement;
    }
}

