/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.kalman;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.tracker.KalmanTrackerConfigPanel;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.tracking.kalman.KalmanTracker;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotTrackerFactory.class)
public class KalmanTrackerFactory
implements SpotTrackerFactory {
    private static final String INFO_TEXT_PART2 = "This tracker needs two parameters (on top of the maximal frame gap tolerated): <br/>\t - the max search radius defines how far from a predicted position it should look for candidate spots;<br/>\t - the initial search radius defines how far two spots can be apart when initiating a new track.<br/></html>";
    private static final String INFO_TEXT = "<html>This tracker is best suited for objects that move with a roughly constant velocity vector.<p>It relies on the Kalman filter to predict the next most likely position of a spot. The predictions for all current tracks are linked to the spots actually found in the next frame, thanks to the LAP framework already present in the LAP tracker. Predictions are continuously refined and the tracker can accommodate moderate velocity direction and magnitude changes. <p>This tracker can bridge gaps: If a spot is not found close enough to a prediction, then the Kalman filter will make another prediction in the next frame and re-iterate the search. <p>The first frames of a track are critical for this tracker to work properly: Tracksare initiated by looking for close neighbors (again via the LAP tracker). Spurious spots in the beginning of each track can confuse the tracker.<p>This tracker needs two parameters (on top of the maximal frame gap tolerated): <br/>\t - the max search radius defines how far from a predicted position it should look for candidate spots;<br/>\t - the initial search radius defines how far two spots can be apart when initiating a new track.<br/></html>";
    public static final String DOC_URL = "https://imagej.net/plugins/trackmate/trackers/kalman-tracker";
    public static final String KEY = "KALMAN_TRACKER";
    public static final String NAME = "Kalman tracker";
    public static final ImageIcon ICON = new ImageIcon(Icons.class.getResource("images/KalmanTracker-icon-64px.png"));

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getUrl() {
        return DOC_URL;
    }

    @Override
    public SpotTracker create(SpotCollection spots, Map<String, Object> settings) {
        double maxSearchRadius = (Double)settings.get("KALMAN_SEARCH_RADIUS");
        int maxFrameGap = (Integer)settings.get("MAX_FRAME_GAP");
        double initialSearchRadius = (Double)settings.get("LINKING_MAX_DISTANCE");
        return new KalmanTracker(spots, maxSearchRadius, maxFrameGap, initialSearchRadius, null);
    }

    @Override
    public ConfigurationPanel getTrackerConfigurationPanel(Model model) {
        String spaceUnits = model.getSpaceUnits();
        return new KalmanTrackerConfigPanel(this.getName(), "<html>This tracker needs two parameters (on top of the maximal frame gap tolerated): <br/>\t - the max search radius defines how far from a predicted position it should look for candidate spots;<br/>\t - the initial search radius defines how far two spots can be apart when initiating a new track.<br/></html>", spaceUnits);
    }

    @Override
    public String toString(Map<String, Object> settings) {
        String error = this.checkSettings(settings);
        if (error != null) {
            return error;
        }
        double maxSearchRadius = (Double)settings.get("KALMAN_SEARCH_RADIUS");
        int maxFrameGap = (Integer)settings.get("MAX_FRAME_GAP");
        double initialSearchRadius = (Double)settings.get("LINKING_MAX_DISTANCE");
        StringBuilder str = new StringBuilder();
        str.append(String.format("  - initial search radius: %.1f\n", initialSearchRadius));
        str.append(String.format("  - max search radius: %.1f\n", maxSearchRadius));
        str.append(String.format("  - max frame gap: %d\n", maxFrameGap));
        return str.toString();
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> sm = new HashMap<String, Object>(3);
        sm.put("KALMAN_SEARCH_RADIUS", 20.0);
        sm.put("LINKING_MAX_DISTANCE", 15.0);
        sm.put("MAX_FRAME_GAP", 2);
        return sm;
    }
}

