/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.tracking.kdtree.NearestNeighborTracker;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class ModelTools {
    private ModelTools() {
    }

    public static void selectTrack(SelectionModel selectionModel) {
        selectionModel.clearEdgeSelection();
        selectionModel.selectTrack(selectionModel.getSpotSelection(), Collections.emptyList(), 0);
    }

    public static void selectTrackDownward(SelectionModel selectionModel) {
        selectionModel.clearEdgeSelection();
        selectionModel.selectTrack(selectionModel.getSpotSelection(), Collections.emptyList(), -1);
    }

    public static void selectTrackUpward(SelectionModel selectionModel) {
        selectionModel.clearEdgeSelection();
        selectionModel.selectTrack(selectionModel.getSpotSelection(), Collections.emptyList(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void linkSpots(Model model, SelectionModel selectionModel) {
        SpotCollection spots = SpotCollection.fromCollection(selectionModel.getSpotSelection());
        HashMap<String, Object> settings = new HashMap<String, Object>(1);
        settings.put("LINKING_MAX_DISTANCE", Double.POSITIVE_INFINITY);
        NearestNeighborTracker tracker = new NearestNeighborTracker(spots, settings);
        tracker.setNumThreads(1);
        if (!tracker.checkInput() || !tracker.process()) {
            System.err.println("Problem while computing spot links: " + tracker.getErrorMessage());
            return;
        }
        SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph = tracker.getResult();
        model.beginUpdate();
        try {
            for (DefaultWeightedEdge edge : graph.edgeSet()) {
                Spot source = (Spot)graph.getEdgeSource((Object)edge);
                Spot target = (Spot)graph.getEdgeTarget((Object)edge);
                model.addEdge(source, target, graph.getEdgeWeight((Object)edge));
            }
        }
        finally {
            model.endUpdate();
        }
    }

    public static final Comparator<DefaultWeightedEdge> featureEdgeComparator(final String feature, final FeatureModel fm) {
        Comparator<DefaultWeightedEdge> comparator = new Comparator<DefaultWeightedEdge>(){

            @Override
            public int compare(DefaultWeightedEdge e1, DefaultWeightedEdge e2) {
                double t2;
                double t1 = fm.getEdgeFeature(e1, feature);
                if (t1 < (t2 = fm.getEdgeFeature(e2, feature).doubleValue())) {
                    return -1;
                }
                if (t1 > t2) {
                    return 1;
                }
                return 0;
            }
        };
        return comparator;
    }

    public static final Comparator<Integer> featureTrackComparator(final String feature, final FeatureModel fm) {
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer e1, Integer e2) {
                double t2;
                double t1 = fm.getTrackFeature(e1, feature);
                if (t1 < (t2 = fm.getTrackFeature(e2, feature).doubleValue())) {
                    return -1;
                }
                if (t1 > t2) {
                    return 1;
                }
                return 0;
            }
        };
        return comparator;
    }
}

