/*
 * Decompiled with CFR 0.152.
 */
package inference;

import inference.Inference;
import inference.InferenceCaller;

public class DistributionInference
extends Inference
implements InferenceCaller {
    boolean evidOnly;
    double curDiriDenom;
    int curBin;
    double maxProb;
    double minProb;
    double[] distribution;

    public DistributionInference() {
        this.caller = this;
    }

    @Override
    public void doit(int M) {
        super.initCount();
        this.evidOnly = true;
        super.doit(M);
        double normal = this.logEvidences[M];
        this.evidOnly = false;
        this.distribution = new double[this.K()];
        this.curDiriDenom = this.N() + M + 1;
        double totp = 0.0;
        this.maxProb = -1.0;
        this.minProb = 1.0E300;
        this.curBin = 0;
        while (this.curBin < this.K()) {
            super.doit(M);
            this.distribution[this.curBin] = Math.exp(this.logEvidences[M] - normal);
            System.err.println("Dist " + this.curBin + ": " + this.distribution[this.curBin]);
            totp += this.distribution[this.curBin];
            if (this.maxProb < this.distribution[this.curBin]) {
                this.maxProb = this.distribution[this.curBin];
            }
            if (this.minProb > this.distribution[this.curBin]) {
                this.minProb = this.distribution[this.curBin];
            }
            ++this.curBin;
        }
        System.err.println("Total probability " + totp);
    }

    public double getProbability(int originalBin) {
        if (originalBin < 0 || originalBin >= this.K()) {
            return 0.0;
        }
        return this.distribution[originalBin];
    }

    public double getMaxProb() {
        return this.maxProb;
    }

    public double getMinProb() {
        return this.minProb;
    }

    @Override
    public double logExpectationFactor(int m, int lower_bound, int upper_bound) {
        if (this.evidOnly || this.curBin <= lower_bound || this.curBin > upper_bound) {
            return 0.0;
        }
        return Math.log((double)(this.getCount(lower_bound, upper_bound) + 1) / this.curDiriDenom / (double)(upper_bound - lower_bound));
    }

    @Override
    public double logPrior(int m) {
        return this.defaultLogPrior(m);
    }
}

