/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh;

import net.imglib2.RealPoint;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertices;
import net.imglib2.mesh.alg.InertiaTensor;
import net.imglib2.mesh.alg.hull.ConvexHull;
import net.imglib2.mesh.impl.naive.NaiveDoubleMesh;
import net.imglib2.mesh.util.MeshUtil;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class MeshStats {
    public static double volume(Mesh mesh) {
        Vertices vertices = mesh.vertices();
        Triangles triangles = mesh.triangles();
        long nTriangles = triangles.size();
        double sum = 0.0;
        for (long t = 0L; t < nTriangles; ++t) {
            long v1 = triangles.vertex0(t);
            long v2 = triangles.vertex1(t);
            long v3 = triangles.vertex2(t);
            double x1 = vertices.x(v1);
            double y1 = vertices.y(v1);
            double z1 = vertices.z(v1);
            double x2 = vertices.x(v2);
            double y2 = vertices.y(v2);
            double z2 = vertices.z(v2);
            double x3 = vertices.x(v3);
            double y3 = vertices.y(v3);
            double z3 = vertices.z(v3);
            double v321 = x3 * y2 * z1;
            double v231 = x2 * y3 * z1;
            double v312 = x3 * y1 * z2;
            double v132 = x1 * y3 * z2;
            double v213 = x2 * y1 * z3;
            double v123 = x1 * y2 * z3;
            sum += 0.16666666666666666 * (-v321 + v231 + v312 - v132 - v213 + v123);
        }
        return Math.abs(sum);
    }

    public static double convexHullVolume(Mesh mesh) {
        return MeshStats.volume(ConvexHull.calculate(mesh));
    }

    public static double surfaceArea(Mesh mesh) {
        double total = 0.0;
        for (Triangle tri : mesh.triangles()) {
            Vector3D v0 = new Vector3D(tri.v0x(), tri.v0y(), tri.v0z());
            Vector3D v1 = new Vector3D(tri.v1x(), tri.v1y(), tri.v1z());
            Vector3D v2 = new Vector3D(tri.v2x(), tri.v2y(), tri.v2z());
            Vector3D cross = ((Vector3D)v0.subtract((Vector)v1)).crossProduct(v2.subtract((Vector)v0));
            double norm = cross.getNorm();
            if (!(norm > 0.0)) continue;
            total += norm * 0.5;
        }
        return total;
    }

    public static double convexHullSurfaceArea(Mesh mesh) {
        return MeshStats.surfaceArea(ConvexHull.calculate(mesh));
    }

    public static double solidity(Mesh mesh) {
        NaiveDoubleMesh ch = ConvexHull.calculate(mesh);
        return MeshStats.solidity(mesh, ch);
    }

    public static double solidity(Mesh mesh, Mesh convexHull) {
        double volume = MeshStats.volume(mesh);
        double volumeCH = MeshStats.volume(convexHull);
        double solidity = volume / volumeCH;
        return solidity;
    }

    public static double convexity(Mesh mesh) {
        NaiveDoubleMesh ch = ConvexHull.calculate(mesh);
        return MeshStats.convexity(mesh, ch);
    }

    public static double convexity(Mesh mesh, Mesh convexHull) {
        double ra = MeshStats.surfaceArea(mesh);
        double raCH = MeshStats.surfaceArea(convexHull);
        double convexity = raCH / ra;
        return convexity;
    }

    public static double sphericity(Mesh mesh) {
        double volume = MeshStats.volume(mesh);
        double sa = MeshStats.surfaceArea(mesh);
        double sphereArea = Math.pow(Math.PI, 0.3333333333333333) * Math.pow(6.0 * volume, 0.6666666666666666);
        double sphericity = sphereArea / sa;
        return sphericity;
    }

    public static double compactness(Mesh mesh) {
        double sa = MeshStats.surfaceArea(mesh);
        double s3 = sa * sa * sa;
        double v = MeshStats.volume(mesh);
        double v2 = v * v;
        double c = s3 / v2;
        double compactness = 113.09733552923255 / c;
        return compactness;
    }

    public static RealPoint centroid(Mesh input) {
        double m100 = 0.0;
        double m010 = 0.0;
        double m001 = 0.0;
        double[] normals = new double[3];
        for (int i = 0; i < input.triangles().size(); ++i) {
            long v0 = input.triangles().vertex0(i);
            long v1 = input.triangles().vertex1(i);
            long v2 = input.triangles().vertex2(i);
            double x1 = input.vertices().x(v0);
            double y1 = input.vertices().y(v0);
            double z1 = input.vertices().z(v0);
            double x2 = input.vertices().x(v1);
            double y2 = input.vertices().y(v1);
            double z2 = input.vertices().z(v1);
            double x3 = input.vertices().x(v2);
            double y3 = input.vertices().y(v2);
            double z3 = input.vertices().z(v2);
            double d21x = x2 - x1;
            double d21y = y2 - y1;
            double d21z = z2 - z1;
            double d31x = x3 - x1;
            double d31y = y3 - y1;
            double d31z = z3 - z1;
            MeshUtil.cross(d21x, d21y, d21z, d31x, d31y, d31z, normals);
            double nx = normals[0];
            double ny = normals[1];
            double nz = normals[2];
            double xx = ((x1 + x2) * (x2 + x3) + x1 * x1 + x3 * x3) / 12.0;
            double yy = ((y1 + y2) * (y2 + y3) + y1 * y1 + y3 * y3) / 12.0;
            double zz = ((z1 + z2) * (z2 + z3) + z1 * z1 + z3 * z3) / 12.0;
            double xy = ((x1 + x2 + x3) * (y1 + y2 + y3) + x1 * y1 + x2 * y2 + x3 * y3) / 24.0;
            double xz = ((x1 + x2 + x3) * (z1 + z2 + z3) + x1 * z1 + x2 * z2 + x3 * z3) / 24.0;
            double yz = ((y1 + y2 + y3) * (z1 + z2 + z3) + y1 * z1 + y2 * z2 + y3 * z3) / 24.0;
            double dm100 = (xx * nx + 2.0 * xy * ny + 2.0 * xz * nz) / 6.0;
            double dm010 = (2.0 * xy * nx + yy * ny + 2.0 * yz * nz) / 6.0;
            double dm001 = (2.0 * xz * nx + 2.0 * yz * ny + zz * nz) / 6.0;
            m100 += dm100;
            m010 += dm010;
            m001 += dm001;
        }
        double v = MeshStats.volume(input);
        return new RealPoint(new double[]{m100 / v, m010 / v, m001 / v});
    }

    public static RealMatrix elongation(Mesh input) {
        RealMatrix it = InertiaTensor.calculate(input);
        EigenDecomposition ed = new EigenDecomposition(it);
        double l1 = ed.getRealEigenvalue(0) - ed.getRealEigenvalue(2) + ed.getRealEigenvalue(1);
        double l2 = ed.getRealEigenvalue(0) - ed.getRealEigenvalue(1) + ed.getRealEigenvalue(2);
        double l3 = ed.getRealEigenvalue(2) - ed.getRealEigenvalue(0) + ed.getRealEigenvalue(1);
        double g = 0.5968310365946076;
        double a = Math.pow(0.5968310365946076 * l1 * l1 / Math.sqrt(l2 * l3), 0.2);
        double b = Math.pow(0.5968310365946076 * l2 * l2 / Math.sqrt(l1 * l3), 0.2);
        double c = Math.pow(0.5968310365946076 * l3 * l3 / Math.sqrt(l1 * l2), 0.2);
        BlockRealMatrix out = new BlockRealMatrix(3, 3);
        out.setRow(0, new double[]{MeshStats.elongation(a, a), MeshStats.elongation(a, b), MeshStats.elongation(a, c)});
        out.setRow(1, new double[]{MeshStats.elongation(b, a), MeshStats.elongation(b, b), MeshStats.elongation(b, c)});
        out.setRow(2, new double[]{MeshStats.elongation(c, a), MeshStats.elongation(c, b), MeshStats.elongation(c, c)});
        return out;
    }

    private static double elongation(double major, double minor) {
        if (minor > major) {
            double tmp = minor;
            minor = major;
            major = tmp;
        }
        return 1.0 - minor / major;
    }

    public static double mainElongation(Mesh input) {
        return MeshStats.elongation(input).getEntry(0, 1);
    }

    public static double medianElongation(Mesh input) {
        return MeshStats.elongation(input).getEntry(1, 2);
    }

    public static long verticesCount(Mesh input) {
        return input.vertices().size();
    }

    public static long convexHullVerticesCount(Mesh input) {
        return ConvexHull.calculate(input).vertices().size();
    }

    public static double spareness(Mesh input) {
        RealMatrix it = InertiaTensor.calculate(input);
        EigenDecomposition ed = new EigenDecomposition(it);
        double l1 = ed.getRealEigenvalue(0) - ed.getRealEigenvalue(2) + ed.getRealEigenvalue(1);
        double l2 = ed.getRealEigenvalue(0) - ed.getRealEigenvalue(1) + ed.getRealEigenvalue(2);
        double l3 = ed.getRealEigenvalue(2) - ed.getRealEigenvalue(0) + ed.getRealEigenvalue(1);
        double g = 0.5968310365946076;
        double a = Math.pow(0.5968310365946076 * l1 * l1 / Math.sqrt(l2 * l3), 0.2);
        double b = Math.pow(0.5968310365946076 * l2 * l2 / Math.sqrt(l1 * l3), 0.2);
        double c = Math.pow(0.5968310365946076 * l3 * l3 / Math.sqrt(l1 * l2), 0.2);
        double volumeEllipsoid = 4.1887902047863905 * a * b * c;
        return MeshStats.volume(input) / volumeEllipsoid;
    }

    private MeshStats() {
    }
}

