/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.alg;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.alg.hull.ConvexHull;
import net.imglib2.mesh.impl.naive.NaiveDoubleMesh;
import net.imglib2.util.Util;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class EllipsoidFitter {
    public static final Ellipsoid fit(Mesh mesh) {
        NaiveDoubleMesh ch = ConvexHull.calculate(mesh);
        return EllipsoidFitter.fitOnConvexHull(ch);
    }

    public static final Ellipsoid fitOnConvexHull(Mesh mesh) {
        return EllipsoidFitter.fit(mesh.vertices(), mesh.vertices().size());
    }

    public static Ellipsoid fit(Iterable<? extends RealLocalizable> points, int nPoints) {
        RealVector V = EllipsoidFitter.solve(points, nPoints);
        RealMatrix A = EllipsoidFitter.toAlgebraicForm(V);
        RealVector C = EllipsoidFitter.findCenter(A);
        RealMatrix R = EllipsoidFitter.translateToCenter(C, A);
        Ellipsoid fit = EllipsoidFitter.getFit(R, C);
        return fit;
    }

    private static Ellipsoid getFit(RealMatrix R, RealVector C) {
        RealMatrix subr = R.getSubMatrix(0, 2, 0, 2);
        double divr = -R.getEntry(3, 3);
        for (int i = 0; i < subr.getRowDimension(); ++i) {
            for (int j = 0; j < subr.getRowDimension(); ++j) {
                subr.setEntry(i, j, subr.getEntry(i, j) / divr);
            }
        }
        EigenDecomposition ed = new EigenDecomposition(subr);
        double[] eigenvalues = ed.getRealEigenvalues();
        RealVector e1 = ed.getEigenvector(0);
        RealVector e2 = ed.getEigenvector(1);
        RealVector e3 = ed.getEigenvector(2);
        ArrayRealVector SAL = new ArrayRealVector(eigenvalues.length);
        for (int i = 0; i < eigenvalues.length; ++i) {
            ((RealVector)SAL).setEntry(i, Math.sqrt(1.0 / eigenvalues[i]));
        }
        RealPoint center = new RealPoint(new double[]{C.getEntry(0), C.getEntry(1), C.getEntry(2)});
        RealPoint ev1 = new RealPoint(new double[]{e1.getEntry(0), e1.getEntry(1), e1.getEntry(2)});
        RealPoint ev2 = new RealPoint(new double[]{e2.getEntry(0), e2.getEntry(1), e2.getEntry(2)});
        RealPoint ev3 = new RealPoint(new double[]{e3.getEntry(0), e3.getEntry(1), e3.getEntry(2)});
        return new Ellipsoid((RealLocalizable)center, (RealLocalizable)ev1, (RealLocalizable)ev2, (RealLocalizable)ev3, ((RealVector)SAL).getEntry(0), ((RealVector)SAL).getEntry(1), ((RealVector)SAL).getEntry(2));
    }

    private static final RealMatrix translateToCenter(RealVector C, RealMatrix A) {
        RealMatrix T = MatrixUtils.createRealIdentityMatrix(4);
        Array2DRowRealMatrix centerMatrix = new Array2DRowRealMatrix(1, 3);
        centerMatrix.setRowVector(0, C);
        T.setSubMatrix(centerMatrix.getData(), 3, 0);
        RealMatrix R = T.multiply(A).multiply(T.transpose());
        return R;
    }

    private static final RealVector findCenter(RealMatrix A) {
        RealMatrix subA = A.getSubMatrix(0, 2, 0, 2);
        for (int q = 0; q < subA.getRowDimension(); ++q) {
            for (int s = 0; s < subA.getColumnDimension(); ++s) {
                subA.multiplyEntry(q, s, -1.0);
            }
        }
        RealVector subV = A.getRowVector(3).getSubVector(0, 3);
        DecompositionSolver solver = new SingularValueDecomposition(subA).getSolver();
        RealMatrix subAi = solver.getInverse();
        return subAi.operate(subV);
    }

    private static final RealVector solve(Iterable<? extends RealLocalizable> points, int nPoints) {
        Array2DRowRealMatrix M0 = new Array2DRowRealMatrix(nPoints, 9);
        int i = 0;
        for (RealLocalizable realLocalizable : points) {
            double x = realLocalizable.getDoublePosition(0);
            double y = realLocalizable.getDoublePosition(1);
            double z = realLocalizable.getDoublePosition(2);
            double xx = x * x;
            double yy = y * y;
            double zz = z * z;
            double xy = 2.0 * x * y;
            double xz = 2.0 * x * z;
            double yz = 2.0 * y * z;
            M0.setEntry(i, 0, xx);
            M0.setEntry(i, 1, yy);
            M0.setEntry(i, 2, zz);
            M0.setEntry(i, 3, xy);
            M0.setEntry(i, 4, xz);
            M0.setEntry(i, 5, yz);
            M0.setEntry(i, 6, 2.0 * x);
            M0.setEntry(i, 7, 2.0 * y);
            M0.setEntry(i, 8, 2.0 * z);
            if (++i < nPoints) continue;
            break;
        }
        RealMatrix M = i == nPoints ? M0 : M0.getSubMatrix(0, i, 0, 9);
        RealMatrix realMatrix = M.transpose().multiply(M);
        ArrayRealVector O = new ArrayRealVector(nPoints);
        ((RealVector)O).mapAddToSelf(1.0);
        RealVector MO = M.transpose().operate(O);
        DecompositionSolver solver = new SingularValueDecomposition(realMatrix).getSolver();
        RealMatrix I = solver.getInverse();
        RealVector V = I.operate(MO);
        return V;
    }

    private static final RealMatrix toAlgebraicForm(RealVector V) {
        Array2DRowRealMatrix A = new Array2DRowRealMatrix(4, 4);
        A.setEntry(0, 0, V.getEntry(0));
        A.setEntry(0, 1, V.getEntry(3));
        A.setEntry(0, 2, V.getEntry(4));
        A.setEntry(0, 3, V.getEntry(6));
        A.setEntry(1, 0, V.getEntry(3));
        A.setEntry(1, 1, V.getEntry(1));
        A.setEntry(1, 2, V.getEntry(5));
        A.setEntry(1, 3, V.getEntry(7));
        A.setEntry(2, 0, V.getEntry(4));
        A.setEntry(2, 1, V.getEntry(5));
        A.setEntry(2, 2, V.getEntry(2));
        A.setEntry(2, 3, V.getEntry(8));
        A.setEntry(3, 0, V.getEntry(6));
        A.setEntry(3, 1, V.getEntry(7));
        A.setEntry(3, 2, V.getEntry(8));
        A.setEntry(3, 3, -1.0);
        return A;
    }

    public static final class Ellipsoid {
        public final RealLocalizable center;
        public final RealLocalizable ev1;
        public final RealLocalizable ev2;
        public final RealLocalizable ev3;
        public final double r1;
        public final double r2;
        public final double r3;

        private Ellipsoid(RealLocalizable center, RealLocalizable ev1, RealLocalizable ev2, RealLocalizable ev3, double r1, double r2, double r3) {
            this.center = center;
            this.ev1 = ev1;
            this.ev2 = ev2;
            this.ev3 = ev3;
            this.r1 = r1;
            this.r2 = r2;
            this.r3 = r3;
        }

        public String toString() {
            StringBuilder str = new StringBuilder(super.toString());
            str.append("\n - center: " + Util.printCoordinates((RealLocalizable)this.center));
            str.append(String.format("\n - axis 1: radius = %.2f, vector = %s", this.r1, this.ev1));
            str.append(String.format("\n - axis 2: radius = %.2f, vector = %s", this.r2, this.ev2));
            str.append(String.format("\n - axis 3: radius = %.2f, vector = %s", this.r3, this.ev3));
            return str.toString();
        }
    }
}

