/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.io.xyz;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;

public final class XYZPointsIO {
    private XYZPointsIO() {
    }

    public static final List<RealLocalizable> open(String source) throws IOException {
        ArrayList<RealLocalizable> points = new ArrayList<RealLocalizable>();
        try (BufferedReader br = new BufferedReader(new FileReader(source));){
            String line;
            while ((line = br.readLine()) != null) {
                double z;
                double y;
                double x;
                String[] parts;
                if (line.isEmpty() || line.startsWith("#") || (parts = line.trim().split("[\\s,]+")).length < 3) continue;
                try {
                    x = Double.parseDouble(parts[0]);
                    y = Double.parseDouble(parts[1]);
                    z = Double.parseDouble(parts[2]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                points.add((RealLocalizable)new RealPoint(new double[]{x, y, z}));
            }
        }
        return points;
    }
}

