/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.util;

import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangles;
import net.imglib2.mesh.Vertices;

public class MeshUtil {
    public static final double dotProduct(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    public static final void cross(double x1, double y1, double z1, double x2, double y2, double z2, double[] out) {
        out[0] = y1 * z2 - z1 * y2;
        out[1] = -x1 * z2 + z1 * x2;
        out[2] = x1 * y2 - y1 * x2;
    }

    public static final long edgeID(int v1, int v2) {
        return v1 < v2 ? MeshUtil.concat(v1, v2) : MeshUtil.concat(v2, v1);
    }

    private static final long concat(int i1, int i2) {
        long l = (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
        return l;
    }

    public static final int edgeV1(long l) {
        int i1 = (int)(l >> 32);
        return i1;
    }

    public static final int edgeV2(long l) {
        int i2 = (int)l;
        return i2;
    }

    public static final String edgeStr(long l) {
        return String.format("E: (%d -> %d)", MeshUtil.edgeV1(l), MeshUtil.edgeV2(l));
    }

    public static final double mround(double v, double eps, int mod, int rem) {
        long y = Math.round(v / ((double)mod * eps));
        double z = (double)(y * (long)mod + (long)rem) * eps;
        return z;
    }

    public static final double minZ(Vertices vertices, long v0, long v1, long v2, double eps) {
        double z0 = MeshUtil.mround(vertices.z(v0), eps, 2, 0);
        double z1 = MeshUtil.mround(vertices.z(v1), eps, 2, 0);
        double z2 = MeshUtil.mround(vertices.z(v2), eps, 2, 0);
        return Math.min(z0, Math.min(z1, z2));
    }

    public static final double maxZ(Vertices vertices, long v0, long v1, long v2, double eps) {
        double z0 = MeshUtil.mround(vertices.z(v0), eps, 2, 0);
        double z1 = MeshUtil.mround(vertices.z(v1), eps, 2, 0);
        double z2 = MeshUtil.mround(vertices.z(v2), eps, 2, 0);
        return Math.max(z0, Math.max(z1, z2));
    }

    public static String triangleStr(Mesh mesh, long id) {
        Triangles triangles = mesh.triangles();
        long vertex0 = triangles.vertex0(id);
        long vertex1 = triangles.vertex1(id);
        long vertex2 = triangles.vertex2(id);
        Vertices vertices = mesh.vertices();
        double x0 = vertices.x(vertex0);
        double y0 = vertices.y(vertex0);
        double z0 = vertices.z(vertex0);
        double x1 = vertices.x(vertex1);
        double y1 = vertices.y(vertex1);
        double z1 = vertices.z(vertex1);
        double x2 = vertices.x(vertex2);
        double y2 = vertices.y(vertex2);
        double z2 = vertices.z(vertex2);
        return String.format("triangle %d: (%.2f, %.2f, %.2f) -> (%.2f, %.2f, %.2f) -> (%.2f, %.2f, %.2f) N = (%.2f, %.2f, %.2f)", id, x0, y0, z0, x1, y1, z1, x2, y2, z2, triangles.nx(id), triangles.ny(id), triangles.nz(id));
    }
}

