/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.mesh.util;

import java.util.BitSet;
import java.util.Random;

public class SortArray {
    public static int[] quicksort(double[] main) {
        int[] index = new int[main.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        SortArray.quicksort(main, index);
        return index;
    }

    public static void quicksort(double[] main, int[] index) {
        SortArray.quicksort(main, index, 0, index.length - 1);
    }

    public static void quicksort(double[] a, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = SortArray.partition(a, index, left, right);
        SortArray.quicksort(a, index, left, i - 1);
        SortArray.quicksort(a, index, i + 1, right);
    }

    private static int partition(double[] a, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (SortArray.less(a[++i], a[right])) {
                continue;
            }
            while (SortArray.less(a[right], a[--j]) && j != left) {
            }
            if (i >= j) break;
            SortArray.exch(a, index, i, j);
        }
        SortArray.exch(a, index, i, right);
        return i;
    }

    private static final boolean less(double x, double y) {
        return x < y;
    }

    private static void exch(double[] a, int[] index, int i, int j) {
        double swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }

    public static void reorder(double[] data, int[] ind) {
        BitSet done = new BitSet(data.length);
        for (int i = 0; i < data.length && done.cardinality() < data.length; ++i) {
            int ia = i;
            int ib = ind[ia];
            if (done.get(ia)) continue;
            if (ia == ib) {
                done.set(ia);
                continue;
            }
            int x = ia;
            double a = data[ia];
            while (ib != x && !done.get(ia)) {
                double b;
                data[ia] = b = data[ib];
                done.set(ia);
                ia = ib;
                ib = ind[ia];
            }
            data[ia] = a;
            done.set(ia);
        }
    }

    public static void main(String[] args) {
        int i;
        Random ran = new Random(1L);
        int n = 10;
        double[] arr = new double[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            arr[i2] = ran.nextDouble();
        }
        double[] copy = (double[])arr.clone();
        System.out.print(String.format("Before sorting: %4.2f", arr[0]));
        for (int i3 = 1; i3 < arr.length; ++i3) {
            System.out.print(String.format(", %4.2f", arr[i3]));
        }
        System.out.println();
        int[] index = SortArray.quicksort(arr);
        System.out.print(String.format("After sorting:  %4.2f", arr[0]));
        for (i = 1; i < arr.length; ++i) {
            System.out.print(String.format(", %4.2f", arr[i]));
        }
        System.out.println();
        System.out.print(String.format("Index:          %4d", index[0]));
        for (i = 1; i < arr.length; ++i) {
            System.out.print(String.format(", %4d", index[i]));
        }
        System.out.println();
        System.out.print(String.format("Copy:           %4.2f", copy[0]));
        for (i = 1; i < copy.length; ++i) {
            System.out.print(String.format(", %4.2f", copy[i]));
        }
        System.out.println();
        SortArray.reorder(copy, index);
        System.out.print(String.format("Reorder copy:   %4.2f", copy[0]));
        for (i = 1; i < copy.length; ++i) {
            System.out.print(String.format(", %4.2f", copy[i]));
        }
        System.out.println();
    }
}

