/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.spim.fusion.CombinedPixelWeightener;
import mpicbg.spim.fusion.CombinedPixelWeightenerFactory;
import mpicbg.spim.fusion.IsolatedPixelWeightener;
import mpicbg.spim.fusion.IsolatedPixelWeightenerFactory;
import mpicbg.spim.fusion.SPIMImageFusion;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.Java3d;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import spim.vecmath.Point3d;

public class MappingFusionParalellMaxWeight
extends SPIMImageFusion {
    final Image<FloatType> fusedImage;

    public MappingFusionParalellMaxWeight(ViewStructure viewStructure, ViewStructure referenceViewStructure, ArrayList<IsolatedPixelWeightenerFactory<?>> isolatedWeightenerFactories, ArrayList<CombinedPixelWeightenerFactory<?>> combinedWeightenerFactories) {
        super(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories);
        if (viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving memory for fused image.");
        }
        ImageFactory fusedImageFactory = new ImageFactory((Type)new FloatType(), this.conf.processImageFactory);
        this.fusedImage = fusedImageFactory.createImage(new int[]{this.imgW, this.imgH, this.imgD}, "Fused image");
        if (this.fusedImage == null) {
            if (viewStructure.getDebugLevel() <= 2) {
                IOFunctions.println("MappingFusionParalell.constructor: Cannot create output image: " + this.conf.processImageFactory.getErrorMessage());
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fuseSPIMImages(int channelIndex) {
        int ithread;
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Loading source images (Channel " + channelIndex + ").");
        }
        final ArrayList<ViewDataBeads> views = new ArrayList<ViewDataBeads>();
        for (ViewDataBeads viewDataBeads : this.viewStructure.getViews()) {
            if (viewDataBeads.getChannelIndex() != channelIndex) continue;
            views.add(viewDataBeads);
        }
        final int numViews = views.size();
        if (channelIndex > 0) {
            for (FloatType type : this.fusedImage) {
                type.set(0.0f);
            }
        }
        for (ViewDataBeads view : views) {
            view.getImage(false);
        }
        if (this.viewStructure.getDebugLevel() <= 1 && this.isolatedWeightenerFactories.size() > 0) {
            void var4_10;
            String string = "(" + ((IsolatedPixelWeightenerFactory)this.isolatedWeightenerFactories.get(0)).getDescriptiveName();
            for (int i = 1; i < this.isolatedWeightenerFactories.size(); ++i) {
                String string2 = (String)var4_10 + ", " + ((IsolatedPixelWeightenerFactory)this.isolatedWeightenerFactories.get(i)).getDescriptiveName();
            }
            String string3 = (String)var4_10 + ")";
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Init isolated weighteners for all views " + string3);
        }
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)this.conf.numberOfThreads);
        final int numThreads = threads.length;
        IsolatedPixelWeightener[][] isoWinit = new IsolatedPixelWeightener[this.isolatedWeightenerFactories.size()][numViews];
        for (int j = 0; j < isoWinit.length; ++j) {
            final int i = j;
            final IsolatedPixelWeightener[][] isoW = isoWinit;
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = atomicInteger.getAndIncrement();
                        for (int view = 0; view < numViews; ++view) {
                            if (view % numThreads != myNumber) continue;
                            IOFunctions.println("Computing " + ((IsolatedPixelWeightenerFactory)MappingFusionParalellMaxWeight.this.isolatedWeightenerFactories.get(i)).getDescriptiveName() + " for " + views.get(view));
                            isoW[i][view] = ((IsolatedPixelWeightenerFactory)MappingFusionParalellMaxWeight.this.isolatedWeightenerFactories.get(i)).createInstance((ViewDataBeads)views.get(view));
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin((Thread[])threads);
        }
        try {
            boolean successful = true;
            IsolatedPixelWeightener[][] i = isoWinit;
            int isoW = i.length;
            for (ithread = 0; ithread < isoW; ++ithread) {
                IsolatedPixelWeightener[] iso;
                for (IsolatedPixelWeightener i2 : iso = i[ithread]) {
                    if (i2 != null) continue;
                    successful = false;
                }
            }
            if (!successful) {
                IOFunctions.println("Not enough memory for running the content-based fusion, running without it");
                isoWinit = new IsolatedPixelWeightener[0][0];
            }
        }
        catch (Exception e) {
            IOFunctions.println("Not enough memory for running the content-based fusion, running without it");
            isoWinit = new IsolatedPixelWeightener[0][0];
        }
        final IsolatedPixelWeightener[][] isoW = isoWinit;
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Computing output image (Channel " + channelIndex + ").");
        }
        final boolean[] useView = new boolean[numViews];
        final AbstractAffineModel3D[] models = new AbstractAffineModel3D[numViews];
        for (int i = 0; i < numViews; ++i) {
            boolean bl = useView[i] = Math.max(((ViewDataBeads)views.get(i)).getViewErrorStatistics().getNumConnectedViews(), ((ViewDataBeads)views.get(i)).getTile().getConnectedTiles().size()) > 0 || ((ViewDataBeads)views.get(i)).getViewStructure().getNumViews() == 1;
            if (!((ViewDataBeads)views.get(i)).getUseForRegistration()) {
                int angle = ((ViewDataBeads)views.get(i)).getAcqusitionAngle();
                int timepoint = ((ViewDataBeads)views.get(i)).getViewStructure().getTimePoint();
                for (ViewDataBeads view2 : this.viewStructure.getViews()) {
                    if (view2.getAcqusitionAngle() != angle || timepoint != view2.getViewStructure().getTimePoint() || !view2.getUseForRegistration()) continue;
                    useView[i] = true;
                }
            }
            models[i] = (AbstractAffineModel3D)((ViewDataBeads)views.get(i)).getTile().getModel();
        }
        for (int view = 0; view < numViews; ++view) {
            ((ViewDataBeads)views.get(view)).unnormalizeImage();
        }
        final int[][] imageSizes = new int[numViews][];
        for (int i = 0; i < numViews; ++i) {
            imageSizes[i] = ((ViewDataBeads)views.get(i)).getImageSize();
        }
        atomicInteger.set(0);
        threads = SimpleMultiThreading.newThreads((int)numThreads);
        for (int ithread2 = 0; ithread2 < threads.length; ++ithread2) {
            threads[ithread2] = new Thread(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        try {
                            int view;
                            int i;
                            int i2;
                            int myNumber = atomicInteger.getAndIncrement();
                            double[] tmp = new double[3];
                            if (MappingFusionParalellMaxWeight.this.viewStructure.getDebugLevel() <= 1 && MappingFusionParalellMaxWeight.this.combinedWeightenerFactories.size() > 0) {
                                String methods = "(" + ((CombinedPixelWeightenerFactory)MappingFusionParalellMaxWeight.this.combinedWeightenerFactories.get(0)).getDescriptiveName();
                                for (i2 = 1; i2 < MappingFusionParalellMaxWeight.this.combinedWeightenerFactories.size(); ++i2) {
                                    methods = methods + ", " + ((CombinedPixelWeightenerFactory)MappingFusionParalellMaxWeight.this.combinedWeightenerFactories.get(i2)).getDescriptiveName();
                                }
                                methods = methods + ")";
                                if (myNumber == 0) {
                                    IOFunctions.println("Initialize combined weighteners for all views " + methods);
                                }
                            }
                            CombinedPixelWeightener[] combW = new CombinedPixelWeightener[MappingFusionParalellMaxWeight.this.combinedWeightenerFactories.size()];
                            for (i2 = 0; i2 < combW.length; ++i2) {
                                combW[i2] = ((CombinedPixelWeightenerFactory)MappingFusionParalellMaxWeight.this.combinedWeightenerFactories.get(i2)).createInstance(views);
                            }
                            LocalizableByDimCursor[][] isoIterators = new LocalizableByDimCursor[isoW.length][numViews];
                            for (int i3 = 0; i3 < isoW.length; ++i3) {
                                for (int view2 = 0; view2 < isoW[i3].length; ++view2) {
                                    isoIterators[i3][view2] = isoW[i3][view2].getResultIterator();
                                }
                            }
                            Point3d[] tmpCoordinates = new Point3d[numViews];
                            int[][] loc = new int[numViews][3];
                            double[][] locd = new double[numViews][3];
                            boolean[] use = new boolean[numViews];
                            for (int i4 = 0; i4 < numViews; ++i4) {
                                tmpCoordinates[i4] = new Point3d();
                            }
                            LocalizableCursor it = MappingFusionParalellMaxWeight.this.fusedImage.createLocalizableCursor();
                            Interpolator[] imageInterpolators = new Interpolator[numViews];
                            for (int view3 = 0; view3 < numViews; ++view3) {
                                imageInterpolators[view3] = ((ViewDataBeads)views.get(view3)).getImage(false).createInterpolator(MappingFusionParalellMaxWeight.this.conf.interpolatorFactorOutput);
                            }
                            Interpolator[][] weightInterpolators = new Interpolator[isoW.length][numViews];
                            for (i = 0; i < isoW.length; ++i) {
                                for (view = 0; view < numViews; ++view) {
                                    weightInterpolators[i][view] = isoW[i][view].getResultImage().createInterpolator((InterpolatorFactory)new LinearInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory()));
                                }
                            }
                            while (it.hasNext()) {
                                it.fwd();
                                if (it.getPosition(2) % numThreads != myNumber) continue;
                                int x = it.getPosition(0) + MappingFusionParalellMaxWeight.this.cropOffsetX;
                                int y = it.getPosition(1) + MappingFusionParalellMaxWeight.this.cropOffsetY;
                                int z = it.getPosition(2) + MappingFusionParalellMaxWeight.this.cropOffsetZ;
                                int num = 0;
                                for (int i5 = 0; i5 < numViews; ++i5) {
                                    if (!useView[i5]) continue;
                                    tmpCoordinates[i5].x = (float)(x * MappingFusionParalellMaxWeight.this.scale) + MappingFusionParalellMaxWeight.this.min.x;
                                    tmpCoordinates[i5].y = (float)(y * MappingFusionParalellMaxWeight.this.scale) + MappingFusionParalellMaxWeight.this.min.y;
                                    tmpCoordinates[i5].z = (float)(z * MappingFusionParalellMaxWeight.this.scale) + MappingFusionParalellMaxWeight.this.min.z;
                                    Java3d.applyInverseInPlace(models[i5], tmpCoordinates[i5], tmp);
                                    loc[i5][0] = (int)Util.round((double)tmpCoordinates[i5].x);
                                    loc[i5][1] = (int)Util.round((double)tmpCoordinates[i5].y);
                                    loc[i5][2] = (int)Util.round((double)tmpCoordinates[i5].z);
                                    locd[i5][0] = tmpCoordinates[i5].x;
                                    locd[i5][1] = tmpCoordinates[i5].y;
                                    locd[i5][2] = tmpCoordinates[i5].z;
                                    if (loc[i5][0] >= 0 && loc[i5][1] >= 0 && loc[i5][2] >= 0 && loc[i5][0] < imageSizes[i5][0] && loc[i5][1] < imageSizes[i5][1] && loc[i5][2] < imageSizes[i5][2]) {
                                        use[i5] = true;
                                        ++num;
                                        continue;
                                    }
                                    use[i5] = false;
                                }
                                if (num <= 0) continue;
                                if (combW.length > 0) {
                                    for (CombinedPixelWeightener w : combW) {
                                        w.updateWeights(locd, use);
                                    }
                                }
                                int maxView = -1;
                                float maxWeight = -1.0f;
                                for (int view4 = 0; view4 < numViews; ++view4) {
                                    if (!use[view4]) continue;
                                    float weight = 1.0f;
                                    if (combW.length > 0) {
                                        for (CombinedPixelWeightener w : combW) {
                                            weight = (float)((double)weight * w.getWeight(view4));
                                        }
                                    }
                                    tmp[0] = tmpCoordinates[view4].x;
                                    tmp[1] = tmpCoordinates[view4].y;
                                    tmp[2] = tmpCoordinates[view4].z;
                                    for (int i6 = 0; i6 < isoW.length; ++i6) {
                                        weightInterpolators[i6][view4].setPosition(tmp);
                                        weight = ((FloatType)weightInterpolators[i6][view4].getType()).get();
                                    }
                                    if (!(weight > maxWeight)) continue;
                                    maxWeight = weight;
                                    maxView = view4;
                                }
                                if (maxView == -1) continue;
                                tmp[0] = tmpCoordinates[maxView].x;
                                tmp[1] = tmpCoordinates[maxView].y;
                                tmp[2] = tmpCoordinates[maxView].z;
                                imageInterpolators[maxView].setPosition(tmp);
                                ((FloatType)it.getType()).set(((FloatType)imageInterpolators[maxView].getType()).get());
                            }
                            it.close();
                            for (i = 0; i < isoW.length; ++i) {
                                for (view = 0; view < numViews; ++view) {
                                    weightInterpolators[i][view].close();
                                }
                            }
                            for (int view5 = 0; view5 < numViews; ++view5) {
                                imageInterpolators[view5].close();
                            }
                            for (i = 0; i < combW.length; ++i) {
                                combW[i].close();
                            }
                            for (i = 0; i < isoW.length; ++i) {
                                for (view = 0; view < isoW[i].length; ++view) {
                                    isoIterators[i][view].close();
                                }
                            }
                        }
                        catch (NoninvertibleModelException e) {
                            if (MappingFusionParalellMaxWeight.this.viewStructure.getDebugLevel() > 2) break block27;
                            IOFunctions.println("MappingFusionParalell(): Model not invertible for " + MappingFusionParalellMaxWeight.this.viewStructure);
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Closing all input images (Channel " + channelIndex + ").");
        }
        for (ViewDataBeads view : views) {
            view.closeImage();
        }
        try {
            for (int i = 0; i < isoW.length; ++i) {
                for (int view = 0; view < numViews; ++view) {
                    isoW[i][view].close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Done computing output image (Channel " + channelIndex + ").");
        }
    }

    @Override
    public Image<FloatType> getFusedImage() {
        return this.fusedImage;
    }
}

