/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.priority;

public interface Prioritized<T extends Prioritized<T>>
extends Comparable<T> {
    public double priority();

    @Override
    default public int compareTo(T that) {
        if (that == null) {
            return 1;
        }
        int priorityCompare = Prioritized.compare(this, that);
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        String thisName = this.getClass().getName();
        String thatName = that.getClass().getName();
        return thisName.compareTo(thatName);
    }

    public static <T extends Prioritized<T>> int compare(Prioritized<T> p1, Prioritized<T> p2) {
        double priority2;
        double priority1 = p1 == null ? Double.NEGATIVE_INFINITY : p1.priority();
        double d = priority2 = p2 == null ? Double.NEGATIVE_INFINITY : p2.priority();
        if (priority1 == priority2) {
            return 0;
        }
        return priority1 > priority2 ? -1 : 1;
    }
}

