/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector;

import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.display.projector.AbstractProjector2D;

public class RandomAccessibleProjector2D<A, B>
extends AbstractProjector2D {
    protected final Converter<? super A, B> converter;
    protected final RandomAccessibleInterval<B> target;
    protected final RandomAccessible<A> source;
    final int numDimensions;
    private final int dimX;
    private final int dimY;
    protected final int X = 0;
    protected final int Y = 1;

    public RandomAccessibleProjector2D(int dimX, int dimY, RandomAccessible<A> source, RandomAccessibleInterval<B> target, Converter<? super A, B> converter) {
        super(source.numDimensions());
        this.dimX = dimX;
        this.dimY = dimY;
        this.target = target;
        this.source = source;
        this.converter = converter;
        this.numDimensions = source.numDimensions();
    }

    @Override
    public void map() {
        for (int d = 2; d < this.position.length; ++d) {
            this.min[d] = this.max[d] = this.position[d];
        }
        this.min[this.dimX] = this.target.min(this.dimX);
        this.min[this.dimY] = this.target.min(this.dimY);
        this.max[this.dimX] = this.target.max(this.dimX);
        this.max[this.dimY] = this.target.max(this.dimY);
        FinalInterval sourceInterval = new FinalInterval(this.min, this.max);
        long cr = -this.target.dimension(this.dimX);
        RandomAccess targetRandomAccess = this.target.randomAccess(this.target);
        RandomAccess<A> sourceRandomAccess = this.source.randomAccess(sourceInterval);
        long width = this.target.dimension(this.dimX);
        long height = this.target.dimension(this.dimY);
        sourceRandomAccess.setPosition(this.min);
        targetRandomAccess.setPosition(this.min[this.dimX], this.dimX);
        targetRandomAccess.setPosition(this.min[this.dimY], this.dimY);
        for (long y = 0L; y < height; ++y) {
            for (long x = 0L; x < width; ++x) {
                this.converter.convert(sourceRandomAccess.get(), targetRandomAccess.get());
                sourceRandomAccess.fwd(this.dimX);
                targetRandomAccess.fwd(this.dimX);
            }
            sourceRandomAccess.move(cr, this.dimX);
            targetRandomAccess.move(cr, this.dimX);
            sourceRandomAccess.fwd(this.dimY);
            targetRandomAccess.fwd(this.dimY);
        }
    }
}

