/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer.permutation;

import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.transform.integer.permutation.AbstractPermutationTransform;

public class SingleDimensionPermutationTransform
extends AbstractPermutationTransform {
    protected final int numSourceDimensions;
    protected final int numTargetDimensions;
    protected final int d;

    public SingleDimensionPermutationTransform(int[] lut, int numSourceDimensions, int numTargetDimensions, int d) {
        super(lut);
        assert (d >= 0 && d < numTargetDimensions && d < numSourceDimensions);
        this.numSourceDimensions = numSourceDimensions;
        this.numTargetDimensions = numTargetDimensions;
        this.d = d;
    }

    @Override
    public void applyInverse(long[] source, long[] target) {
        System.arraycopy(target, 0, source, 0, this.numSourceDimensions);
        source[this.d] = this.applyInverse((int)target[this.d]);
    }

    @Override
    public void applyInverse(int[] source, int[] target) {
        System.arraycopy(target, 0, source, 0, this.numSourceDimensions);
        source[this.d] = this.applyInverse(target[this.d]);
    }

    @Override
    public void applyInverse(Positionable source, Localizable target) {
        source.setPosition(target);
        source.setPosition(this.applyInverse(target.getIntPosition(this.d)), this.d);
    }

    @Override
    public SingleDimensionPermutationTransform inverse() {
        return new SingleDimensionPermutationTransform(this.inverseLut, this.numSourceDimensions, this.numTargetDimensions, this.d);
    }

    @Override
    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    @Override
    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    @Override
    public void apply(long[] source, long[] target) {
        System.arraycopy(source, 0, target, 0, this.numTargetDimensions);
        target[this.d] = this.apply((int)source[this.d]);
    }

    @Override
    public void apply(int[] source, int[] target) {
        System.arraycopy(source, 0, target, 0, this.numTargetDimensions);
        target[this.d] = this.apply(source[this.d]);
    }

    @Override
    public void apply(Localizable source, Positionable target) {
        target.setPosition(source);
        target.setPosition(this.apply(source.getIntPosition(this.d)), this.d);
    }
}

