/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.opencv;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.bytedeco.opencv.opencv_core.Mat;
import org.scijava.Prioritized;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.log.LogService;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=-100.0)
public class MatToImgConverter
extends AbstractConverter<Mat, Img> {
    public int compareTo(Prioritized o) {
        return super.compareTo(o);
    }

    public LogService log() {
        return super.log();
    }

    public String getIdentifier() {
        return super.getIdentifier();
    }

    public <T> T convert(Object o, Class<T> type) {
        Mat imp = (Mat)o;
        return (T)MatToImgConverter.convert(imp);
    }

    public static RandomAccessibleInterval<?> convert(Mat mat) {
        int type = mat.depth();
        if (mat.channels() > 1) {
            throw new UnsupportedOperationException("Only 1 channel images are currently supported");
        }
        switch (type) {
            case 0: {
                return MatToImgConverter.toUnsignedByteImg(mat);
            }
            case 1: {
                return MatToImgConverter.toByteImg(mat);
            }
            case 4: {
                return MatToImgConverter.toIntImg(mat);
            }
            case 5: {
                return MatToImgConverter.toFloatImg(mat);
            }
            case 6: {
                return MatToImgConverter.toDoubleImg(mat);
            }
        }
        throw new UnsupportedOperationException("Unsupported CvType value: " + type);
    }

    public Class<Img> getOutputType() {
        return Img.class;
    }

    public Class<Mat> getInputType() {
        return Mat.class;
    }

    public static RandomAccessibleInterval<UnsignedByteType> toUnsignedByteImg(Mat mat) {
        byte[] out = MatToImgConverter.toByteArray(mat);
        long[] dims = MatToImgConverter.getMatShape(mat);
        long[] reshaped = (long[])dims.clone();
        reshaped[0] = dims[1];
        reshaped[1] = dims[0];
        return ArrayImgs.unsignedBytes((byte[])out, (long[])reshaped);
    }

    public static RandomAccessibleInterval<ByteType> toByteImg(Mat mat) {
        byte[] out = MatToImgConverter.toByteArray(mat);
        long[] dims = MatToImgConverter.getMatShape(mat);
        long[] reshaped = (long[])dims.clone();
        reshaped[0] = dims[1];
        reshaped[1] = dims[0];
        return ArrayImgs.bytes((byte[])out, (long[])reshaped);
    }

    public static RandomAccessibleInterval<IntType> toIntImg(Mat mat) {
        int[] out = MatToImgConverter.toIntArray(mat);
        long[] dims = MatToImgConverter.getMatShape(mat);
        long[] reshaped = (long[])dims.clone();
        reshaped[0] = dims[1];
        reshaped[1] = dims[0];
        return ArrayImgs.ints((int[])out, (long[])reshaped);
    }

    public static RandomAccessibleInterval<FloatType> toFloatImg(Mat mat) {
        float[] out = MatToImgConverter.toFloatArray(mat);
        long[] dims = MatToImgConverter.getMatShape(mat);
        long[] reshaped = (long[])dims.clone();
        reshaped[0] = dims[1];
        reshaped[1] = dims[0];
        return ArrayImgs.floats((float[])out, (long[])reshaped);
    }

    public static RandomAccessibleInterval<DoubleType> toDoubleImg(Mat mat) {
        double[] out = MatToImgConverter.toDoubleArray(mat);
        long[] dims = MatToImgConverter.getMatShape(mat);
        long[] reshaped = (long[])dims.clone();
        reshaped[0] = dims[1];
        reshaped[1] = dims[0];
        return ArrayImgs.doubles((double[])out, (long[])reshaped);
    }

    public static byte[] toByteArray(Mat mat) {
        byte[] out = new byte[(int)mat.arraySize()];
        mat.arrayData().get(out);
        return out;
    }

    public static int[] toIntArray(Mat mat) {
        byte[] bytes = MatToImgConverter.toByteArray(mat);
        IntBuffer intBuf = ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()).asIntBuffer();
        int[] out = new int[intBuf.remaining()];
        intBuf.get(out);
        return out;
    }

    public static float[] toFloatArray(Mat mat) {
        byte[] bytes = MatToImgConverter.toByteArray(mat);
        FloatBuffer floatBuf = ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()).asFloatBuffer();
        float[] out = new float[floatBuf.remaining()];
        floatBuf.get(out);
        return out;
    }

    public static double[] toDoubleArray(Mat mat) {
        byte[] bytes = MatToImgConverter.toByteArray(mat);
        DoubleBuffer doubleBuf = ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        double[] out = new double[doubleBuf.remaining()];
        doubleBuf.get(out);
        return out;
    }

    public static long[] getMatShape(Mat mat) {
        long[] dims = new long[mat.dims()];
        for (int i = 0; i < mat.dims(); ++i) {
            dims[i] = mat.size(i);
        }
        return dims;
    }
}

