/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.roi.labeling.LabelRegions;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.roi.labeling.Labelings;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class OverlappingLabels<T extends Comparable<T>> {
    private Img<UnsignedIntType> overlapMatrix;
    private List<T> labelList;
    private Img<LongType> labelSizeImg;
    private Img<DoubleType> relativeOverlapMatrix;

    public OverlappingLabels(RandomAccessibleInterval<LabelingType<T>> labeling) {
        FragmentLabelRegions labelRegions = new FragmentLabelRegions(labeling);
        this.labelList = new ArrayList(labelRegions.getExistingLabels());
        Collections.sort(this.labelList);
        FinalInterval matrixDims = new FinalInterval(new long[]{this.labelList.size(), this.labelList.size()});
        this.overlapMatrix = Util.getSuitableImgFactory((Dimensions)matrixDims, (Object)new UnsignedIntType()).create((Dimensions)matrixDims);
        RandomAccess randomAccess = this.overlapMatrix.randomAccess();
        UnsignedIntType sizeType = new UnsignedIntType();
        LabelingMapping<T> labelingMapping = Labelings.getLabelingMapping(labeling);
        for (int i = 0; i < labelingMapping.numSets(); ++i) {
            Set<T> currentLabels = labelingMapping.labelsAtIndex(i);
            long size = labelRegions.getFragmentSizeForIndex(i);
            if (size <= 0L) continue;
            sizeType.set(size);
            for (Comparable a2 : currentLabels) {
                randomAccess.setPosition(this.labelList.indexOf(a2), 0);
                for (Comparable b2 : currentLabels) {
                    randomAccess.setPosition(this.labelList.indexOf(b2), 1);
                    ((UnsignedIntType)randomAccess.get()).add(sizeType);
                }
            }
        }
        this.labelSizeImg = ArrayImgs.longs((long[])new long[]{this.labelList.size()});
        Cursor cursor = this.labelSizeImg.localizingCursor();
        while (cursor.hasNext()) {
            ((LongType)cursor.next()).set(labelRegions.getLabelRegion(this.labelList.get(cursor.getIntPosition(0))).size());
        }
        this.relativeOverlapMatrix = Util.getSuitableImgFactory((Dimensions)matrixDims, (Object)new DoubleType()).create((Dimensions)matrixDims);
        IntervalView divisor = Views.addDimension(this.labelSizeImg, (long)0L, (long)(this.labelList.size() - 1));
        LoopBuilder.setImages(this.overlapMatrix, (RandomAccessibleInterval)divisor, this.relativeOverlapMatrix).forEachPixel((a, b, c) -> c.set((double)a.get() / (double)b.get()));
    }

    public RandomAccessibleInterval<UnsignedIntType> getMatrix() {
        return this.overlapMatrix;
    }

    public RandomAccessibleInterval<DoubleType> getNormalizedMatrix() {
        return this.relativeOverlapMatrix;
    }

    public List<T> getIndexedLabels() {
        return this.labelList;
    }

    public long getPixelOverlap(T label1, T label2) {
        return this.getPixelOverlapForIndex(this.labelList.indexOf(label1), this.labelList.indexOf(label2));
    }

    public long getPixelOverlapForIndex(int index1, int index2) {
        return ((UnsignedIntType)this.overlapMatrix.getAt(new int[]{index1, index2})).get();
    }

    public double getPartialOverlap(T ofLabel, T overlappingLabel) {
        return this.getPartialOverlapForIndex(this.labelList.indexOf(ofLabel), this.labelList.indexOf(overlappingLabel));
    }

    public double getPartialOverlapForIndex(int ofLabelIndex, int overlappingLabelIndex) {
        return ((DoubleType)this.relativeOverlapMatrix.getAt(new int[]{ofLabelIndex, overlappingLabelIndex})).get();
    }

    private class FragmentLabelRegions
    extends LabelRegions<T> {
        public FragmentLabelRegions(RandomAccessibleInterval<LabelingType<T>> labeling) {
            super(labeling);
        }

        public long getFragmentSizeForIndex(int index) {
            return ((LabelRegions.FragmentProperties)this.indexToFragmentProperties.get(index)).getSize();
        }
    }
}

