/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.operator.DataflowOperator;
import groovyx.gpars.dataflow.operator.DataflowOperatorActor;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.List;
import java.util.concurrent.Semaphore;

final class ForkingDataflowOperatorActor
extends DataflowOperatorActor {
    private final Semaphore semaphore;
    private final Pool threadPool;
    private final int maxForks;

    ForkingDataflowOperatorActor(DataflowOperator owningOperator, PGroup group, List outputs, List inputs, Closure code, int maxForks) {
        super(owningOperator, group, outputs, inputs, code);
        this.maxForks = maxForks;
        this.semaphore = new Semaphore(maxForks);
        this.threadPool = group.getThreadPool();
    }

    @Override
    void startTask(final List<Object> results) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Cannot obtain the semaphore to fork operator's body.", e);
        }
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ForkingDataflowOperatorActor.super.startTask(results);
                }
                finally {
                    ForkingDataflowOperatorActor.this.semaphore.release();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forwardPoisonPill(Object data) {
        try {
            this.semaphore.acquire(this.maxForks);
        }
        catch (InterruptedException e) {
            this.owningProcessor.reportError(e);
        }
        finally {
            super.forwardPoisonPill(data);
            this.semaphore.release(this.maxForks);
        }
    }
}

