/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.DragAndDropHandler;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;

public class SaveDialog {
    private String dir;
    private String name;
    private String title;
    private String ext;

    public SaveDialog(String title, String defaultName, String extension) {
        this.title = title;
        this.ext = extension;
        if (this.isMacro()) {
            return;
        }
        String defaultDir = OpenDialog.getDefaultDirectory();
        defaultName = SaveDialog.setExtension(defaultName, extension);
        IJ.showStatus(title);
        if (Prefs.useJFileChooser) {
            this.jSave(title, defaultDir, defaultName);
        } else {
            this.save(title, defaultDir, defaultName);
        }
        IJ.showStatus("");
        if (this.name != null && this.dir != null) {
            OpenDialog.setDefaultDirectory(this.dir);
        }
        IJ.showStatus(title + ": " + this.dir + this.name);
    }

    public SaveDialog(String title, String defaultDir, String defaultName, String extension) {
        this.title = title;
        this.ext = extension;
        if (this.isMacro()) {
            return;
        }
        defaultName = SaveDialog.setExtension(defaultName, extension);
        if (Prefs.useJFileChooser) {
            this.jSave(title, defaultDir, defaultName);
        } else {
            this.save(title, defaultDir, defaultName);
        }
        IJ.showStatus(title + ": " + this.dir + this.name);
    }

    boolean isMacro() {
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            String path = Macro.getValue(macroOptions, this.title, null);
            if (path == null) {
                path = Macro.getValue(macroOptions, "path", null);
            }
            if (path != null && path.indexOf(".") == -1 && !new File(path).exists()) {
                Interpreter interp;
                String path2;
                if (path.startsWith("&")) {
                    path = path.substring(1);
                }
                String string = path2 = (interp = Interpreter.getInstance()) != null ? interp.getStringVariable(path) : null;
                if (path2 != null) {
                    path = path2;
                }
            }
            if (path != null) {
                Opener o = new Opener();
                this.dir = o.getDir(path);
                this.name = o.getName(path);
                return true;
            }
        }
        return false;
    }

    public static String setExtension(String name, String extension) {
        if (name == null || extension == null || extension.length() == 0) {
            return name;
        }
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0 && name.length() - dotIndex <= 5) {
            name = dotIndex + 1 < name.length() && Character.isDigit(name.charAt(dotIndex + 1)) ? name + extension : name.substring(0, dotIndex) + extension;
        } else if (!name.endsWith(extension)) {
            name = name + extension;
        }
        return name;
    }

    void jSave(String title, String defaultDir, String defaultName) {
        LookAndFeel saveLookAndFeel = Java2.getLookAndFeel();
        Java2.setSystemLookAndFeel();
        if (EventQueue.isDispatchThread()) {
            this.jSaveDispatchThread(title, defaultDir, defaultName);
        } else {
            this.jSaveInvokeAndWait(title, defaultDir, defaultName);
        }
        Java2.setLookAndFeel(saveLookAndFeel);
    }

    void jSaveDispatchThread(String title, String defaultDir, String defaultName) {
        int ret;
        int returnVal;
        File f;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        fc.setDragEnabled(true);
        fc.setTransferHandler(new DragAndDropHandler(fc));
        if (defaultDir != null && (f = new File(defaultDir)) != null) {
            fc.setCurrentDirectory(f);
        }
        if (defaultName != null) {
            fc.setSelectedFile(new File(defaultName));
        }
        if ((returnVal = fc.showSaveDialog(IJ.getInstance())) != 0) {
            Macro.abort();
            return;
        }
        File f2 = fc.getSelectedFile();
        if (f2.exists() && (ret = JOptionPane.showConfirmDialog(fc, "The file " + f2.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
            f2 = null;
        }
        if (f2 == null) {
            Macro.abort();
        } else {
            this.dir = fc.getCurrentDirectory().getPath() + File.separator;
            this.name = fc.getName(f2);
            if (this.noExtension(this.name)) {
                if (".raw".equals(this.ext)) {
                    this.ext = null;
                }
                this.name = SaveDialog.setExtension(this.name, this.ext);
            }
        }
    }

    void jSaveInvokeAndWait(final String title, final String defaultDir, final String defaultName) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int ret;
                    int returnVal;
                    File f;
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(title);
                    fc.setDragEnabled(true);
                    fc.setTransferHandler(new DragAndDropHandler(fc));
                    if (defaultDir != null && (f = new File(defaultDir)) != null) {
                        fc.setCurrentDirectory(f);
                    }
                    if (defaultName != null) {
                        fc.setSelectedFile(new File(defaultName));
                    }
                    if ((returnVal = fc.showSaveDialog(IJ.getInstance())) != 0) {
                        Macro.abort();
                        return;
                    }
                    File f2 = fc.getSelectedFile();
                    if (f2.exists() && (ret = JOptionPane.showConfirmDialog(fc, "The file " + f2.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
                        f2 = null;
                    }
                    if (f2 == null) {
                        Macro.abort();
                    } else {
                        SaveDialog.this.dir = fc.getCurrentDirectory().getPath() + File.separator;
                        SaveDialog.this.name = fc.getName(f2);
                        if (SaveDialog.this.noExtension(SaveDialog.this.name)) {
                            if (".raw".equals(SaveDialog.this.ext)) {
                                SaveDialog.this.ext = null;
                            }
                            SaveDialog.this.name = SaveDialog.setExtension(SaveDialog.this.name, SaveDialog.this.ext);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void save(String title, String defaultDir, String defaultName) {
        ImageJ ij = IJ.getInstance();
        Frame parent = ij != null ? ij : new Frame();
        FileDialog fd = new FileDialog(parent, title, 1);
        if (defaultName != null) {
            fd.setFile(defaultName);
        }
        if (defaultDir != null) {
            File f;
            if (IJ.isWindows() && defaultDir.contains("/") && (f = new File(defaultDir)).isDirectory()) {
                try {
                    defaultDir = f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            fd.setDirectory(defaultDir);
        }
        fd.show();
        String origName = this.name = fd.getFile();
        if (this.noExtension(this.name)) {
            File f;
            boolean dialog;
            if (".raw".equals(this.ext)) {
                this.ext = null;
            }
            this.name = SaveDialog.setExtension(this.name, this.ext);
            boolean bl = dialog = this.name != null && !this.name.equals(origName) && IJ.isMacOSX() && !IJ.isMacro();
            if (dialog && !(f = new File(fd.getDirectory() + this.getFileName())).exists()) {
                dialog = false;
            }
            if (dialog) {
                Font font = new Font("SansSerif", 1, 12);
                GenericDialog gd = new GenericDialog("Replace File?");
                gd.addMessage("\"" + this.name + "\" already exists.\nDo you want to replace it?", font);
                gd.addMessage("To avoid this dialog, enable\n\"Show all filename extensions\"\nin Finder Preferences.");
                gd.setOKLabel("Replace");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    this.name = null;
                }
            }
        }
        if (IJ.debugMode) {
            IJ.log(origName + "->" + this.name);
        }
        this.dir = fd.getDirectory();
        if (this.name == null) {
            Macro.abort();
        }
        fd.dispose();
        if (ij == null) {
            parent.dispose();
        }
    }

    private boolean noExtension(String name) {
        if (name == null) {
            return false;
        }
        int dotIndex = name.indexOf(".");
        return dotIndex == -1 || name.length() - dotIndex > 5;
    }

    public String getDirectory() {
        OpenDialog.setLastDirectory(this.dir);
        return this.dir;
    }

    public String getFileName() {
        if (this.name != null) {
            if (IJ.recording() && this.dir != null) {
                Recorder.recordPath(this.title, this.dir + this.name);
            }
            OpenDialog.setLastName(this.name);
        }
        return this.name;
    }

    public static String getPath(ImagePlus imp, String extension) {
        String title = imp != null ? imp.getTitle() : "Untitled";
        SaveDialog sd = new SaveDialog("Save As", title, extension);
        if (sd.getFileName() == null) {
            return null;
        }
        return sd.getDirectory() + sd.getFileName();
    }
}

