/*
 * Decompiled with CFR 0.152.
 */
package bdv;

import bdv.BigDataViewerActions;
import bdv.SpimSource;
import bdv.ViewerImgLoader;
import bdv.VolatileSpimSource;
import bdv.cache.CacheControl;
import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterConsole;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bdv.tools.HelpDialog;
import bdv.tools.InitializeViewerState;
import bdv.tools.PreferencesDialog;
import bdv.tools.RecordMaxProjectionDialog;
import bdv.tools.RecordMovieDialog;
import bdv.tools.VisibilityAndGroupingDialog;
import bdv.tools.bookmarks.Bookmarks;
import bdv.tools.bookmarks.BookmarksEditor;
import bdv.tools.brightness.BrightnessDialog;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.MinMaxGroup;
import bdv.tools.brightness.RealARGBColorConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.tools.crop.CropDialog;
import bdv.tools.transformation.ManualTransformation;
import bdv.tools.transformation.ManualTransformationEditor;
import bdv.tools.transformation.TransformedSource;
import bdv.ui.UIUtils;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.appearance.AppearanceSettingsPage;
import bdv.ui.keymap.Keymap;
import bdv.ui.keymap.KeymapManager;
import bdv.ui.keymap.KeymapSettingsPage;
import bdv.viewer.ConverterSetups;
import bdv.viewer.NavigationActions;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerFrame;
import bdv.viewer.ViewerOptions;
import bdv.viewer.ViewerPanel;
import dev.dirs.ProjectDirectories;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicMultiResolutionSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import net.imglib2.Volatile;
import net.imglib2.converter.Converter;
import net.imglib2.display.ColorConverter;
import net.imglib2.display.RealARGBColorConverter;
import net.imglib2.display.ScaledARGBConverter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.volatiles.VolatileARGBType;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.yaml.YamlConfigIO;
import org.scijava.ui.behaviour.util.Actions;

public class BigDataViewer {
    public static String configDir = ProjectDirectories.from((String)"sc", (String)"fiji", (String)"bigdataviewer").configDir;
    protected final ViewerFrame viewerFrame;
    protected final ViewerPanel viewer;
    protected final SetupAssignments setupAssignments;
    protected final ManualTransformation manualTransformation;
    protected final Bookmarks bookmarks;
    protected final BrightnessDialog brightnessDialog;
    protected final CropDialog cropDialog;
    protected final RecordMovieDialog movieDialog;
    protected final RecordMaxProjectionDialog movieMaxProjectDialog;
    protected final VisibilityAndGroupingDialog activeSourcesDialog;
    protected final HelpDialog helpDialog;
    private final KeymapManager keymapManager;
    private final AppearanceManager appearanceManager;
    protected final PreferencesDialog preferencesDialog;
    protected final ManualTransformationEditor manualTransformationEditor;
    protected final BookmarksEditor bookmarkEditor;
    protected final JFileChooser fileChooser;
    protected File proposedSettingsFile;

    public void toggleManualTransformation() {
        this.manualTransformationEditor.toggle();
    }

    public void initSetBookmark() {
        this.bookmarkEditor.initSetBookmark();
    }

    public void initGoToBookmark() {
        this.bookmarkEditor.initGoToBookmark();
    }

    public void initGoToBookmarkRotation() {
        this.bookmarkEditor.initGoToBookmarkRotation();
    }

    private static String createSetupName(BasicViewSetup setup) {
        Channel channel;
        if (setup.hasName()) {
            return setup.getName();
        }
        String name = "";
        Angle angle = (Angle)setup.getAttribute(Angle.class);
        if (angle != null) {
            name = name + (name.isEmpty() ? "" : " ") + "a " + angle.getName();
        }
        if ((channel = (Channel)setup.getAttribute(Channel.class)) != null) {
            name = name + (name.isEmpty() ? "" : " ") + "c " + channel.getName();
        }
        return name;
    }

    public static <T extends NumericType<T>> Converter<T, ARGBType> createConverterToARGB(T type) {
        if (type instanceof RealType) {
            RealType t = (RealType)type;
            double typeMin = Math.max(0.0, Math.min(t.getMinValue(), 65535.0));
            double typeMax = Math.max(0.0, Math.min(t.getMaxValue(), 65535.0));
            return RealARGBColorConverter.create((RealType)t, (double)typeMin, (double)typeMax);
        }
        if (type instanceof ARGBType) {
            return new ScaledARGBConverter.ARGB(0.0, 255.0);
        }
        if (type instanceof VolatileARGBType) {
            return new ScaledARGBConverter.VolatileARGB(0.0, 255.0);
        }
        throw new IllegalArgumentException("ImgLoader of type " + type.getClass() + " not supported.");
    }

    public static ConverterSetup createConverterSetup(SourceAndConverter<?> soc, int setupId) {
        Converter<Volatile<?>, ARGBType> vc;
        SourceAndConverter<Volatile<?>> vsoc;
        ArrayList<ColorConverter> converters = new ArrayList<ColorConverter>();
        Converter<?, ARGBType> c = soc.getConverter();
        if (c instanceof ColorConverter) {
            converters.add((ColorConverter)c);
        }
        if ((vsoc = soc.asVolatile()) != null && (vc = vsoc.getConverter()) instanceof ColorConverter) {
            converters.add((ColorConverter)vc);
        }
        if (converters.isEmpty()) {
            return null;
        }
        return new RealARGBColorConverterSetup(setupId, converters);
    }

    public static <T, V extends Volatile<T>> SourceAndConverter<T> wrapWithTransformedSource(SourceAndConverter<T> soc) {
        if (soc.asVolatile() == null) {
            return new SourceAndConverter<T>(new TransformedSource<T>(soc.getSpimSource()), soc.getConverter());
        }
        SourceAndConverter<Volatile<T>> vsoc = soc.asVolatile();
        TransformedSource<T> ts = new TransformedSource<T>(soc.getSpimSource());
        TransformedSource<Volatile<T>> vts = new TransformedSource<Volatile<T>>(vsoc.getSpimSource(), ts);
        return new SourceAndConverter<T>(ts, soc.getConverter(), new SourceAndConverter<Volatile<T>>(vts, vsoc.getConverter()));
    }

    private static <T extends NumericType<T>, V extends Volatile<T>> void initSetupNumericType(AbstractSpimData<?> spimData, BasicViewSetup setup, List<ConverterSetup> converterSetups, List<SourceAndConverter<?>> sources) {
        int setupId = setup.getId();
        ViewerImgLoader imgLoader = (ViewerImgLoader)spimData.getSequenceDescription().getImgLoader();
        BasicMultiResolutionSetupImgLoader setupImgLoader = imgLoader.getSetupImgLoader(setupId);
        NumericType type = (NumericType)setupImgLoader.getImageType();
        Object volatileType = setupImgLoader.getVolatileImageType();
        if (!(type instanceof NumericType)) {
            throw new IllegalArgumentException("ImgLoader of type " + type.getClass() + " not supported.");
        }
        String setupName = BigDataViewer.createSetupName(setup);
        SourceAndConverter<NumericType> vsoc = null;
        if (volatileType != null) {
            VolatileSpimSource vs = new VolatileSpimSource(spimData, setupId, setupName);
            vsoc = new SourceAndConverter<NumericType>(vs, BigDataViewer.createConverterToARGB((NumericType)volatileType));
        }
        SpimSource s = new SpimSource(spimData, setupId, setupName);
        SourceAndConverter<NumericType> soc = new SourceAndConverter<NumericType>(s, BigDataViewer.createConverterToARGB(type), vsoc);
        SourceAndConverter<NumericType> tsoc = BigDataViewer.wrapWithTransformedSource(soc);
        sources.add(tsoc);
        ConverterSetup converterSetup = BigDataViewer.createConverterSetup(tsoc, setupId);
        if (converterSetup != null) {
            converterSetups.add(converterSetup);
        }
    }

    public static void initSetups(AbstractSpimData<?> spimData, List<ConverterSetup> converterSetups, List<SourceAndConverter<?>> sources) {
        for (BasicViewSetup setup : spimData.getSequenceDescription().getViewSetupsOrdered()) {
            BigDataViewer.initSetupNumericType(spimData, setup, converterSetups, sources);
        }
    }

    @Deprecated
    public BigDataViewer(ArrayList<ConverterSetup> converterSetups, ArrayList<SourceAndConverter<?>> sources, AbstractSpimData<?> spimData, int numTimepoints, CacheControl cache, String windowTitle, ProgressWriter progressWriter, ViewerOptions options) {
        this((List<ConverterSetup>)converterSetups, (List<SourceAndConverter<?>>)sources, spimData, numTimepoints, cache, windowTitle, progressWriter, options);
    }

    public BigDataViewer(List<ConverterSetup> converterSetups, List<SourceAndConverter<?>> sources, AbstractSpimData<?> spimData, int numTimepoints, CacheControl cache, String windowTitle, ProgressWriter progressWriter, ViewerOptions options) {
        KeymapManager optionsKeymapManager = options.values.getKeymapManager();
        AppearanceManager optionsAppearanceManager = options.values.getAppearanceManager();
        this.keymapManager = optionsKeymapManager != null ? optionsKeymapManager : new KeymapManager(configDir);
        this.appearanceManager = optionsAppearanceManager != null ? optionsAppearanceManager : new AppearanceManager(configDir);
        InputTriggerConfig inputTriggerConfig = options.values.getInputTriggerConfig();
        Keymap keymap = this.keymapManager.getForwardSelectedKeymap();
        if (inputTriggerConfig == null) {
            inputTriggerConfig = keymap.getConfig();
        }
        this.viewerFrame = new ViewerFrame(sources, numTimepoints, cache, this.keymapManager, this.appearanceManager, options.inputTriggerConfig(inputTriggerConfig));
        if (windowTitle != null) {
            this.viewerFrame.setTitle(windowTitle);
        }
        this.viewer = this.viewerFrame.getViewerPanel();
        this.manualTransformation = new ManualTransformation(this.viewer);
        this.manualTransformationEditor = new ManualTransformationEditor(this.viewer, this.viewerFrame.getKeybindings());
        this.bookmarks = new Bookmarks();
        this.bookmarkEditor = new BookmarksEditor(this.viewer, this.viewerFrame.getKeybindings(), this.bookmarks);
        ConverterSetups setups = this.viewerFrame.getConverterSetups();
        if (converterSetups.size() != sources.size()) {
            System.err.println("WARNING! Constructing BigDataViewer, with converterSetups.size() that is not the same as sources.size().");
        }
        int numSetups = Math.min(converterSetups.size(), sources.size());
        for (int i = 0; i < numSetups; ++i) {
            SourceAndConverter<?> source = sources.get(i);
            ConverterSetup setup = converterSetups.get(i);
            if (setup == null) continue;
            setups.put(source, setup);
        }
        this.setupAssignments = new SetupAssignments(converterSetups, 0.0, 65535.0);
        if (this.setupAssignments.getMinMaxGroups().size() > 0) {
            MinMaxGroup group = this.setupAssignments.getMinMaxGroups().get(0);
            for (ConverterSetup setup : this.setupAssignments.getConverterSetups()) {
                this.setupAssignments.moveSetupToGroup(setup, group);
            }
        }
        this.brightnessDialog = new BrightnessDialog((Frame)this.viewerFrame, this.setupAssignments);
        if (spimData != null) {
            this.viewer.getSourceInfoOverlayRenderer().setTimePointsOrdered(spimData.getSequenceDescription().getTimePoints().getTimePointsOrdered());
        }
        this.cropDialog = spimData == null ? null : new CropDialog((Frame)this.viewerFrame, this.viewer, spimData.getSequenceDescription());
        this.movieDialog = new RecordMovieDialog((Frame)this.viewerFrame, this.viewer, progressWriter);
        this.viewer.getDisplay().overlays().add((Object)this.movieDialog);
        this.movieMaxProjectDialog = new RecordMaxProjectionDialog((Frame)this.viewerFrame, this.viewer, progressWriter);
        this.viewer.getDisplay().overlays().add((Object)this.movieMaxProjectDialog);
        this.activeSourcesDialog = new VisibilityAndGroupingDialog((Frame)this.viewerFrame, this.viewer.state());
        this.helpDialog = new HelpDialog(this.viewerFrame);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "xml files";
            }

            @Override
            public boolean accept(File f) {
                String s;
                int i;
                if (f.isDirectory()) {
                    return true;
                }
                if (f.isFile() && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
                    String ext = s.substring(i + 1).toLowerCase();
                    return ext.equals("xml");
                }
                return false;
            }
        });
        this.preferencesDialog = new PreferencesDialog((Frame)this.viewerFrame, keymap, new String[]{"bdv"});
        this.preferencesDialog.addPage(new AppearanceSettingsPage("Appearance", this.appearanceManager));
        this.preferencesDialog.addPage(new KeymapSettingsPage("Keymap", this.keymapManager, this.keymapManager.getCommandDescriptions()));
        this.appearanceManager.appearance().updateListeners().add(this.viewerFrame::repaint);
        this.appearanceManager.addLafComponent(this.fileChooser);
        SwingUtilities.invokeLater(() -> this.appearanceManager.updateLookAndFeel());
        Actions navigationActions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bdv", "navigation"});
        navigationActions.install(this.viewerFrame.getKeybindings(), "navigation");
        NavigationActions.install(navigationActions, this.viewer, options.values.is2D());
        Actions bdvActions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bdv"});
        bdvActions.install(this.viewerFrame.getKeybindings(), "bdv");
        BigDataViewerActions.install(bdvActions, this);
        keymap.updateListeners().add(() -> {
            navigationActions.updateKeyConfig(keymap.getConfig());
            bdvActions.updateKeyConfig(keymap.getConfig());
            this.viewerFrame.getTransformBehaviours().updateKeyConfig(keymap.getConfig());
        });
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menubar.add(menu);
        ActionMap actionMap = this.viewerFrame.getKeybindings().getConcatenatedActionMap();
        JMenuItem miLoadSettings = new JMenuItem(actionMap.get("load settings"));
        miLoadSettings.setText("Load settings");
        menu.add(miLoadSettings);
        JMenuItem miSaveSettings = new JMenuItem(actionMap.get("save settings"));
        miSaveSettings.setText("Save settings");
        menu.add(miSaveSettings);
        menu.addSeparator();
        JMenuItem miPreferences = new JMenuItem(actionMap.get("Preferences"));
        miPreferences.setText("Preferences...");
        menu.add(miPreferences);
        menu = new JMenu("Settings");
        menubar.add(menu);
        JMenuItem miBrightness = new JMenuItem(actionMap.get("brightness settings"));
        miBrightness.setText("Brightness & Color");
        menu.add(miBrightness);
        JMenuItem miVisibility = new JMenuItem(actionMap.get("visibility and grouping"));
        miVisibility.setText("Visibility & Grouping");
        menu.add(miVisibility);
        menu = new JMenu("Tools");
        menubar.add(menu);
        if (this.cropDialog != null) {
            JMenuItem miCrop = new JMenuItem(actionMap.get("crop"));
            miCrop.setText("Crop");
            menu.add(miCrop);
        }
        JMenuItem miMovie = new JMenuItem(actionMap.get("record movie"));
        miMovie.setText("Record Movie");
        menu.add(miMovie);
        JMenuItem miMaxProjectMovie = new JMenuItem(actionMap.get("record max projection movie"));
        miMaxProjectMovie.setText("Record Max-Projection Movie");
        menu.add(miMaxProjectMovie);
        JMenuItem miManualTransform = new JMenuItem(actionMap.get("toggle manual transformation"));
        miManualTransform.setText("Manual Transform");
        menu.add(miManualTransform);
        menu = new JMenu("Help");
        menubar.add(menu);
        JMenuItem miHelp = new JMenuItem(actionMap.get("help"));
        miHelp.setText("Show Help");
        menu.add(miHelp);
        this.viewerFrame.setJMenuBar(menubar);
    }

    public static BigDataViewer open(AbstractSpimData<?> spimData, String windowTitle, ProgressWriter progressWriter, ViewerOptions options) {
        if (WrapBasicImgLoader.wrapImgLoaderIfNecessary(spimData)) {
            System.err.println("WARNING:\nOpening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.");
        }
        ArrayList<ConverterSetup> converterSetups = new ArrayList<ConverterSetup>();
        ArrayList sources = new ArrayList();
        BigDataViewer.initSetups(spimData, converterSetups, sources);
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        int numTimepoints = seq.getTimePoints().size();
        CacheControl cache = ((ViewerImgLoader)seq.getImgLoader()).getCacheControl();
        BigDataViewer bdv = new BigDataViewer(converterSetups, sources, spimData, numTimepoints, cache, windowTitle, progressWriter, options);
        WrapBasicImgLoader.removeWrapperIfPresent(spimData);
        bdv.viewerFrame.setVisible(true);
        InitializeViewerState.initTransform(bdv.viewer);
        return bdv;
    }

    public static BigDataViewer open(String xmlFilename, String windowTitle, ProgressWriter progressWriter, ViewerOptions options) throws SpimDataException {
        SpimDataMinimal spimData = (SpimDataMinimal)new XmlIoSpimDataMinimal().load(xmlFilename);
        BigDataViewer bdv = BigDataViewer.open(spimData, windowTitle, progressWriter, options);
        if (!bdv.tryLoadSettings(xmlFilename)) {
            InitializeViewerState.initBrightness(0.001, 0.999, bdv.viewerFrame);
        }
        return bdv;
    }

    public static BigDataViewer open(ArrayList<ConverterSetup> converterSetups, ArrayList<SourceAndConverter<?>> sources, int numTimepoints, CacheControl cache, String windowTitle, ProgressWriter progressWriter, ViewerOptions options) {
        BigDataViewer bdv = new BigDataViewer(converterSetups, sources, null, numTimepoints, cache, windowTitle, progressWriter, options);
        bdv.viewerFrame.setVisible(true);
        InitializeViewerState.initTransform(bdv.viewer);
        return bdv;
    }

    public ViewerPanel getViewer() {
        return this.viewer;
    }

    public ViewerFrame getViewerFrame() {
        return this.viewerFrame;
    }

    public ConverterSetups getConverterSetups() {
        return this.viewerFrame.getConverterSetups();
    }

    @Deprecated
    public SetupAssignments getSetupAssignments() {
        return this.setupAssignments;
    }

    public ManualTransformationEditor getManualTransformEditor() {
        return this.manualTransformationEditor;
    }

    public KeymapManager getKeymapManager() {
        return this.keymapManager;
    }

    public AppearanceManager getAppearanceManager() {
        return this.appearanceManager;
    }

    public boolean tryLoadSettings(String xmlFilename) {
        this.proposedSettingsFile = null;
        if (xmlFilename.startsWith("http://")) {
            String settings = xmlFilename + "settings";
            try {
                this.loadSettings(settings);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (xmlFilename.endsWith(".xml")) {
            String settings = xmlFilename.substring(0, xmlFilename.length() - ".xml".length()) + ".settings.xml";
            this.proposedSettingsFile = new File(settings);
            if (this.proposedSettingsFile.isFile()) {
                try {
                    this.loadSettings(settings);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public void saveSettings() {
        this.fileChooser.setSelectedFile(this.proposedSettingsFile);
        int returnVal = this.fileChooser.showSaveDialog(null);
        if (returnVal == 0) {
            this.proposedSettingsFile = this.fileChooser.getSelectedFile();
            try {
                this.saveSettings(this.proposedSettingsFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveSettings(String xmlFilename) throws IOException {
        Element root = new Element("Settings");
        root.addContent((Content)this.viewer.stateToXml());
        root.addContent((Content)this.setupAssignments.toXml());
        root.addContent((Content)this.manualTransformation.toXml());
        root.addContent((Content)this.bookmarks.toXml());
        Document doc = new Document(root);
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        xout.output(doc, (Writer)new FileWriter(xmlFilename));
    }

    @Deprecated
    public static InputTriggerConfig getInputTriggerConfig(ViewerOptions options) {
        String fn;
        InputTriggerConfig conf = options.values.getInputTriggerConfig();
        if (conf == null && new File("bdvkeyconfig.yaml").isFile()) {
            try {
                conf = new InputTriggerConfig((Collection)YamlConfigIO.read((String)"bdvkeyconfig.yaml"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conf == null && new File(fn = System.getProperty("user.home") + "/.bdv/bdvkeyconfig.yaml").isFile()) {
            try {
                conf = new InputTriggerConfig((Collection)YamlConfigIO.read((String)fn));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conf == null) {
            conf = new InputTriggerConfig();
        }
        return conf;
    }

    public void loadSettings() {
        this.fileChooser.setSelectedFile(this.proposedSettingsFile);
        int returnVal = this.fileChooser.showOpenDialog(null);
        if (returnVal == 0) {
            this.proposedSettingsFile = this.fileChooser.getSelectedFile();
            try {
                this.loadSettings(this.proposedSettingsFile.getCanonicalPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadSettings(String xmlFilename) throws IOException, JDOMException {
        SAXBuilder sax = new SAXBuilder();
        Document doc = sax.build(xmlFilename);
        Element root = doc.getRootElement();
        this.viewer.stateFromXml(root);
        this.setupAssignments.restoreFromXml(root);
        this.manualTransformation.restoreFromXml(root);
        this.bookmarks.restoreFromXml(root);
        this.activeSourcesDialog.update();
        this.viewer.requestRepaint();
    }

    public void expandAndFocusCardPanel() {
        this.viewerFrame.getSplitPanel().setCollapsed(false);
        this.viewerFrame.getSplitPanel().getRightComponent().requestFocusInWindow();
    }

    public void collapseCardPanel() {
        this.viewerFrame.getSplitPanel().setCollapsed(true);
        this.viewer.requestFocusInWindow();
    }

    public static void main(String[] args) {
        String fn = "/Users/pietzsch/workspace/data/111010_weber_resave.xml";
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            UIUtils.installFlatLafInfos();
            System.out.println("reading config files from \"" + configDir + "\"");
            BigDataViewer bigDataViewer = BigDataViewer.open("/Users/pietzsch/workspace/data/111010_weber_resave.xml", new File("/Users/pietzsch/workspace/data/111010_weber_resave.xml").getName(), (ProgressWriter)new ProgressWriterConsole(), ViewerOptions.options());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

