/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.settings;

import bdv.ui.UIUtils;
import bdv.ui.settings.ModificationListener;
import bdv.ui.settings.SettingsPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final DefaultMutableTreeNode root = new DefaultMutableTreeNode(new SettingsNodeData("root", null));
    private final DefaultTreeModel model = new DefaultTreeModel(this.root);
    private final FullWidthSelectionJTree tree = new FullWidthSelectionJTree(this.model);
    private final JScrollPane treeScrollPane;
    private final JSplitPane splitPane;
    private final JPanel pages;
    private final JPanel breadcrumbs = new JPanel();
    private final ModificationListener modificationListener;
    private final ArrayList<Runnable> runOnOk;
    private final ArrayList<Runnable> runOnCancel;
    private final JButton apply;

    public void addPage(SettingsPage page) {
        String path = page.getTreePath();
        DefaultMutableTreeNode current = this.getSettingsPageNode(path, true);
        page.modificationListeners().add((Object)this.modificationListener);
        SettingsNodeData data = (SettingsNodeData)current.getUserObject();
        data.page = page;
        this.tree.expandPath(new TreePath(this.root));
        if (this.pages.getComponents().length == 0) {
            this.tree.getSelectionModel().setSelectionPath(new TreePath(this.model.getPathToRoot(current)));
        }
        this.pages.add(page.getTreePath(), page.getJPanel());
        this.pages.revalidate();
        this.pages.repaint();
    }

    public void removePage(String path) {
        DefaultMutableTreeNode current = this.getSettingsPageNode(path, false);
        if (current == null) {
            return;
        }
        this.model.removeNodeFromParent(current);
        for (SettingsPage page : this.getPages()) {
            if (!page.getTreePath().equals(path)) continue;
            this.pages.remove(page.getJPanel());
        }
        this.pages.revalidate();
        this.pages.repaint();
    }

    public void showPage(String path) {
        DefaultMutableTreeNode current = this.getSettingsPageNode(path, false);
        if (current == null) {
            return;
        }
        for (SettingsPage page : this.getPages()) {
            if (!page.getTreePath().equals(path)) continue;
            TreePath tp = new TreePath(this.model.getPathToRoot(current));
            this.tree.setSelectionPath(tp);
            break;
        }
        this.pages.revalidate();
        this.pages.repaint();
    }

    public SettingsPanel() {
        this.breadcrumbs.setLayout(new BoxLayout(this.breadcrumbs, 2));
        this.breadcrumbs.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.setBreadCrumbs(this.root);
        final CardLayout cardLayout = new CardLayout();
        this.pages = new JPanel(cardLayout);
        this.tree.setEditable(false);
        this.tree.setSelectionRow(0);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setIcon(null);
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        Color bg = renderer.getBackgroundSelectionColor();
        this.tree.setBackgroundSelectionColor(bg);
        this.tree.setCellRenderer(renderer);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)SettingsPanel.this.tree.getLastSelectedPathComponent();
                if (selectedNode != null) {
                    SettingsPanel.this.setBreadCrumbs(selectedNode);
                    SettingsNodeData data = (SettingsNodeData)selectedNode.getUserObject();
                    if (data.page != null) {
                        cardLayout.show(SettingsPanel.this.pages, data.page.getTreePath());
                    }
                }
            }
        });
        JButton cancel = new JButton("Cancel");
        this.apply = new JButton("Apply");
        JButton ok = new JButton("OK");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 2));
        buttons.add(Box.createHorizontalGlue());
        buttons.add(cancel);
        buttons.add(this.apply);
        buttons.add(ok);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.breadcrumbs, "North");
        content.add((Component)this.pages, "Center");
        content.setBorder(new EmptyBorder(10, 0, 10, 10));
        this.treeScrollPane = new JScrollPane(this.tree);
        this.treeScrollPane.setPreferredSize(new Dimension(200, 500));
        this.treeScrollPane.setMinimumSize(new Dimension(150, 200));
        this.treeScrollPane.setBorder(new MatteBorder(0, 0, 0, 1, UIManager.getColor("Separator.foreground")));
        renderer.setBackgroundNonSelectionColor(this.treeScrollPane.getBackground());
        this.splitPane = new JSplitPane(1, this.treeScrollPane, content);
        this.splitPane.setResizeWeight(0.0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setDividerSize(10);
        this.splitPane.setDividerLocation(this.treeScrollPane.getPreferredSize().width);
        this.splitPane.setBorder(new MatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        buttons.setBorder(new EmptyBorder(10, 0, 5, 10));
        this.add((Component)buttons, "South");
        this.runOnCancel = new ArrayList();
        this.runOnOk = new ArrayList();
        cancel.addActionListener(e -> this.cancel());
        this.apply.setEnabled(false);
        this.modificationListener = () -> this.apply.setEnabled(true);
        this.apply.addActionListener(e -> {
            this.getPages().forEach(SettingsPage::apply);
            this.apply.setEnabled(false);
        });
        ok.addActionListener(e -> {
            this.getPages().forEach(SettingsPage::apply);
            this.runOnOk.forEach(Runnable::run);
            this.apply.setEnabled(false);
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.treeScrollPane != null) {
            Color c = UIManager.getColor("Separator.foreground");
            this.treeScrollPane.setBorder(new MatteBorder(0, 0, 0, 1, c));
            this.splitPane.setBorder(new MatteBorder(0, 0, 1, 0, c));
        }
        if (this.model != null) {
            SwingUtilities.invokeLater(this.model::reload);
        }
    }

    public void cancel() {
        this.getPages().forEach(SettingsPage::cancel);
        this.runOnCancel.forEach(Runnable::run);
        this.apply.setEnabled(false);
    }

    public synchronized void onOk(Runnable runnable) {
        this.runOnOk.add(runnable);
    }

    public synchronized void onCancel(Runnable runnable) {
        this.runOnCancel.add(runnable);
    }

    private ArrayList<SettingsPage> getPages() {
        ArrayList<SettingsPage> list = new ArrayList<SettingsPage>();
        this.getPages(this.root, list);
        return list;
    }

    private void getPages(DefaultMutableTreeNode node, ArrayList<SettingsPage> pages) {
        SettingsNodeData data = (SettingsNodeData)node.getUserObject();
        if (data.page != null) {
            pages.add(data.page);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.getPages((DefaultMutableTreeNode)node.getChildAt(i), pages);
        }
    }

    private void setBreadCrumbs(DefaultMutableTreeNode selectedNode) {
        this.breadcrumbs.removeAll();
        DefaultMutableTreeNode current = selectedNode;
        while (current != this.root) {
            SettingsNodeData data = (SettingsNodeData)current.getUserObject();
            JLabel label = this.semiboldLabel(data.name);
            final TreePath tpath = new TreePath(this.model.getPathToRoot(current));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SettingsPanel.this.tree.getSelectionModel().setSelectionPath(tpath);
                }
            });
            this.breadcrumbs.add((Component)label, 0);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)current.getParent();
            if (parent != this.root) {
                label = this.semiboldLabel(" \u25b8 ");
                this.breadcrumbs.add((Component)label, 0);
            }
            current = parent;
        }
        if (this.breadcrumbs.getComponentCount() == 0) {
            this.breadcrumbs.add(this.semiboldLabel(" "));
        }
        this.breadcrumbs.revalidate();
        this.breadcrumbs.repaint();
    }

    private DefaultMutableTreeNode getSettingsPageNode(String path, boolean createIfNotExists) {
        String[] parts = path.split(">");
        DefaultMutableTreeNode current = this.root;
        for (String part : parts) {
            String text = part.trim();
            DefaultMutableTreeNode next = null;
            for (int i = 0; i < current.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)current.getChildAt(i);
                SettingsNodeData data = (SettingsNodeData)child.getUserObject();
                if (!text.equals(data.name)) continue;
                next = child;
                break;
            }
            if (next == null) {
                if (createIfNotExists) {
                    SettingsNodeData data = new SettingsNodeData(text, null);
                    next = new DefaultMutableTreeNode(data);
                    this.model.insertNodeInto(next, current, current.getChildCount());
                } else {
                    return null;
                }
            }
            current = next;
        }
        return current;
    }

    private JLabel semiboldLabel(String text) {
        return new JLabel(text){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIUtils.getFont("semibold.font"));
            }
        };
    }

    static class FullWidthSelectionJTree
    extends JTree {
        private static final long serialVersionUID = 1L;
        private Color backgroundSelectionColor = new DefaultTreeCellRenderer().getBackgroundSelectionColor();

        FullWidthSelectionJTree(TreeModel newModel) {
            super(newModel);
            this.setOpaque(false);
        }

        void setBackgroundSelectionColor(Color backgroundSelectionColor) {
            this.backgroundSelectionColor = backgroundSelectionColor;
        }

        @Override
        public void paintComponent(Graphics g) {
            int[] rows = this.getSelectionRows();
            if (rows != null) {
                g.setColor(this.backgroundSelectionColor);
                for (int i : rows) {
                    Rectangle r = this.getRowBounds(i);
                    g.fillRect(0, r.y, this.getWidth(), r.height);
                }
            }
            super.paintComponent(g);
        }
    }

    static class SettingsNodeData {
        private final String name;
        private SettingsPage page;

        SettingsNodeData(String name, SettingsPage page) {
            this.name = name;
            this.page = page;
        }

        public String toString() {
            return this.name;
        }
    }
}

