/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.cache.SharedQueue;
import bdv.util.AbstractSource;
import bdv.util.VolatileSource;
import bdv.util.volatiles.VolatileTypeMatcher;
import bdv.viewer.Interpolation;
import java.util.Arrays;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.Volatile;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public class RandomAccessibleIntervalMipmapSource4D<T extends NumericType<T>>
extends AbstractSource<T> {
    protected final RandomAccessibleInterval<T>[] mipmapSources;
    protected final long minT;
    protected final long maxT;
    protected int currentTimePointIndex;
    private final RandomAccessibleInterval<T>[] currentMipmaps;
    private final RealRandomAccessible<T>[][] currentInterpolatedSources;
    protected final AffineTransform3D[] mipmapTransforms;

    private static boolean assertAllTDimensionsEqual(Interval[] intervals) {
        long min = intervals[0].min(3);
        long max = intervals[0].min(3);
        for (int i = 1; i < intervals.length; ++i) {
            if (intervals[i].min(3) == min && intervals[i].max(3) == max) continue;
            return false;
        }
        return true;
    }

    public RandomAccessibleIntervalMipmapSource4D(RandomAccessibleInterval<T>[] imgs, T type, AffineTransform3D[] mipmapTransforms, VoxelDimensions voxelDimensions, String name, boolean doBoundingBoxCulling) {
        super(type, name, voxelDimensions, doBoundingBoxCulling);
        assert (imgs.length == mipmapTransforms.length) : "Number of mipmaps and scale factors do not match.";
        assert (RandomAccessibleIntervalMipmapSource4D.assertAllTDimensionsEqual(imgs)) : "Mipmaps have different numbers of timepoints.";
        this.mipmapSources = imgs;
        this.currentMipmaps = new RandomAccessibleInterval[imgs.length];
        this.mipmapTransforms = mipmapTransforms;
        this.minT = this.mipmapSources[0].min(3);
        this.maxT = this.mipmapSources[0].max(3);
        this.currentInterpolatedSources = new RealRandomAccessible[Interpolation.values().length][imgs.length];
        this.loadTimepoint(0);
    }

    public RandomAccessibleIntervalMipmapSource4D(RandomAccessibleInterval<T>[] imgs, T type, double[][] mipmapScales, VoxelDimensions voxelDimensions, AffineTransform3D sourceTransform, String name, boolean doBoundingBoxCulling) {
        super(type, name, voxelDimensions, doBoundingBoxCulling);
        assert (imgs.length == mipmapScales.length) : "Number of mipmaps and scale factors do not match.";
        assert (RandomAccessibleIntervalMipmapSource4D.assertAllTDimensionsEqual(imgs)) : "Mipmaps have different numbers of timepoints.";
        this.mipmapSources = imgs;
        this.currentMipmaps = new RandomAccessibleInterval[imgs.length];
        this.mipmapTransforms = new AffineTransform3D[mipmapScales.length];
        for (int s = 0; s < mipmapScales.length; ++s) {
            AffineTransform3D mipmapTransform = new AffineTransform3D();
            mipmapTransform.set(mipmapScales[s][0], 0.0, 0.0, 0.5 * (mipmapScales[s][0] - 1.0), 0.0, mipmapScales[s][1], 0.0, 0.5 * (mipmapScales[s][1] - 1.0), 0.0, 0.0, mipmapScales[s][2], 0.5 * (mipmapScales[s][2] - 1.0));
            mipmapTransform.preConcatenate(sourceTransform);
            this.mipmapTransforms[s] = mipmapTransform;
        }
        this.minT = this.mipmapSources[0].min(3);
        this.maxT = this.mipmapSources[0].max(3);
        this.currentInterpolatedSources = new RealRandomAccessible[Interpolation.values().length][imgs.length];
        this.loadTimepoint(0);
    }

    public RandomAccessibleIntervalMipmapSource4D(RandomAccessibleInterval<T>[] imgs, T type, double[][] mipmapScales, VoxelDimensions voxelDimensions, AffineTransform3D sourceTransform, String name) {
        this(imgs, type, mipmapScales, voxelDimensions, sourceTransform, name, true);
    }

    public RandomAccessibleIntervalMipmapSource4D(RandomAccessibleInterval<T>[] imgs, T type, double[][] mipmapScales, VoxelDimensions voxelDimensions, String name) {
        this(imgs, type, mipmapScales, voxelDimensions, new AffineTransform3D(), name);
    }

    private void loadTimepoint(int timepointIndex) {
        this.currentTimePointIndex = timepointIndex;
        if (this.isPresent(timepointIndex)) {
            NumericType zero = (NumericType)this.getType().createVariable();
            zero.setZero();
            for (int level = 0; level < this.currentMipmaps.length; ++level) {
                this.currentMipmaps[level] = Views.hyperSlice(this.mipmapSources[level], (int)3, (long)timepointIndex);
                for (Interpolation method : Interpolation.values()) {
                    this.currentInterpolatedSources[method.ordinal()][level] = Views.interpolate((EuclideanSpace)Views.extendValue(this.currentMipmaps[level], (Type)zero), this.interpolators.get(method));
                }
            }
        } else {
            Arrays.fill(this.currentMipmaps, null);
            Arrays.fill(this.currentInterpolatedSources, null);
        }
    }

    @Override
    public boolean isPresent(int t) {
        return this.minT <= (long)t && (long)t <= this.maxT;
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        return this.currentMipmaps[level];
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        return this.currentInterpolatedSources[method.ordinal()][level];
    }

    @Override
    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.mipmapTransforms[level]);
    }

    @Override
    public int getNumMipmapLevels() {
        return this.mipmapSources.length;
    }

    public <V extends Volatile<T>> VolatileSource<T, V> asVolatile(V vType, SharedQueue queue) {
        return new VolatileSource(this, vType, queue);
    }

    public <V extends Volatile<T>> VolatileSource<T, V> asVolatile(Supplier<V> vTypeSupplier, SharedQueue queue) {
        return new VolatileSource(this, vTypeSupplier, queue);
    }

    public <V extends Volatile<T>> VolatileSource<T, V> asVolatile(SharedQueue queue) {
        Object t = this.getType();
        if (t instanceof NativeType) {
            return new VolatileSource(this, (Volatile)VolatileTypeMatcher.getVolatileTypeForType((NativeType)this.getType()), queue);
        }
        throw new UnsupportedOperationException("This method only works for sources of NativeType.");
    }
}

