/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.window;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import org.jhotdraw.app.OSXApplication;

public class TogglePaletteAction
extends AbstractAction {
    private Window palette;
    private OSXApplication app;
    private WindowListener windowHandler;

    public TogglePaletteAction(OSXApplication app, Window palette, String label) {
        super(label);
        this.app = app;
        this.windowHandler = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TogglePaletteAction.this.putValue("SwingSelectedKey", false);
            }
        };
        this.putValue("SwingSelectedKey", false);
        this.setPalette(palette);
    }

    @Override
    public void putValue(String key, Object newValue) {
        super.putValue(key, newValue);
    }

    public void setPalette(Window newValue) {
        if (this.palette != null) {
            this.palette.removeWindowListener(this.windowHandler);
        }
        this.palette = newValue;
        if (this.palette != null) {
            this.palette.addWindowListener(this.windowHandler);
            if (this.getValue("SwingSelectedKey") == Boolean.TRUE) {
                this.app.addPalette(this.palette);
                this.palette.setVisible(true);
            } else {
                this.app.removePalette(this.palette);
                this.palette.setVisible(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.palette != null) {
            boolean b = (Boolean)this.getValue("SwingSelectedKey");
            if (b) {
                this.app.addPalette(this.palette);
                this.palette.setVisible(true);
            } else {
                this.app.removePalette(this.palette);
                this.palette.setVisible(false);
            }
        }
    }
}

