/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.Profile;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class FreeHandProfile {
    private Profile profile;
    private boolean updateProfile = true;
    private double[][] all_points;
    private int lastBezierIndex;
    private int nPoints = 0;
    private double[][] l_points;
    private double[][] r_points;
    private double[][] b_points;
    private boolean insertAtBeginOfProfile;
    private boolean insertAtEndOfProfile;
    private int nBeziers = 0;
    private boolean isVisible = true;
    private double[] mouseVelocity = new double[2];
    private double[] mousePosition = new double[2];
    private int[] bezierMousePoxIndexes;
    private static final double MOUSE_MASS = 10.0;
    private double[][] newBezierPoints = new double[4][2];
    private int startIndex;
    private static final double MAX_ACCUMULATED_ERROR_PER_BEZIER = 0.3;
    private static final int GRADIENT_DESCENT_SAMPLE_COUNT = 20;
    private static final double LEARNING_RATE = 0.1;

    public FreeHandProfile(Profile profile) {
        this.profile = profile;
    }

    public void mousePressed(int x_p, int y_p) {
        x_p -= this.profile.getX();
        y_p -= this.profile.getY();
        this.all_points = new double[5][2];
        this.l_points = new double[5][2];
        this.r_points = new double[5][2];
        this.b_points = new double[5][2];
        this.bezierMousePoxIndexes = new int[5];
        if (this.profile.hasPoints()) {
            if (this.profile.isClosed()) {
                this.startIndex = this.profile.getNearestPointIndex(x_p, y_p);
                this.all_points[0][0] = this.profile.p[0][this.startIndex];
                this.all_points[0][1] = this.profile.p[1][this.startIndex];
                this.l_points[0][0] = this.profile.p_l[0][this.startIndex];
                this.l_points[0][1] = this.profile.p_l[1][this.startIndex];
                this.b_points[0][0] = this.profile.p[0][this.startIndex];
                this.b_points[0][1] = this.profile.p[1][this.startIndex];
                this.r_points[0][0] = this.profile.p_r[0][this.startIndex];
                this.r_points[0][1] = this.profile.p_r[1][this.startIndex];
            } else {
                double[][] nearer;
                double lastDist;
                double[][] first = this.profile.getFirstPoint();
                double[][] last = this.profile.getLastPoint();
                double firstDist = this.squaredDist(first[1][0], first[1][1], x_p, y_p);
                if (firstDist < (lastDist = this.squaredDist(last[1][0], last[1][1], x_p, y_p))) {
                    this.insertAtBeginOfProfile = true;
                    nearer = first;
                } else {
                    this.insertAtEndOfProfile = true;
                    nearer = last;
                }
                this.all_points[0][0] = nearer[1][0];
                this.all_points[0][1] = nearer[1][1];
                this.l_points[0][0] = nearer[0][0];
                this.l_points[0][1] = nearer[0][1];
                this.b_points[0][0] = nearer[1][0];
                this.b_points[0][1] = nearer[1][1];
                this.r_points[0][0] = nearer[2][0];
                this.r_points[0][1] = nearer[2][1];
            }
        } else {
            this.all_points[0][0] = x_p;
            this.all_points[0][1] = y_p;
            double d = x_p;
            this.b_points[0][0] = d;
            this.r_points[0][0] = d;
            this.l_points[0][0] = d;
            double d2 = y_p;
            this.b_points[0][1] = d2;
            this.r_points[0][1] = d2;
            this.l_points[0][1] = d2;
        }
        this.mousePosition[0] = this.all_points[0][0] + (double)this.profile.getX();
        this.mousePosition[1] = this.all_points[0][1] + (double)this.profile.getY();
        this.bezierMousePoxIndexes[0] = 0;
        for (int i = 0; i < 4; ++i) {
            this.newBezierPoints[i][0] = this.all_points[0][0];
            this.newBezierPoints[i][1] = this.all_points[0][1];
        }
        this.nPoints = 1;
        this.nBeziers = 1;
        this.lastBezierIndex = 0;
    }

    public void mouseDragged(MouseEvent me, int x_d, int y_d, double dx, double dy) {
        this.mouseVelocity[0] = dx / 10.0 + 0.9 * this.mouseVelocity[0];
        this.mouseVelocity[1] = dy / 10.0 + 0.9 * this.mouseVelocity[1];
        this.mousePosition[0] = this.mousePosition[0] + this.mouseVelocity[0];
        this.mousePosition[1] = this.mousePosition[1] + this.mouseVelocity[1];
        this.insertPoint(this.mousePosition[0] - (double)this.profile.getX(), this.mousePosition[1] - (double)this.profile.getY());
        this.adjustNewBezierEndPoint();
        double[][] targetPoints = this.calculateMouseSamples(this.lastBezierIndex, this.nPoints - 1);
        this.interpolateTargetSamples(targetPoints, 20);
        double medError = this.getMedSquaredError(targetPoints);
        if (medError > 0.3 && this.nPoints - this.lastBezierIndex > 20) {
            this.fixateCurrentBezier();
            if (this.nBeziers > 3) {
                this.smoothBezierPoint(this.nBeziers - 2);
            }
        }
    }

    public void mouseReleased(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        this.adjustNewBezierEndPoint();
        double[][] targetPoints = this.calculateMouseSamples(this.lastBezierIndex, this.nPoints - 1);
        this.interpolateTargetSamples(targetPoints, 20);
        this.fixateCurrentBezier();
        if (this.nBeziers > 3) {
            this.smoothBezierPoint(this.nBeziers - 2);
        }
        this.r_points[this.nBeziers - 1][0] = this.b_points[this.nBeziers - 1][0];
        this.r_points[this.nBeziers - 1][1] = this.b_points[this.nBeziers - 1][1];
        if (this.updateProfile) {
            double[][] tmp_p_l = new double[2][this.nBeziers];
            double[][] tmp_p = new double[2][this.nBeziers];
            double[][] tmp_p_r = new double[2][this.nBeziers];
            if (this.insertAtBeginOfProfile) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < this.nBeziers; ++j) {
                        tmp_p_r[i][j] = this.l_points[this.nBeziers - 1 - j][i];
                        tmp_p[i][j] = this.b_points[this.nBeziers - 1 - j][i];
                        tmp_p_l[i][j] = this.r_points[this.nBeziers - 1 - j][i];
                    }
                }
                this.profile.addPointsAtBegin(tmp_p_l, tmp_p, tmp_p_r);
            } else if (this.insertAtEndOfProfile) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < this.nBeziers; ++j) {
                        tmp_p_l[i][j] = this.l_points[j][i];
                        tmp_p[i][j] = this.b_points[j][i];
                        tmp_p_r[i][j] = this.r_points[j][i];
                    }
                }
                this.profile.addPointsAtEnd(tmp_p_l, tmp_p, tmp_p_r);
            } else if (this.profile.closed && this.profile.hasPoints()) {
                int endIndex = this.profile.getNearestPointIndex(this.all_points[this.nPoints - 1][0], this.all_points[this.nPoints - 1][1]);
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < this.nBeziers; ++j) {
                        tmp_p_l[i][j] = this.l_points[j][i];
                        tmp_p[i][j] = this.b_points[j][i];
                        tmp_p_r[i][j] = this.r_points[j][i];
                    }
                }
                this.profile.insertBetween(this.startIndex, endIndex, tmp_p_l, tmp_p, tmp_p_r);
            } else {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < this.nBeziers; ++j) {
                        tmp_p_l[i][j] = this.l_points[j][i];
                        tmp_p[i][j] = this.b_points[j][i];
                        tmp_p_r[i][j] = this.r_points[j][i];
                    }
                }
                this.profile.setPoints(tmp_p_l, tmp_p, tmp_p_r);
            }
        }
        this.profile.calculateBoundingBox(true);
        this.profile.repaint(false);
    }

    private void smoothBezierPoint(int i) {
        double[][] bezier1 = new double[4][2];
        double[][] bezier2 = new double[4][2];
        int firstMousePointIndex = this.bezierMousePoxIndexes[i - 1];
        int middleMousePointIndex = this.bezierMousePoxIndexes[i];
        int lastMousePointIndex = this.bezierMousePoxIndexes[i + 1];
        double[][] targetpoints1 = this.calculateMouseSamples(firstMousePointIndex, middleMousePointIndex);
        double[][] targetpoints2 = this.calculateMouseSamples(middleMousePointIndex, lastMousePointIndex);
        bezier1[0][0] = this.b_points[i - 1][0];
        bezier1[0][1] = this.b_points[i - 1][1];
        bezier1[1][0] = this.r_points[i - 1][0];
        bezier1[1][1] = this.r_points[i - 1][1];
        bezier1[2][0] = this.l_points[i][0];
        bezier1[2][1] = this.l_points[i][1];
        bezier1[3][0] = this.b_points[i][0];
        bezier1[3][1] = this.b_points[i][1];
        bezier2[0][0] = this.b_points[i][0];
        bezier2[0][1] = this.b_points[i][1];
        bezier2[1][0] = this.r_points[i][0];
        bezier2[1][1] = this.r_points[i][1];
        bezier2[2][0] = this.l_points[i + 1][0];
        bezier2[2][1] = this.l_points[i + 1][1];
        bezier2[3][0] = this.b_points[i + 1][0];
        bezier2[3][1] = this.b_points[i + 1][1];
        this.smoothBezier(bezier1, bezier2, targetpoints1, targetpoints2);
        this.b_points[i - 1][0] = bezier1[0][0];
        this.b_points[i - 1][1] = bezier1[0][1];
        this.r_points[i - 1][0] = bezier1[1][0];
        this.r_points[i - 1][1] = bezier1[1][1];
        this.l_points[i][0] = bezier1[2][0];
        this.l_points[i][1] = bezier1[2][1];
        this.b_points[i][0] = bezier1[3][0];
        this.b_points[i][1] = bezier1[3][1];
        this.b_points[i][0] = bezier2[0][0];
        this.b_points[i][1] = bezier2[0][1];
        this.r_points[i][0] = bezier2[1][0];
        this.r_points[i][1] = bezier2[1][1];
        this.l_points[i + 1][0] = bezier2[2][0];
        this.l_points[i + 1][1] = bezier2[2][1];
        this.b_points[i + 1][0] = bezier2[3][0];
        this.b_points[i + 1][1] = bezier2[3][1];
    }

    private void smoothBezier(double[][] bezier1, double[][] bezier2, double[][] targetpoints1, double[][] targetpoints2) {
        double[] p03 = bezier1[0];
        double[] p02 = bezier1[1];
        double[] p11 = bezier2[2];
        double[] p10 = bezier2[3];
        double[] p00 = new double[]{bezier2[0][0], bezier2[0][1]};
        double[] dP = new double[]{bezier1[2][0] - bezier2[1][0], bezier1[2][1] - bezier2[1][1]};
        double alpha = this.dist(bezier1[2][0], bezier1[2][1], p00[0], p00[1]) / this.dist(0.0, 0.0, dP[0], dP[1]);
        double beta = -this.dist(bezier2[1][0], bezier2[1][1], p00[0], p00[1]) / this.dist(0.0, 0.0, dP[0], dP[1]);
        for (int i = 0; i < 20; ++i) {
            double constPartY;
            double constPartX;
            double t;
            int j;
            double dAlpha = 0.0;
            double dBeta = 0.0;
            double[] ddP = new double[2];
            double[] dp02 = new double[2];
            double[] dp00 = new double[2];
            double[] dp11 = new double[2];
            for (j = 0; j < 20; ++j) {
                t = (j + 1) / 21;
                constPartX = -targetpoints1[j][0];
                constPartX += p00[0] * t * t * (3.0 - 2.0 * t);
                constPartX += 3.0 * alpha * dP[0] * t * t * (1.0 - t);
                constPartX += 3.0 * p02[0] * t * (1.0 - t) * (1.0 - t);
                constPartY = -targetpoints1[j][1];
                constPartY += p00[1] * t * t * (3.0 - 2.0 * t);
                constPartY += 3.0 * alpha * dP[1] * t * t * (1.0 - t);
                constPartY += 3.0 * p02[1] * t * (1.0 - t) * (1.0 - t);
                dAlpha += 3.0 * ((constPartX += p03[0] * (1.0 - t) * (1.0 - t) * (1.0 - t)) * dP[0] + (constPartY += p03[1] * (1.0 - t) * (1.0 - t) * (1.0 - t)) * dP[1]) * t * t * (1.0 - t);
                ddP[0] = ddP[0] + 3.0 * constPartX * alpha * t * t * (1.0 - t);
                ddP[1] = ddP[1] + 3.0 * constPartY * alpha * t * t * (1.0 - t);
                dp02[0] = dp02[0] + 3.0 * constPartX * t * (1.0 - t) * (1.0 - t);
                dp02[1] = dp02[1] + 3.0 * constPartY * t * (1.0 - t) * (1.0 - t);
                dp00[0] = dp00[0] + constPartX * t * t * (3.0 - 2.0 * t);
                dp00[1] = dp00[1] + constPartY * t * t * (3.0 - 2.0 * t);
            }
            for (j = 0; j < 20; ++j) {
                t = 1 - (j + 1) / 21;
                constPartX = -targetpoints2[j][0];
                constPartX += p00[0] * t * t * (3.0 - 2.0 * t);
                constPartX += 3.0 * beta * dP[0] * t * t * (1.0 - t);
                constPartX += 3.0 * p11[0] * t * (1.0 - t) * (1.0 - t);
                constPartY = -targetpoints2[j][1];
                constPartY += p00[1] * t * t * (3.0 - 2.0 * t);
                constPartY += 3.0 * beta * dP[1] * t * t * (1.0 - t);
                constPartY += 3.0 * p11[1] * t * (1.0 - t) * (1.0 - t);
                dBeta += 3.0 * ((constPartX += p10[0] * (1.0 - t) * (1.0 - t) * (1.0 - t)) * dP[0] + (constPartY += p10[1] * (1.0 - t) * (1.0 - t) * (1.0 - t)) * dP[1]) * t * t * (1.0 - t);
                ddP[0] = ddP[0] + 3.0 * constPartX * beta * t * t * (1.0 - t);
                ddP[1] = ddP[1] + 3.0 * constPartY * beta * t * t * (1.0 - t);
                dp11[0] = dp11[0] + 3.0 * constPartX * t * (1.0 - t) * (1.0 - t);
                dp11[1] = dp11[1] + 3.0 * constPartY * t * (1.0 - t) * (1.0 - t);
                dp00[0] = dp00[0] + constPartX * t * t * (3.0 - 2.0 * t);
                dp00[1] = dp00[1] + constPartY * t * t * (3.0 - 2.0 * t);
            }
            alpha -= 0.1 * dAlpha;
            beta -= 0.1 * dBeta;
            dP[0] = dP[0] - 0.1 * ddP[0];
            dP[1] = dP[1] - 0.1 * ddP[1];
            p02[0] = p02[0] - 0.1 * dp02[0];
            p02[1] = p02[1] - 0.1 * dp02[1];
            p00[0] = p00[0] - 0.1 * dp00[0];
            p00[1] = p00[1] - 0.1 * dp00[1];
            p11[0] = p11[0] - 0.1 * dp11[0];
            p11[1] = p11[1] - 0.1 * dp11[1];
        }
        bezier1[0] = p03;
        bezier1[1] = p02;
        bezier1[2][0] = p00[0] + alpha * dP[0];
        bezier1[2][1] = p00[1] + alpha * dP[1];
        bezier1[3][0] = p00[0];
        bezier1[3][1] = p00[1];
        bezier2[0][0] = p00[0];
        bezier2[0][1] = p00[1];
        bezier2[1][0] = p00[0] + beta * dP[0];
        bezier2[1][1] = p00[1] + beta * dP[1];
        bezier2[2] = p11;
        bezier2[3] = p10;
    }

    private void fixateCurrentBezier() {
        if (this.newBezierPoints[3][0] == this.newBezierPoints[0][0] && this.newBezierPoints[3][1] == this.newBezierPoints[0][1]) {
            return;
        }
        if (this.nBeziers >= this.b_points.length) {
            double[][] tmp = new double[this.b_points.length + 5][2];
            System.arraycopy(this.b_points, 0, tmp, 0, this.b_points.length);
            this.b_points = tmp;
            tmp = new double[this.l_points.length + 5][2];
            System.arraycopy(this.l_points, 0, tmp, 0, this.l_points.length);
            this.l_points = tmp;
            tmp = new double[this.r_points.length + 5][2];
            System.arraycopy(this.r_points, 0, tmp, 0, this.r_points.length);
            this.r_points = tmp;
            int[] tmp2 = new int[this.bezierMousePoxIndexes.length + 5];
            System.arraycopy(this.bezierMousePoxIndexes, 0, tmp2, 0, this.bezierMousePoxIndexes.length);
            this.bezierMousePoxIndexes = tmp2;
        }
        this.b_points[this.nBeziers - 1][0] = this.newBezierPoints[3][0];
        this.b_points[this.nBeziers - 1][1] = this.newBezierPoints[3][1];
        this.r_points[this.nBeziers - 1][0] = this.newBezierPoints[2][0];
        this.r_points[this.nBeziers - 1][1] = this.newBezierPoints[2][1];
        this.l_points[this.nBeziers][0] = this.newBezierPoints[1][0];
        this.l_points[this.nBeziers][1] = this.newBezierPoints[1][1];
        this.b_points[this.nBeziers][0] = this.newBezierPoints[0][0];
        this.b_points[this.nBeziers][1] = this.newBezierPoints[0][1];
        this.bezierMousePoxIndexes[this.nBeziers] = this.lastBezierIndex = this.nPoints - 1;
        ++this.nBeziers;
        for (int i = 0; i < 4; ++i) {
            this.newBezierPoints[i][0] = this.newBezierPoints[0][0];
            this.newBezierPoints[i][1] = this.newBezierPoints[0][1];
        }
    }

    private double getMedSquaredError(double[][] targetPoints) {
        double ret = 0.0;
        for (int i = 0; i < 20; ++i) {
            double t = (double)(i + 1) / 21.0;
            double oneMinT = 1.0 - t;
            double dx = this.newBezierPoints[0][0] * t * t * t;
            dx += 3.0 * this.newBezierPoints[1][0] * t * t * oneMinT;
            dx += 3.0 * this.newBezierPoints[2][0] * t * oneMinT * oneMinT;
            dx += this.newBezierPoints[3][0] * oneMinT * oneMinT * oneMinT;
            dx -= targetPoints[i][0];
            dx *= dx;
            double dy = this.newBezierPoints[0][1] * t * t * t;
            dy += 3.0 * this.newBezierPoints[1][1] * t * t * oneMinT;
            dy += 3.0 * this.newBezierPoints[2][1] * t * oneMinT * oneMinT;
            dy += this.newBezierPoints[3][1] * oneMinT * oneMinT * oneMinT;
            dy -= targetPoints[i][1];
            dy *= dy;
            ret += dx + dy;
        }
        return ret / 20.0;
    }

    private void interpolateTargetSamples(double[][] targetPoints, int stepCount) {
        for (int i = 0; i < stepCount; ++i) {
            this.gradientDescentStep(targetPoints);
        }
    }

    private void gradientDescentStep(double[][] targetPoints) {
        double dX1 = 0.0;
        double dX2 = 0.0;
        double dY1 = 0.0;
        double dY2 = 0.0;
        for (int i = 0; i < 20; ++i) {
            double t = (double)(i + 1) / 21.0;
            double oneMinT = 1.0 - t;
            double tmp = this.newBezierPoints[0][0] * t * t * t;
            tmp += 3.0 * this.newBezierPoints[1][0] * t * t * oneMinT;
            tmp += 3.0 * this.newBezierPoints[2][0] * t * oneMinT * oneMinT;
            tmp += this.newBezierPoints[3][0] * oneMinT * oneMinT * oneMinT;
            tmp -= targetPoints[i][0];
            dX1 += (tmp *= 6.0 * t * oneMinT) * t;
            dX2 += tmp * oneMinT;
            tmp = this.newBezierPoints[0][1] * t * t * t;
            tmp += 3.0 * this.newBezierPoints[1][1] * t * t * oneMinT;
            tmp += 3.0 * this.newBezierPoints[2][1] * t * oneMinT * oneMinT;
            tmp += this.newBezierPoints[3][1] * oneMinT * oneMinT * oneMinT;
            tmp -= targetPoints[i][1];
            dY1 += (tmp *= 6.0 * t * oneMinT) * t;
            dY2 += tmp * oneMinT;
        }
        dX2 /= 20.0;
        dY2 /= 20.0;
        double[] dArray = this.newBezierPoints[1];
        dArray[0] = dArray[0] - 0.1 * (dX1 /= 20.0);
        double[] dArray2 = this.newBezierPoints[1];
        dArray2[1] = dArray2[1] - 0.1 * (dY1 /= 20.0);
        double[] dArray3 = this.newBezierPoints[2];
        dArray3[0] = dArray3[0] - 0.1 * dX2;
        double[] dArray4 = this.newBezierPoints[2];
        dArray4[1] = dArray4[1] - 0.1 * dY2;
    }

    private double[][] calculateMouseSamples(int fromIndex, int toIndex) {
        int i;
        double[][] mouseSamples = new double[20][2];
        double totExamplesLength = 0.0;
        double[] lengthToPoints = new double[toIndex - fromIndex + 1];
        lengthToPoints[0] = 0.0;
        for (i = fromIndex + 1; i <= toIndex; ++i) {
            lengthToPoints[i - fromIndex] = totExamplesLength += this.dist(this.all_points[i][0], this.all_points[i][1], this.all_points[i - 1][0], this.all_points[i - 1][1]);
        }
        if (totExamplesLength == 0.0) {
            for (i = 0; i < 20; ++i) {
                mouseSamples[i][0] = this.all_points[fromIndex][0];
                mouseSamples[i][1] = this.all_points[fromIndex][1];
            }
            return mouseSamples;
        }
        int index = 0;
        for (int i2 = 0; i2 < 20; ++i2) {
            double distFromFirst = (double)(i2 + 1) * totExamplesLength / 21.0;
            while (lengthToPoints[index] < distFromFirst) {
                ++index;
            }
            double factor = (distFromFirst - lengthToPoints[index - 1]) / (lengthToPoints[index] - lengthToPoints[index - 1]);
            mouseSamples[i2][0] = factor * (this.all_points[index + fromIndex][0] - this.all_points[index + fromIndex - 1][0]) + this.all_points[index + fromIndex][0];
            mouseSamples[i2][1] = factor * (this.all_points[index + fromIndex][1] - this.all_points[index + fromIndex - 1][1]) + this.all_points[index + fromIndex][1];
        }
        return mouseSamples;
    }

    private void adjustNewBezierEndPoint() {
        this.newBezierPoints[0][0] = this.all_points[this.nPoints - 1][0];
        this.newBezierPoints[0][1] = this.all_points[this.nPoints - 1][1];
    }

    private void insertPoint(double x, double y) {
        if (x == this.all_points[this.nPoints - 1][0] && y == this.all_points[this.nPoints - 1][1]) {
            return;
        }
        if (this.nPoints >= this.all_points.length) {
            double[][] tmp = new double[this.all_points.length + 5][2];
            System.arraycopy(this.all_points, 0, tmp, 0, this.all_points.length);
            this.all_points = tmp;
        }
        this.all_points[this.nPoints] = new double[]{x, y};
        ++this.nPoints;
    }

    public void abort() {
        this.updateProfile = false;
        this.isVisible = false;
    }

    public void paint(Graphics g, double magnification, Rectangle srcRect, boolean active) {
        if (this.isVisible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate((double)(this.profile.getX() - srcRect.x) * magnification, (double)(this.profile.getY() - srcRect.y) * magnification);
            g.setColor(Color.GREEN);
            for (int i = this.lastBezierIndex + 1; i < this.nPoints; ++i) {
                g.drawLine((int)(this.all_points[i][0] * magnification), (int)(this.all_points[i][1] * magnification), (int)(this.all_points[i - 1][0] * magnification), (int)(this.all_points[i - 1][1] * magnification));
            }
            g.setColor(Color.BLUE);
            for (int i = 1; i < this.nBeziers; ++i) {
                double lastX = this.b_points[i][0];
                double lastY = this.b_points[i][1];
                for (int j = 0; j <= 20; ++j) {
                    double t = (double)j / 20.0;
                    double newX = this.b_points[i - 1][0] * t * t * t;
                    newX += 3.0 * this.r_points[i - 1][0] * t * t * (1.0 - t);
                    newX += 3.0 * this.l_points[i][0] * t * (1.0 - t) * (1.0 - t);
                    double newY = this.b_points[i - 1][1] * t * t * t;
                    newY += 3.0 * this.r_points[i - 1][1] * t * t * (1.0 - t);
                    newY += 3.0 * this.l_points[i][1] * t * (1.0 - t) * (1.0 - t);
                    g.drawLine((int)(lastX * magnification), (int)(lastY * magnification), (int)((newX += this.b_points[i][0] * (1.0 - t) * (1.0 - t) * (1.0 - t)) * magnification), (int)((newY += this.b_points[i][1] * (1.0 - t) * (1.0 - t) * (1.0 - t)) * magnification));
                    lastX = newX;
                    lastY = newY;
                }
            }
            g2d.translate((double)(-(this.profile.getX() - srcRect.x)) * magnification, (double)(-(this.profile.getY() - srcRect.y)) * magnification);
        }
    }

    private double squaredDist(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    private double dist(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public int getMouseX() {
        return (int)this.mousePosition[0];
    }

    public int getMouseY() {
        return (int)this.mousePosition[1];
    }
}

