/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.process.ImageProcessor;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.GroupingMode;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Paintable;
import ini.trakem2.display.Patch;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TransformMesh;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.transform.AffineModel2D;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.MovingLeastSquaresTransform2;
import mpicbg.trakem2.transform.TransformMeshMappingWithMasks;

public class NonLinearTransformMode
extends GroupingMode {
    private final Collection<Point> points = new ArrayList<Point>();
    private Point p_clicked = null;

    @Override
    protected void doPainterUpdate(Rectangle r, double m) {
        try {
            mpicbg.trakem2.transform.CoordinateTransform mlst = this.createCT();
            SimilarityModel2D toWorld = new SimilarityModel2D();
            toWorld.set(1.0 / m, 0.0, (double)r.x - 100.0 / m, (double)r.y - 100.0 / m);
            mpicbg.models.CoordinateTransformList ctl = new mpicbg.models.CoordinateTransformList();
            ctl.add((CoordinateTransform)toWorld);
            ctl.add((CoordinateTransform)mlst);
            ctl.add((CoordinateTransform)toWorld.createInverse());
            CoordinateTransformMesh ctm = new CoordinateTransformMesh((CoordinateTransform)ctl, 32, (double)r.width * m + 200.0, (double)r.height * m + 200.0);
            TransformMeshMappingWithMasks mapping = new TransformMeshMappingWithMasks((TransformMesh)ctm);
            HashMap screenPatchRanges = this.screenPatchRanges;
            for (GroupingMode.ScreenPatchRange spr : screenPatchRanges.values()) {
                if (screenPatchRanges == this.screenPatchRanges) {
                    spr.update(mapping);
                    continue;
                }
                break;
            }
        }
        catch (NotEnoughDataPointsException mlst) {
        }
        catch (NoninvertibleModelException mlst) {
        }
        catch (IllDefinedDataPointsException mlst) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ScreenPatchRange createScreenPathRange(GroupingMode.PatchRange range, Rectangle srcRect, double magnification) {
        return new ScreenPatchRange(range, srcRect, magnification);
    }

    @Override
    protected GroupingMode.GroupedGraphicsSource createGroupedGraphicSource() {
        return new NonLinearTransformSource();
    }

    public NonLinearTransformMode(Display display, List<Displayable> selected) {
        super(display, selected);
        ProjectToolbar.setTool(10);
        super.initThreads();
    }

    public NonLinearTransformMode(Display display) {
        this(display, display.getSelection().getSelected());
    }

    @Override
    public void mousePressed(MouseEvent me, int x_p, int y_p, double magnification) {
        this.p_clicked = null;
        double min = Double.MAX_VALUE;
        Point mouse = new Point(new double[]{x_p, y_p});
        double a = 64.0 / magnification / magnification;
        for (Point p : this.points) {
            double sd = Point.squareDistance((Point)p, (Point)mouse);
            if (!(sd < min) || !(sd < a)) continue;
            this.p_clicked = p;
            min = sd;
        }
        if (me.isShiftDown()) {
            if (null == this.p_clicked) {
                try {
                    if (this.points.size() > 0) {
                        mpicbg.trakem2.transform.CoordinateTransform mlst = this.createCT();
                        SimilarityModel2D toWorld = new SimilarityModel2D();
                        toWorld.set(1.0 / magnification, 0.0, (double)this.srcRect.x, (double)this.srcRect.y);
                        SimilarityModel2D toScreen = toWorld.createInverse();
                        mpicbg.models.CoordinateTransformList ctl = new mpicbg.models.CoordinateTransformList();
                        ctl.add((CoordinateTransform)toWorld);
                        ctl.add((CoordinateTransform)mlst);
                        ctl.add((CoordinateTransform)toScreen);
                        CoordinateTransformMesh ctm = new CoordinateTransformMesh((CoordinateTransform)ctl, 32, (double)((int)Math.ceil((double)this.srcRect.width * magnification)), (double)((int)Math.ceil((double)this.srcRect.height * magnification)));
                        double[] l = mouse.getL();
                        toScreen.applyInPlace(l);
                        ctm.applyInverseInPlace(l);
                        toWorld.applyInPlace(l);
                    }
                    this.points.add(mouse);
                    this.p_clicked = mouse;
                }
                catch (Exception e) {
                    Utils.log("Could not add point");
                    e.printStackTrace();
                }
            } else if (Utils.isControlDown(me)) {
                this.points.remove(this.p_clicked);
                this.p_clicked = null;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        if (null != this.p_clicked) {
            double[] w = this.p_clicked.getW();
            w[0] = w[0] + (double)(x_d - x_d_old);
            w[1] = w[1] + (double)(y_d - y_d_old);
            this.painter.update();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        this.mouseDragged(me, x_p, y_p, x_r, y_r, x_d, y_d);
        this.p_clicked = null;
    }

    @Override
    public boolean isDragging() {
        return null != this.p_clicked;
    }

    private final void setUndoState() {
        this.layer.getParent().addEditStep(new Displayable.DoEdits(new HashSet(this.originalPatches)).init(new String[]{"data", "at", "width", "height"}));
    }

    private final Future<Boolean> applyToPatch(Patch patch) throws Exception {
        Rectangle pbox = patch.getCoordinateTransformBoundingBox();
        AffineTransform pat = new AffineTransform();
        pat.translate(-pbox.x, -pbox.y);
        pat.preConcatenate(patch.getAffineTransform());
        AffineModel2D toWorld = new AffineModel2D();
        toWorld.set(pat);
        mpicbg.trakem2.transform.CoordinateTransform mlst = this.createCT();
        CoordinateTransformList ctl = new CoordinateTransformList();
        ctl.add((CoordinateTransform)toWorld);
        ctl.add((CoordinateTransform)mlst);
        ctl.add((CoordinateTransform)toWorld.createInverse());
        patch.appendCoordinateTransform((mpicbg.trakem2.transform.CoordinateTransform)ctl);
        return patch.updateMipMaps();
    }

    @Override
    public boolean apply() {
        return this.apply(null);
    }

    public boolean apply(final Set<Layer> sublist) {
        this.setUndoState();
        Bureaucrat.createAndStart((Worker)new Worker.Task("Applying transformations"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exec() {
                ArrayList<Future> futures = new ArrayList<Future>();
                Iterator iterator = NonLinearTransformMode.this.updater;
                synchronized (iterator) {
                    for (Paintable p : NonLinearTransformMode.this.screenPatchRanges.keySet()) {
                        if (!(p instanceof Patch)) continue;
                        try {
                            futures.add(NonLinearTransformMode.this.applyToPatch((Patch)p));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (sublist != null && !sublist.isEmpty()) {
                        for (Layer layer : sublist) {
                            for (Displayable p : layer.getDisplayables(Patch.class)) {
                                try {
                                    futures.add(NonLinearTransformMode.this.applyToPatch((Patch)p));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
                for (GroupingMode.ScreenPatchRange spr : new HashSet(NonLinearTransformMode.this.screenPatchRanges.values())) {
                    spr.flush();
                }
                for (Future fu : futures) {
                    try {
                        fu.get();
                    }
                    catch (Exception exception) {}
                }
                NonLinearTransformMode.this.setUndoState();
            }
        }, this.layer.getProject());
        super.quitThreads();
        return true;
    }

    private mpicbg.trakem2.transform.CoordinateTransform createCT() throws Exception {
        ArrayList<PointMatch> pm = new ArrayList<PointMatch>();
        for (Point p : this.points) {
            pm.add(new PointMatch(new Point(p.getL()), new Point(p.getW())));
        }
        MovingLeastSquaresTransform2 mlst = new MovingLeastSquaresTransform2();
        mlst.setAlpha(1.0);
        Class<AffineModel2D> c = AffineModel2D.class;
        switch (this.points.size()) {
            case 1: {
                c = TranslationModel2D.class;
                break;
            }
            case 2: {
                c = SimilarityModel2D.class;
                break;
            }
        }
        mlst.setModel(c);
        mlst.setMatches(pm);
        return mlst;
    }

    private static class ScreenPatchRange
    extends GroupingMode.ScreenPatchRange<TransformMeshMappingWithMasks<?>> {
        ScreenPatchRange(GroupingMode.PatchRange range, Rectangle srcRect, double magnification) {
            super(range, srcRect, magnification);
        }

        @Override
        public void update(TransformMeshMappingWithMasks<?> mapping) {
            this.ipTransformed.reset();
            if (this.mask == null) {
                mapping.map(this.ip, this.ipTransformed);
            } else {
                this.maskTransformed.reset();
                TransformMeshMappingWithMasks.ImageProcessorWithMasks ipm = new TransformMeshMappingWithMasks.ImageProcessorWithMasks(this.ip, (ImageProcessor)this.mask, null);
                TransformMeshMappingWithMasks.ImageProcessorWithMasks tpm = new TransformMeshMappingWithMasks.ImageProcessorWithMasks(this.ipTransformed, (ImageProcessor)this.maskTransformed, null);
                mapping.map(ipm, tpm);
            }
            if (null != this.transformedImage) {
                this.transformedImage.flush();
            }
            this.transformedImage = super.makeImage(this.ipTransformed, this.maskTransformed);
        }
    }

    private class NonLinearTransformSource
    extends GroupingMode.GroupedGraphicsSource {
        private NonLinearTransformSource() {
            super(NonLinearTransformMode.this);
        }

        @Override
        public void paintOnTop(Graphics2D g, Display display, Rectangle srcRect, double magnification) {
            Stroke original_stroke = g.getStroke();
            AffineTransform original = g.getTransform();
            g.setTransform(new AffineTransform());
            g.setStroke(new BasicStroke(1.0f));
            for (Point p : NonLinearTransformMode.this.points) {
                double[] w = p.getW();
                Utils.drawPoint(g, (int)Math.round(magnification * (w[0] - (double)srcRect.x)), (int)Math.round(magnification * (w[1] - (double)srcRect.y)));
            }
            g.setTransform(original);
            g.setStroke(original_stroke);
        }
    }
}

