/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.taglets;

import com.sun.source.doctree.DocTree;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.Taglet;

public abstract class ParamTaglet
implements Taglet {
    private final String tagName;
    private final String title;

    protected ParamTaglet(String title) {
        this.tagName = title.toLowerCase();
        this.title = title;
    }

    @Override
    public Set<Taglet.Location> getAllowedLocations() {
        return Collections.singleton(Taglet.Location.FIELD);
    }

    @Override
    public boolean isInlineTag() {
        return false;
    }

    @Override
    public String getName() {
        return this.tagName;
    }

    @Override
    public String toString(List<? extends DocTree> tags, Element element) {
        return "\n<dt><span class=\"paramLabel\">" + this.title + " parameters:</span></dt>\n" + String.join((CharSequence)"", tags.stream().map(tag -> "<dd>" + this.tagToHTML((DocTree)tag) + "</dd>\n").collect(Collectors.toList()));
    }

    private String tagToHTML(DocTree tag) {
        String paramName;
        String text = tag.toString().trim().replaceFirst("^@" + this.tagName, "").trim();
        String description = text.substring((paramName = text.replaceFirst("\\s.*", "")).length()).trim();
        String separator = description.isEmpty() ? "" : " - ";
        return "<code>" + paramName + "</code>" + separator + description;
    }

    protected void registerMe(Map<String, Taglet> tagletMap) {
        tagletMap.put(this.getName(), this);
    }
}

