/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class BreakInstr
extends OneOperandInstr
implements FixedArityInstr {
    private final String scopeName;

    public BreakInstr(Operand returnValue, String scopeName) {
        super(Operation.BREAK, returnValue);
        this.scopeName = scopeName;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public Operand getReturnValue() {
        return this.getOperand1();
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.HAS_BREAK_INSTRS);
        scope.getFlags().add(IRFlags.REQUIRES_DYNSCOPE);
        return true;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"scope_name: " + this.scopeName};
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new BreakInstr(this.getReturnValue().cloneForInlining(info), this.scopeName);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.isClosure()) {
            return new BreakInstr(this.getReturnValue().cloneForInlining(ii), this.scopeName);
        }
        throw new UnsupportedOperationException("Break instructions shouldn't show up outside closures.");
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getReturnValue());
        e.encode(this.getScopeName());
    }

    public static BreakInstr decode(IRReaderDecoder d) {
        return new BreakInstr(d.decodeOperand(), d.decodeString());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BreakInstr(this);
    }
}

