/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.awt.Font;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;
import org.scijava.ui.swing.StaticSwingUtils;

class ItemTextPane {
    private DocumentCalculator initialCalculator = null;
    private JTextPane textPane = new JTextPane();
    private JScrollPane scrollPane = new JScrollPane(this.textPane);
    private boolean waitingForProcessNewItems = false;
    private DocumentCalculator calculator = new DocumentCalculator(Collections.emptyList().iterator());
    @Parameter
    private ThreadService threadService;

    ItemTextPane(Context context) {
        context.inject((Object)this);
        this.textPane.setEditable(false);
        this.textPane.setFont(new Font("Monospaced", 0, this.textPane.getFont().getSize()));
    }

    JComponent getJComponent() {
        return this.scrollPane;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.textPane.setComponentPopupMenu(menu);
    }

    public void setData(Iterator<Item> data) {
        DocumentCalculator calculator;
        this.calculator.cancel();
        if (this.initialCalculator != null) {
            this.initialCalculator.cancel();
        }
        this.initialCalculator = calculator = new DocumentCalculator(data);
        this.threadService.run(() -> this.initCalculator(calculator));
    }

    public void update() {
        if (this.waitingForProcessNewItems) {
            return;
        }
        this.waitingForProcessNewItems = true;
        this.threadService.queue(this::processNewItemsInSwingThread);
    }

    public void copySelectionToClipboard() {
        this.textPane.copy();
    }

    private void processNewItemsInSwingThread() {
        if (this.calculator.isCanceled()) {
            return;
        }
        this.waitingForProcessNewItems = false;
        boolean atBottom = StaticSwingUtils.isScrolledToBottom(this.scrollPane);
        this.calculator.update();
        if (atBottom) {
            StaticSwingUtils.scrollToBottom(this.scrollPane);
        }
    }

    private void initCalculator(DocumentCalculator calculator) {
        calculator.update();
        if (calculator.isCanceled()) {
            return;
        }
        this.threadService.queue(() -> this.applyCalculator(calculator));
    }

    private void applyCalculator(DocumentCalculator calculator) {
        if (this.initialCalculator != calculator) {
            return;
        }
        this.calculator = calculator;
        this.textPane.setDocument(calculator.document());
        this.processNewItemsInSwingThread();
        this.threadService.queue(() -> StaticSwingUtils.scrollToBottom(this.scrollPane));
    }

    JTextPane getTextPane() {
        return this.textPane;
    }

    static class DocumentCalculator {
        private final Iterator<Item> data;
        private final StyledDocument document = new DefaultStyledDocument();
        private boolean canceled = false;

        DocumentCalculator(Iterator<Item> data) {
            this.data = data;
        }

        public StyledDocument document() {
            return this.document;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.canceled = true;
        }

        public synchronized void update() {
            while (this.data.hasNext() && !this.canceled) {
                this.addText(this.data.next());
            }
        }

        private void addText(Item item) {
            try {
                this.document.insertString(this.document.getLength(), item.text(), item.style());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class Item {
        private final String text;
        private final AttributeSet style;

        Item(AttributeSet style, String text) {
            this.style = style;
            this.text = text;
        }

        final String text() {
            return this.text;
        }

        final AttributeSet style() {
            return this.style;
        }
    }
}

