/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.interval;

import net.imglib2.RealInterval;
import net.imglib2.realtransform.interval.Volume;

public class VolumeSteps
extends Volume {
    private final long[] steps;

    public VolumeSteps(long ... steps) {
        this.steps = steps;
    }

    @Override
    protected double[] spacing(RealInterval interval) {
        int i;
        double[] spacing = new double[interval.numDimensions()];
        int l = Math.min(spacing.length, this.steps.length);
        for (i = 0; i < l; ++i) {
            spacing[i] = (interval.realMax(i) - interval.realMin(i)) / (double)this.steps[i];
        }
        for (i = this.steps.length; i < spacing.length; ++i) {
            spacing[i] = (interval.realMax(i) - interval.realMin(i)) / (double)this.steps[this.steps.length - 1];
        }
        return spacing;
    }
}

