/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.eval;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.engine.util.FunctionUtils;
import org.scijava.parsington.Operator;
import org.scijava.parsington.Operators;
import org.scijava.parsington.Variable;
import org.scijava.parsington.eval.DefaultStackEvaluator;
import org.scijava.types.Nil;

public class OpEvaluator
extends DefaultStackEvaluator {
    private final OpEnvironment ops;
    private final HashMap<Operator, String> opMap;

    public OpEvaluator(OpEnvironment ops) {
        this.ops = ops;
        this.opMap = new HashMap();
        this.opMap.put(Operators.POW, "math.pow");
        this.opMap.put(Operators.POS, "identity");
        this.opMap.put(Operators.NEG, "math.negate");
        this.opMap.put(Operators.MUL, "math.multiply");
        this.opMap.put(Operators.DIV, "math.divide");
        this.opMap.put(Operators.MOD, "math.remainder");
        this.opMap.put(Operators.ADD, "math.add");
        this.opMap.put(Operators.SUB, "math.subtract");
        this.opMap.put(Operators.LEFT_SHIFT, "math.leftShift");
        this.opMap.put(Operators.RIGHT_SHIFT, "math.rightShift");
        this.opMap.put(Operators.UNSIGNED_RIGHT_SHIFT, "math.unsignedLeftShift");
        this.opMap.put(Operators.LESS_THAN, "math.lessThan");
        this.opMap.put(Operators.GREATER_THAN, "math.greaterThan");
        this.opMap.put(Operators.LESS_THAN_OR_EQUAL, "math.lessThanOrEqual");
        this.opMap.put(Operators.GREATER_THAN_OR_EQUAL, "math.greaterThanOrEqual");
        this.opMap.put(Operators.EQUAL, "math.equal");
        this.opMap.put(Operators.NOT_EQUAL, "math.notEqual");
        this.opMap.put(Operators.BITWISE_AND, "math.and");
        this.opMap.put(Operators.BITWISE_OR, "math.or");
        this.opMap.put(Operators.LOGICAL_AND, "logic.and");
        this.opMap.put(Operators.LOGICAL_OR, "logic.or");
    }

    @Override
    public Object execute(Operator op, Object ... args) {
        return this.execute(this.getOpName(op), args);
    }

    public Object execute(String opName, Object ... args) {
        Object[] argValues = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            argValues[i] = this.value(args[i]);
        }
        Nil[] inTypes = (Nil[])Arrays.stream(args).map(obj -> this.type(this.value(obj))).toArray(Nil[]::new);
        Nil<Object> outType = new Nil<Object>(){};
        Functions.ArityN<Object> func = FunctionUtils.matchN(this.ops, opName, outType, inTypes);
        return func.apply(argValues);
    }

    private <T> Nil<T> type(Object obj) {
        return Nil.of((Type)this.ops.genericType(obj));
    }

    public String getOpName(Operator op) {
        return this.opMap.containsKey(op) ? this.opMap.get(op) : op.getToken();
    }

    public Map<Operator, String> getOpMap() {
        return this.opMap;
    }

    @Override
    public Object function(Object a, Object b) {
        if (a instanceof Variable) {
            return this.execute(((Variable)a).getToken(), this.list(b).toArray());
        }
        return null;
    }

    @Override
    public Object dot(Object a, Object b) {
        if (a instanceof Variable && b instanceof Variable) {
            String namespace = ((Variable)a).getToken();
            String opName = ((Variable)b).getToken();
            return new Variable(namespace + "." + opName);
        }
        return this.execute(Operators.DOT, a, b);
    }

    @Override
    public Object parens(Object[] args) {
        if (args.length == 1) {
            return args[0];
        }
        return Arrays.asList(args);
    }

    @Override
    public Object brackets(Object[] args) {
        return Arrays.asList(args);
    }

    @Override
    public Object braces(Object[] args) {
        return Arrays.asList(args);
    }

    @Override
    public Object transpose(Object a) {
        return this.execute(Operators.TRANSPOSE, a);
    }

    @Override
    public Object dotTranspose(Object a) {
        return this.execute(Operators.DOT_TRANSPOSE, a);
    }

    @Override
    public Object pow(Object a, Object b) {
        return this.execute(Operators.POW, a, b);
    }

    @Override
    public Object dotPow(Object a, Object b) {
        return this.execute(Operators.DOT_POW, a, b);
    }

    @Override
    public Object pos(Object a) {
        return this.execute(Operators.POS, a);
    }

    @Override
    public Object neg(Object a) {
        return this.execute(Operators.NEG, a);
    }

    @Override
    public Object complement(Object a) {
        return this.execute(Operators.COMPLEMENT, a);
    }

    @Override
    public Object not(Object a) {
        return this.execute(Operators.NOT, a);
    }

    @Override
    public Object mul(Object a, Object b) {
        return this.execute(Operators.MUL, a, b);
    }

    @Override
    public Object div(Object a, Object b) {
        return this.execute(Operators.DIV, a, b);
    }

    @Override
    public Object mod(Object a, Object b) {
        return this.execute(Operators.MOD, a, b);
    }

    @Override
    public Object rightDiv(Object a, Object b) {
        return this.execute(Operators.RIGHT_DIV, a, b);
    }

    @Override
    public Object dotMul(Object a, Object b) {
        return this.execute(Operators.DOT_MUL, a, b);
    }

    @Override
    public Object dotDiv(Object a, Object b) {
        return this.execute(Operators.DOT_DIV, a, b);
    }

    @Override
    public Object dotRightDiv(Object a, Object b) {
        return this.execute(Operators.DOT_RIGHT_DIV, a, b);
    }

    @Override
    public Object add(Object a, Object b) {
        return this.execute(Operators.ADD, a, b);
    }

    @Override
    public Object sub(Object a, Object b) {
        return this.execute(Operators.SUB, a, b);
    }

    @Override
    public Object leftShift(Object a, Object b) {
        return this.execute(Operators.LEFT_SHIFT, a, b);
    }

    @Override
    public Object rightShift(Object a, Object b) {
        return this.execute(Operators.RIGHT_SHIFT, a, b);
    }

    @Override
    public Object unsignedRightShift(Object a, Object b) {
        return this.execute(Operators.UNSIGNED_RIGHT_SHIFT, a, b);
    }

    @Override
    public Object colon(Object a, Object b) {
        return this.execute(Operators.COLON, a, b);
    }

    @Override
    public Object lessThan(Object a, Object b) {
        return this.execute(Operators.LESS_THAN, a, b);
    }

    @Override
    public Object greaterThan(Object a, Object b) {
        return this.execute(Operators.GREATER_THAN, a, b);
    }

    @Override
    public Object lessThanOrEqual(Object a, Object b) {
        return this.execute(Operators.LESS_THAN_OR_EQUAL, a, b);
    }

    @Override
    public Object greaterThanOrEqual(Object a, Object b) {
        return this.execute(Operators.GREATER_THAN_OR_EQUAL, a, b);
    }

    @Override
    public Object instanceOf(Object a, Object b) {
        return this.execute(Operators.INSTANCEOF, a, b);
    }

    @Override
    public Object equal(Object a, Object b) {
        return this.execute(Operators.EQUAL, a, b);
    }

    @Override
    public Object notEqual(Object a, Object b) {
        return this.execute(Operators.NOT_EQUAL, a, b);
    }

    @Override
    public Object bitwiseAnd(Object a, Object b) {
        return this.execute(Operators.BITWISE_AND, a, b);
    }

    @Override
    public Object bitwiseOr(Object a, Object b) {
        return this.execute(Operators.BITWISE_OR, a, b);
    }

    @Override
    public Object logicalAnd(Object a, Object b) {
        return this.execute(Operators.LOGICAL_AND, a, b);
    }

    @Override
    public Object logicalOr(Object a, Object b) {
        return this.execute(Operators.LOGICAL_OR, a, b);
    }

    @Override
    public Object execute(Operator op, Deque<Object> stack) {
        int arity = op.getArity();
        Object[] args = new Object[arity];
        for (int i = args.length - 1; i >= 0; --i) {
            args[i] = stack.pop();
        }
        for (Object arg : args) {
            stack.push(arg);
        }
        Object result = super.execute(op, stack);
        if (result != null) {
            return result;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.value(args[i]);
        }
        return this.execute(op, args);
    }

    private List<?> list(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        return Collections.singletonList(o);
    }
}

