/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.BBox;
import org.jogamp.java3d.utils.geometry.BottleNeck;
import org.jogamp.java3d.utils.geometry.Degenerate;
import org.jogamp.java3d.utils.geometry.Numerics;
import org.jogamp.java3d.utils.geometry.PntNode;
import org.jogamp.java3d.utils.geometry.Triangulator;

class NoHash {
    static final int NIL = -1;

    NoHash() {
    }

    static void insertAfterVtx(Triangulator triRef, int iVtx) {
        if (triRef.vtxList == null) {
            int size = Math.max(triRef.numVtxList + 1, 100);
            triRef.vtxList = new PntNode[size];
        } else if (triRef.numVtxList >= triRef.vtxList.length) {
            int size = Math.max(triRef.numVtxList + 1, triRef.vtxList.length + 100);
            PntNode[] old = triRef.vtxList;
            triRef.vtxList = new PntNode[size];
            System.arraycopy(old, 0, triRef.vtxList, 0, old.length);
        }
        triRef.vtxList[triRef.numVtxList] = new PntNode();
        triRef.vtxList[triRef.numVtxList].pnt = iVtx;
        triRef.vtxList[triRef.numVtxList].next = triRef.reflexVertices;
        triRef.reflexVertices = triRef.numVtxList++;
        ++triRef.numReflex;
    }

    static void deleteFromList(Triangulator triRef, int i) {
        int indVtx;
        if (triRef.numReflex == 0) {
            return;
        }
        int indPnt = triRef.reflexVertices;
        if (!NoHash.inVtxList(triRef, indPnt)) {
            System.out.println("NoHash:deleteFromList. Problem :Not is InVtxList ..." + indPnt);
        }
        if ((indVtx = triRef.vtxList[indPnt].pnt) == i) {
            triRef.reflexVertices = triRef.vtxList[indPnt].next;
            --triRef.numReflex;
        } else {
            int indPnt1 = triRef.vtxList[indPnt].next;
            while (indPnt1 != -1) {
                if (!NoHash.inVtxList(triRef, indPnt1)) {
                    System.out.println("NoHash:deleteFromList. Problem :Not is InVtxList ..." + indPnt1);
                }
                if ((indVtx = triRef.vtxList[indPnt1].pnt) == i) {
                    triRef.vtxList[indPnt].next = triRef.vtxList[indPnt1].next;
                    indPnt1 = -1;
                    --triRef.numReflex;
                    continue;
                }
                indPnt = indPnt1;
                indPnt1 = triRef.vtxList[indPnt].next;
            }
        }
    }

    static boolean inVtxList(Triangulator triRef, int vtx) {
        return 0 <= vtx && vtx < triRef.numVtxList;
    }

    static void freeNoHash(Triangulator triRef) {
        triRef.noHashingEdges = false;
        triRef.noHashingPnts = false;
        triRef.numVtxList = 0;
    }

    static void prepareNoHashEdges(Triangulator triRef, int currLoopMin, int currLoopMax) {
        triRef.loopMin = currLoopMin;
        triRef.loopMax = currLoopMax;
        triRef.noHashingEdges = true;
    }

    static void prepareNoHashPnts(Triangulator triRef, int currLoopMin) {
        int ind;
        triRef.numVtxList = 0;
        triRef.reflexVertices = -1;
        int ind1 = ind = triRef.loops[currLoopMin];
        triRef.numReflex = 0;
        int i1 = triRef.fetchData(ind1);
        do {
            if (triRef.getAngle(ind1) < 0) {
                NoHash.insertAfterVtx(triRef, ind1);
            }
            ind1 = triRef.fetchNextData(ind1);
            i1 = triRef.fetchData(ind1);
        } while (ind1 != ind);
        triRef.noHashingPnts = true;
    }

    static boolean noHashIntersectionExists(Triangulator triRef, int i1, int ind1, int i2, int i3, BBox bb) {
        int[] type = new int[1];
        if (!triRef.noHashingPnts) {
            System.out.println("NoHash:noHashIntersectionExists noHashingPnts is false");
        }
        if (triRef.numReflex <= 0) {
            return false;
        }
        if (i1 < bb.imin) {
            bb.imin = i1;
        } else if (i1 > bb.imax) {
            bb.imax = i1;
        }
        double y = triRef.points[i1].y;
        if (y < bb.ymin) {
            bb.ymin = y;
        } else if (y > bb.ymax) {
            bb.ymax = y;
        }
        int indPnt = triRef.reflexVertices;
        boolean flag = false;
        do {
            int indVtx;
            int i4;
            if (!bb.pntInBBox(triRef, i4 = triRef.fetchData(indVtx = triRef.vtxList[indPnt].pnt))) continue;
            int ind5 = triRef.fetchNextData(indVtx);
            int i5 = triRef.fetchData(ind5);
            if (indVtx == ind1 || indVtx == ind5 || !(i4 == i1 ? Degenerate.handleDegeneracies(triRef, i1, ind1, i2, i3, i4, indVtx) : i4 != i2 && i4 != i3 && (flag = Numerics.vtxInTriangle(triRef, i1, i2, i3, i4, type)))) continue;
            return true;
        } while ((indPnt = triRef.vtxList[indPnt].next) != -1);
        return false;
    }

    static void deleteReflexVertex(Triangulator triRef, int ind) {
        NoHash.deleteFromList(triRef, ind);
    }

    static boolean noHashEdgeIntersectionExists(Triangulator triRef, BBox bb, int i1, int i2, int ind5, int i5) {
        if (!triRef.noHashingEdges) {
            System.out.println("NoHash:noHashEdgeIntersectionExists noHashingEdges is false");
        }
        triRef.identCntr = 0;
        for (int i = triRef.loopMin; i < triRef.loopMax; ++i) {
            int ind;
            int ind2 = ind = triRef.loops[i];
            int i3 = triRef.fetchData(ind2);
            do {
                int i4;
                BBox bb1;
                if (bb.BBoxOverlap(bb1 = new BBox(triRef, i3, i4 = triRef.fetchData(ind2 = triRef.fetchNextData(ind2)))) && Numerics.segIntersect(triRef, bb.imin, bb.imax, bb1.imin, bb1.imax, i5)) {
                    return true;
                }
                i3 = i4;
            } while (ind2 != ind);
        }
        if (triRef.identCntr >= 4) {
            return BottleNeck.checkBottleNeck(triRef, i5, i1, i2, ind5);
        }
        return false;
    }
}

