/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.text.NumberFormat;
import java.util.Locale;
import view5d.ROI;

public abstract class AnElement {
    public static int InvalidType = -10;
    public static int ByteType = 0;
    public static int IntegerType = 1;
    public static int FloatType = 2;
    public static int DoubleType = 3;
    public static int ComplexType = 4;
    public static int ShortType = 5;
    public static int LongType = 6;
    public static int UnsignedShortType = 7;
    public static int NumTypes = 7;
    public static String[] TypeNames = new String[]{"Byte", "Integer", "Float", "Double", "Complex", "Short", "Long", "Unsigned Short"};
    public static String[] UTypeNames = new String[]{"Unsigned Byte", "Unsigned Integer", "Float", "Double", "Complex", "Short", "Unsigned Long", "Unsigned Short"};
    public int[] Sizes;
    public double[] Scales;
    public double ScaleV;
    public double OffsetV;
    public double[] Offsets;
    public double[] DisplayOffset = new double[]{0.0, 0.0, 0.0};
    public String[] Units;
    public String[] Names;
    public String UnitV;
    public String NameV;
    public int DataType;
    double MaxValue;
    double scaleB = 1.0;
    double scaleI = 1.0;
    double shift = 0.0;
    double Min = 0.0;
    double Max = 0.0;
    AnElement DataToHistogramX = null;
    AnElement DataToHistogramY = null;
    AnElement DataToHistogramZ = null;
    public NumberFormat nf;

    AnElement(int SX, int SY, int SZ, double MV) {
        this.MaxValue = MV;
        this.Sizes = new int[3];
        this.Units = new String[5];
        this.Names = new String[5];
        this.Sizes[0] = SX;
        this.Sizes[1] = SY;
        this.Sizes[2] = SZ;
        this.Scales = new double[5];
        this.Offsets = new double[5];
        this.Scales[0] = 1.0;
        this.Scales[1] = 1.0;
        this.Scales[2] = 1.0;
        this.Scales[3] = 1.0;
        this.Scales[4] = 1.0;
        this.ScaleV = 1.0;
        this.OffsetV = 0.0;
        this.Offsets[0] = 0.0;
        this.Offsets[1] = 0.0;
        this.Offsets[2] = 0.0;
        this.Offsets[3] = 0.0;
        this.Offsets[4] = 0.0;
        this.Names[0] = "X";
        this.Names[1] = "Y";
        this.Names[2] = "Z";
        this.Names[3] = "Element";
        this.Names[4] = "Time";
        this.Units[0] = "pixels";
        this.Units[1] = "pixels";
        this.Units[2] = "pixels";
        this.Units[3] = "elements";
        this.Units[4] = "steps";
        this.NameV = "intensity";
        this.UnitV = "a.u.";
        this.DataType = InvalidType;
        this.nf = NumberFormat.getNumberInstance(Locale.US);
        this.nf.setMaximumFractionDigits(4);
        this.nf.setGroupingUsed(false);
    }

    abstract void Clear();

    abstract void DeleteData();

    abstract void SetValueAt(int var1, int var2, int var3, double var4);

    abstract int GetStdByteNum();

    int GetStdBitNum() {
        return 8 * this.GetStdByteNum();
    }

    abstract double GetRawValueAt(int var1, int var2, int var3);

    abstract double GetValueAt(int var1, int var2, int var3);

    String GetDataTypeName() {
        return TypeNames[this.DataType];
    }

    double GetRawValueWithBounds(int x, int y, int z) {
        if (x >= this.Sizes[0]) {
            x = this.Sizes[0] - 1;
        }
        if (y >= this.Sizes[1]) {
            y = this.Sizes[1] - 1;
        }
        if (z >= this.Sizes[2]) {
            z = this.Sizes[2] - 1;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (z < 0) {
            z = 0;
        }
        return this.GetRawValueAt(x, y, z);
    }

    double GetRawValueAtOffset(int x, int y, int z, AnElement Reference) {
        return this.GetRawValueWithBounds(x - (int)this.DisplayOffset[0] + (int)Reference.DisplayOffset[0], y - (int)this.DisplayOffset[1] + (int)Reference.DisplayOffset[1], z - (int)this.DisplayOffset[2] + (int)Reference.DisplayOffset[2]);
    }

    double GetValueAtOffset(int x, int y, int z, AnElement Reference) {
        return this.GetValueWithBounds(x - (int)this.DisplayOffset[0] + (int)Reference.DisplayOffset[0], y - (int)this.DisplayOffset[1] + (int)Reference.DisplayOffset[1], z - (int)this.DisplayOffset[2] + (int)Reference.DisplayOffset[2]);
    }

    String GetValueStringAt(int x, int y, int z) {
        return this.nf.format(this.GetValueAt(x, y, z));
    }

    boolean GateAboveZero(int x, int y, int z, AnElement Reference) {
        return this.GetIntValueAt(x - (int)this.DisplayOffset[0] + (int)Reference.DisplayOffset[0], y - (int)this.DisplayOffset[1] + (int)Reference.DisplayOffset[1], z - (int)this.DisplayOffset[2] + (int)Reference.DisplayOffset[2]) > 0;
    }

    boolean InROIRange(int x, int y, int z, ROI myroi) {
        return myroi.InROIRange(x + (int)this.DisplayOffset[0], y + (int)this.DisplayOffset[1], z + (int)this.DisplayOffset[2]);
    }

    boolean InsideBounds(int x, int y, int z) {
        if (x >= this.Sizes[0]) {
            return false;
        }
        if (y >= this.Sizes[1]) {
            return false;
        }
        if (z >= this.Sizes[2]) {
            return false;
        }
        if (x < 0) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        return z >= 0;
    }

    double GetValueWithBounds(int x, int y, int z) {
        if (x >= this.Sizes[0]) {
            x = this.Sizes[0] - 1;
        }
        if (y >= this.Sizes[1]) {
            y = this.Sizes[1] - 1;
        }
        if (z >= this.Sizes[2]) {
            z = this.Sizes[2] - 1;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (z < 0) {
            z = 0;
        }
        return this.GetValueAt(x, y, z);
    }

    abstract int GetIntValueAt(int var1, int var2, int var3);

    boolean WithinBounds(int x, int y, int z) {
        if (x >= this.Sizes[0]) {
            return false;
        }
        if (y >= this.Sizes[1]) {
            return false;
        }
        if (z >= this.Sizes[2]) {
            return false;
        }
        if (x < 0) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        return z >= 0;
    }

    int GetIntValueWithBounds(int x, int y, int z) {
        if (x >= this.Sizes[0]) {
            x = this.Sizes[0] - 1;
        }
        if (y >= this.Sizes[1]) {
            y = this.Sizes[1] - 1;
        }
        if (z >= this.Sizes[2]) {
            z = this.Sizes[2] - 1;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (z < 0) {
            z = 0;
        }
        return this.GetIntValueAt(x, y, z);
    }

    abstract int GetByteValueAt(int var1, int var2, int var3);

    abstract void ConvertSliceFromSimilar(int var1, int var2, Object var3, int var4, int var5);

    abstract void ConvertSliceFromByte(int var1, int var2, byte[] var3, int var4, int var5);

    abstract void ConvertSliceFromRGB(int var1, int var2, int[] var3, int var4, int var5, int var6);

    abstract void CopySliceToSimilar(int var1, Object var2);

    void AdvanceReadMode() {
    }

    void SetReadMode(int rmode) {
    }

    void SetScales(AnElement e) {
        this.Scales[0] = e.Scales[0];
        this.Scales[1] = e.Scales[1];
        this.Scales[2] = e.Scales[2];
        this.Scales[3] = e.Scales[3];
        this.Scales[4] = e.Scales[4];
        this.Offsets[0] = e.Offsets[0];
        this.Offsets[1] = e.Offsets[1];
        this.Offsets[2] = e.Offsets[2];
        this.Offsets[3] = e.Offsets[3];
        this.Offsets[4] = e.Offsets[4];
        this.ScaleV = e.ScaleV;
        this.OffsetV = e.OffsetV;
        this.NameV = e.NameV;
        this.UnitV = e.UnitV;
        this.Units = e.Units;
        this.Names = e.Names;
    }

    void SetScales(double ValScale, double ValOffset, String VName, String VUnit) {
        this.ScaleV = ValScale;
        this.OffsetV = ValOffset;
        this.NameV = VName;
        this.UnitV = VUnit;
    }

    void SetScales(double[] NScales, double[] NOffsets, double SV, double OV) {
        this.Scales = NScales;
        this.Offsets = NOffsets;
        this.ScaleV = SV;
        this.OffsetV = OV;
    }

    void Add(AnElement other) {
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    this.SetValueAt(x, y, z, this.GetValueAt(x, y, z) + other.GetValueAt(x, y, z));
                }
            }
        }
    }

    void Sub(AnElement other) {
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    this.SetValueAt(x, y, z, this.GetValueAt(x, y, z) - other.GetValueAt(x, y, z));
                }
            }
        }
    }

    void Mul(AnElement other) {
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    this.SetValueAt(x, y, z, this.GetValueAt(x, y, z) * other.GetValueAt(x, y, z));
                }
            }
        }
    }

    void Div(AnElement other) {
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    if (other.GetValueAt(x, y, z) != 0.0) {
                        this.SetValueAt(x, y, z, this.GetValueAt(x, y, z) / other.GetValueAt(x, y, z));
                        continue;
                    }
                    if (this.GetValueAt(x, y, z) == 0.0) {
                        this.SetValueAt(x, y, z, 0.0);
                        continue;
                    }
                    this.SetValueAt(x, y, z, 1.0E32);
                }
            }
        }
    }

    static double ComputeIntMaxScale(int dx, int dy, int dz, double fwhm) {
        double myintegral = 0.0;
        double sigma2 = fwhm / 2.0 * (fwhm / 2.0) / Math.log(2.0);
        for (int zz = -dz; zz <= dz; ++zz) {
            for (int yy = -dy; yy <= dy; ++yy) {
                for (int xx = -dx; xx <= dx; ++xx) {
                    double r2 = xx * xx + yy * yy + zz * zz;
                    myintegral += Math.exp(-r2 / sigma2);
                }
            }
        }
        if (myintegral > 0.0) {
            return 1.0 / myintegral;
        }
        return 0.0;
    }

    void SubtractGauss(double px, double py, double pz, double integral, int dx, int dy, int dz, double fwhm) {
        double val;
        double r2;
        int x = (int)(px + 0.5);
        int y = (int)(py + 0.5);
        int z = (int)(pz + 0.5);
        double myintegral = 0.0;
        double valintegral = 0.0;
        double sigma2 = fwhm / 2.0 * (fwhm / 2.0) / Math.log(2.0);
        double mval = this.GetValueAt(x, y, z);
        for (int zz = z - dz; zz <= z + dz; ++zz) {
            for (int yy = y - dy; yy <= y + dy; ++yy) {
                for (int xx = x - dx; xx <= x + dx; ++xx) {
                    r2 = ((double)xx - px) * ((double)xx - px) + ((double)yy - py) * ((double)yy - py) + ((double)zz - pz) * ((double)zz - pz);
                    myintegral += Math.exp(-r2 / sigma2);
                    val = this.GetValueAt(xx, yy, zz);
                    valintegral += val;
                    if (!(val < mval)) continue;
                    mval = val;
                }
            }
        }
        double intensity = (valintegral - mval * (double)(dx * 2 + 1) * (double)(dy * 2 + 1) * (double)(dz * 2 + 1)) / myintegral;
        for (int zz = z - dz; zz <= z + dz; ++zz) {
            for (int yy = y - dy; yy <= y + dy; ++yy) {
                for (int xx = x - dx; xx <= x + dx; ++xx) {
                    r2 = ((double)xx - px) * ((double)xx - px) + ((double)yy - py) * ((double)yy - py) + ((double)zz - pz) * ((double)zz - pz);
                    val = this.GetValueAt(xx, yy, zz) - intensity * Math.exp(-r2 / sigma2);
                    this.SetValueAt(xx, yy, zz, val);
                }
            }
        }
    }

    void CopyVal(AnElement other) {
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    this.SetValueAt(x, y, z, other.GetValueAt(x, y, z));
                }
            }
        }
    }

    void SetScaleShift(double mincs, double maxcs) {
        this.scaleB = 256.0 / (maxcs - mincs);
        this.scaleI = 32769.0 / (maxcs - mincs);
        this.shift = mincs;
    }

    void SetMinMax() {
        this.Max = this.GetRawValueAt(0, 0, 0);
        this.Min = this.GetRawValueAt(0, 0, 0);
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    double val = this.GetRawValueAt(x, y, z);
                    if (val > this.Max) {
                        this.Max = val;
                    }
                    if (!(val < this.Min)) continue;
                    this.Min = val;
                }
            }
        }
    }

    double ROIMaximum(ROI roi) {
        double max = -1.0E30;
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    if (!roi.InROIRange(x, y, z) || !(this.GetRawValueAt(x, y, z) > max)) continue;
                    max = this.GetRawValueAt(x, y, z);
                }
            }
        }
        return max;
    }

    double ROIMinimum(ROI roi) {
        double min = 1.0E30;
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    if (!roi.InROIRange(x, y, z) || !(this.GetRawValueAt(x, y, z) < min)) continue;
                    min = this.GetRawValueAt(x, y, z);
                }
            }
        }
        return min;
    }

    void GenerateMask(ROI roi, AnElement gate, AnElement from, boolean cpData) {
        if (!cpData) {
            for (int z = 0; z < this.Sizes[2]; ++z) {
                for (int y = 0; y < this.Sizes[1]; ++y) {
                    for (int x = 0; x < this.Sizes[0]; ++x) {
                        if (!roi.InROIRange(x, y, z)) continue;
                        if (gate.GetIntValueAt(x, y, z) > 0) {
                            this.SetValueAt(x, y, z, 1.0);
                            continue;
                        }
                        this.SetValueAt(x, y, z, 0.0);
                    }
                }
            }
        } else {
            for (int z = 0; z < this.Sizes[2]; ++z) {
                for (int y = 0; y < this.Sizes[1]; ++y) {
                    for (int x = 0; x < this.Sizes[0]; ++x) {
                        if (!roi.InROIRange(x, y, z)) continue;
                        if (gate.GetIntValueAt(x, y, z) > 0) {
                            this.SetValueAt(x, y, z, from.GetRawValueAt(x, y, z));
                            continue;
                        }
                        this.SetValueAt(x, y, z, 0.0);
                    }
                }
            }
        }
    }

    void ComputeHistMask(AnElement mask, ROI roi) {
        double ex = 0.0;
        double ey = 0.0;
        double ez = 0.0;
        if (this.DataToHistogramX == null) {
            System.out.println("Error : No X-direction present for Histogram !\n");
            return;
        }
        for (int z = 0; z < this.DataToHistogramX.Sizes[2]; ++z) {
            for (int y = 0; y < this.DataToHistogramX.Sizes[1]; ++y) {
                for (int x = 0; x < this.DataToHistogramX.Sizes[0]; ++x) {
                    if (this.DataToHistogramX != null) {
                        ex = this.DataToHistogramX.GetValueAtOffset(x, y, z, this.DataToHistogramX);
                    }
                    if (this.DataToHistogramY != null) {
                        ey = this.DataToHistogramY.GetValueAtOffset(x, y, z, this.DataToHistogramX);
                    }
                    if (this.DataToHistogramZ != null) {
                        ez = this.DataToHistogramZ.GetValueAtOffset(x, y, z, this.DataToHistogramX);
                    }
                    if (roi.InROIRange((int)((ex - this.Offsets[0]) / this.Scales[0] + 0.5), (int)((ey - this.Offsets[1]) / this.Scales[1] + 0.5), (int)((ez - this.Offsets[2]) / this.Scales[2] + 0.5))) {
                        mask.SetValueAt(x, y, z, 1.0);
                        continue;
                    }
                    mask.SetValueAt(x, y, z, 0.0);
                }
            }
        }
        mask.Max = 1.0;
        mask.Min = 0.0;
        mask.MaxValue = 5.0;
        mask.AlignDisplayTo(this.DataToHistogramX);
    }

    public void AlignDisplayTo(AnElement other) {
        this.DisplayOffset[0] = other.DisplayOffset[0];
        this.DisplayOffset[1] = other.DisplayOffset[1];
        this.DisplayOffset[2] = other.DisplayOffset[2];
    }

    public int ComputeHistogram(AnElement gate, ROI roi) {
        this.NameV = "frequency";
        this.UnitV = "cnts";
        System.out.println("Computing Histogram with Hscale (X,Y,Z): " + this.Scales[0] + ", " + this.Scales[1] + ", " + this.Scales[2]);
        System.out.println("Offsets: " + this.Offsets[0] + ", " + this.Offsets[1] + ", " + this.Offsets[2]);
        if (this.DataToHistogramX == null) {
            System.out.println("Error: No data connected to this histogram");
            return 0;
        }
        this.Units[0] = this.DataToHistogramX.UnitV;
        this.Names[0] = this.DataToHistogramX.NameV;
        if (this.DataToHistogramY != null) {
            this.Units[1] = this.DataToHistogramY.UnitV;
            this.Names[1] = this.DataToHistogramY.NameV;
        }
        if (this.DataToHistogramZ != null) {
            this.Units[2] = this.DataToHistogramZ.UnitV;
            this.Names[2] = this.DataToHistogramZ.NameV;
        }
        int max = 0;
        for (int z = 0; z < this.DataToHistogramX.Sizes[2]; ++z) {
            for (int y = 0; y < this.DataToHistogramX.Sizes[1]; ++y) {
                for (int x = 0; x < this.DataToHistogramX.Sizes[0]; ++x) {
                    double val;
                    if (!gate.GateAboveZero(x, y, z, this.DataToHistogramX) || !this.DataToHistogramX.InROIRange(x, y, z, roi)) continue;
                    int px = 0;
                    int py = 0;
                    int pz = 0;
                    if (this.DataToHistogramX != null) {
                        val = this.DataToHistogramX.GetValueAtOffset(x, y, z, this.DataToHistogramX);
                        px = (int)((val - this.Offsets[0]) / this.Scales[0]);
                        if (px < 0) {
                            px = 0;
                        }
                        if (px >= this.Sizes[0]) {
                            px = this.Sizes[0] - 1;
                        }
                    }
                    if (this.DataToHistogramY != null) {
                        val = this.DataToHistogramY.GetValueAtOffset(x, y, z, this.DataToHistogramX);
                        py = (int)((val - this.Offsets[1]) / this.Scales[1]);
                        if (py < 0) {
                            py = 0;
                        }
                        if (py >= this.Sizes[1]) {
                            py = this.Sizes[1] - 1;
                        }
                    }
                    if (this.DataToHistogramZ != null) {
                        val = this.DataToHistogramZ.GetValueAtOffset(x, y, z, this.DataToHistogramX);
                        pz = (int)((val - this.Offsets[2]) / this.Scales[2]);
                        if (pz < 0) {
                            pz = 0;
                        }
                        if (pz >= this.Sizes[2]) {
                            pz = this.Sizes[2] - 1;
                        }
                    }
                    int vali = (int)this.GetRawValueAt(px, py, pz) + 1;
                    this.SetValueAt(px, py, pz, vali);
                    if (vali <= max) continue;
                    max = vali;
                }
            }
        }
        System.out.println("max : " + max);
        this.Max = max;
        this.Min = 0.0;
        this.MaxValue = this.Max;
        this.SetScaleShift(0.0, this.Max);
        return max;
    }
}

