/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import ij.ImagePlus;
import ij.gui.NewImage;
import ij.measure.Calibration;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Label;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import view5d.AGenericDialog;
import view5d.ANGenericDialog;
import view5d.APoint;
import view5d.ASlice;
import view5d.AnElement;
import view5d.Bundle;
import view5d.ByteElement;
import view5d.ComplexElement;
import view5d.DoubleElement;
import view5d.FloatElement;
import view5d.IntegerElement;
import view5d.MarkerList;
import view5d.MarkerLists;
import view5d.OneElement;
import view5d.ROI;
import view5d.ShortElement;
import view5d.UnsignedShortElement;
import view5d.View5D_;

public class My3DData {
    int FontSize = 18;
    String FontType = "Arial";
    public String markerInfilename = null;
    public String markerOutfilename = null;
    public Vector<AnElement> MyElements;
    public Vector<ASlice>[] MyProjections;
    public ASlice[] MyColorProjection;
    public ASlice[] MySlice;
    public ASlice[] MyColorSlice;
    public MarkerLists MyMarkers;
    boolean ConnectionShown = true;
    boolean ShowFullTrace = true;
    boolean ShowAllLists = true;
    boolean ShowAllTrees = true;
    boolean ShowAllTrack = false;
    boolean Annotate = false;
    boolean Advance = false;
    boolean ShowSpectralTrack = false;
    boolean MarkerToMax = true;
    boolean UseCOI = true;
    int SearchX = 3;
    int SearchY = 3;
    int SearchZ = 0;
    int COMX = 3;
    int COMY = 3;
    int COMZ = 0;
    String[] TrackDirections = new String[]{"X", "Y", "Z", "Elements", "Time"};
    int TrackDirection = 2;
    String[] TrackModes = new String[]{"Max", "Min"};
    int TrackMode = 0;
    String[] FinishModes = new String[]{"None", "Freeze", "Stop"};
    int FinishMode = 2;
    String[] FinishMeasures = new String[]{"Max", "Integral", "Integral Above Min"};
    int FinishMeasure = 1;
    double ThreshValue = 0.2;
    double TotalMax;
    double TotalMin;
    double TotalInt;
    double TotalIntDiff;
    boolean Repulsion = false;
    boolean FocusDispToMarker = true;
    boolean AppendVersionNumber = false;
    boolean didSwitchAppendVersionNumber = false;
    boolean ActioReactio = false;
    double FWHM = 4.0;
    public int SizeX = 0;
    public int SizeY = 0;
    public int SizeZ = 0;
    public int Elements = 0;
    public int ActiveElement = 0;
    public int DimensionOrder = 0;
    public int AppendTo = 0;
    public Vector<Vector<AnElement>> MyTimes;
    public Vector<Vector<ASlice>[]> MyTimeProj;
    public int Times = 0;
    public int ActiveTime = 0;
    public Vector<ASlice[]> MyTimeColorProj;
    My3DData MyHistogram = null;
    My3DData DataToHistogram = null;
    int[] sizes = new int[]{0, 0, 0, 0, 0};
    int PrevType;
    int PrevBytes;
    int PrevBits;
    int HistoX = 0;
    int HistoY = -1;
    int HistoZ = -1;
    int[] ProjMin;
    int[] ProjMax;
    Vector<Integer>[] PlanesS;
    Vector<Double>[] PlanesD;
    Polygon[] ROIPolygons;
    boolean[] ProjMode;
    boolean projinit = false;
    boolean cprojinit = false;
    boolean elementsLinked = false;
    boolean timesLinked = true;
    int elemR = 0;
    int elemG = 0;
    int elemB = 0;
    int GateElem = 0;
    boolean GateActive = false;
    boolean colormode = false;
    public Container applet;
    Vector<Bundle> MyBundle;
    Vector<Vector<ColorInfo>> TimesColorInfo;

    public void setElementsLinked(boolean v) {
        this.elementsLinked = v;
        if (this.elementsLinked) {
            this.copyLinkedProperties(this.ActiveElement);
        }
    }

    public void setTimesLinked(boolean v) {
        this.timesLinked = v;
    }

    public void setFontSize(int FS) {
        this.FontSize = FS;
    }

    void AddPoint(APoint p) {
        this.MyMarkers.AddPoint(p);
    }

    void AddPoint(double x, double y, double z, double e, double t) {
        this.AddPoint(new APoint(x, y, z, e, t));
    }

    void RemovePoint() {
        this.MyMarkers.RemovePoint();
    }

    void RemoveTrailingPoints() {
        this.MyMarkers.RemoveTrailingPoints();
    }

    boolean AdvancePoint(int howmany) {
        return this.MyMarkers.AdvancePoint(howmany, this.TrackDirection);
    }

    APoint GetPoint(int p, int list) {
        return this.MyMarkers.GetPoint(p, list);
    }

    APoint GetPoint(int p) {
        return this.MyMarkers.GetPoint(p, -1);
    }

    int NumMarkers(int lpos) {
        return this.MyMarkers.NumMarkers(lpos);
    }

    int ActiveMarkerPos() {
        return this.MyMarkers.ActiveMarkerPos();
    }

    int GetActMarkerListNr() {
        return this.MyMarkers.GetActiveList();
    }

    int GetPrefChildListNr(int alist) {
        return this.MyMarkers.GetPrefChildListNr(alist);
    }

    int GetFirstAncestorNr(int alist) {
        return this.MyMarkers.GetFirstAncestorNr(alist);
    }

    boolean CommonRoot(int list1, int list2) {
        return this.MyMarkers.CommonRoot(list1, list2);
    }

    void SetActiveMarker(int p) {
        this.MyMarkers.SetActiveMarker(p);
    }

    void SetActiveMarker(APoint p) {
        this.MyMarkers.SetActiveMarker(p);
    }

    boolean HasParent1(int list) {
        return this.MyMarkers.HasParent1(list);
    }

    boolean HasParent2(int list) {
        return this.MyMarkers.HasParent2(list);
    }

    APoint GetParent1EndOfTrack(int list) {
        return this.MyMarkers.GetParent1EndOfTrack(list, this.TrackDirection);
    }

    APoint GetParent2EndOfTrack(int list) {
        return this.MyMarkers.GetParent2EndOfTrack(list, this.TrackDirection);
    }

    APoint GetActiveMarker() {
        return this.GetPoint(-1);
    }

    boolean CheckActiveMarker(int list, int numMarker, int px, int py, int pz, int element, int time) {
        int[] mycoord = new int[]{px, py, pz, element, time};
        if (list == this.ActiveMarkerListPos() || list == this.MyMarkers.GetParent1Index(this.MyMarkers.ActiveList) || list == this.MyMarkers.GetParent2Index(this.MyMarkers.ActiveList) || this.MyMarkers.MyActiveList.PreferredChild == 1 && list == this.MyMarkers.GetChild1Index(this.MyMarkers.ActiveList) || this.MyMarkers.MyActiveList.PreferredChild == 2 && list == this.MyMarkers.GetChild2Index(this.MyMarkers.ActiveList)) {
            if (this.GetPoint((int)this.MyMarkers.ActiveMarkerPos(), (int)this.MyMarkers.ActiveList).coord[this.TrackDirection] == (double)mycoord[this.TrackDirection]) {
                return list == this.MyMarkers.ActiveList && numMarker == this.MyMarkers.ActiveMarkerPos();
            }
            if (this.GetPoint((int)numMarker, (int)list).coord[this.TrackDirection] == (double)mycoord[this.TrackDirection]) {
                this.MyMarkers.SetActiveList(list);
                this.SetActiveMarker(numMarker);
                return true;
            }
        }
        return false;
    }

    int NumMarkerLists() {
        return this.MyMarkers.NumMarkerLists();
    }

    int ActiveMarkerListPos() {
        return this.MyMarkers.ActiveMarkerListPos();
    }

    String GetMarkerPrintout(My3DData data3d) {
        return this.MyMarkers.PrintList(data3d) + this.MyMarkers.PrintSummary(data3d);
    }

    public void NewMarkerList() {
        this.MyMarkers.NewList();
    }

    public void NewMarkerList(int linkTo, String NameExtension) {
        this.MyMarkers.NewList(linkTo, NameExtension);
    }

    void DevideMarkerList(double px, double py, double pz) {
        int currentList = this.ActiveMarkerListPos();
        APoint sam = this.GetActiveMarker();
        boolean amIsDisplayed = true;
        if (currentList >= 0) {
            MarkerList oldChild1 = this.MyMarkers.GetMarkerList((int)currentList).Child1List;
            MarkerList oldChild2 = this.MyMarkers.GetMarkerList((int)currentList).Child2List;
            this.NewMarkerList(currentList, "a");
            int newListNr = this.ActiveMarkerListPos();
            this.MyMarkers.SetActiveList(currentList);
            this.MyMarkers.SetActiveMarker(sam);
            if (amIsDisplayed) {
                do {
                    APoint am = this.GetActiveMarker();
                    this.MyMarkers.SetActiveList(newListNr);
                    this.AddPoint(am);
                    this.MyMarkers.SetActiveList(currentList);
                    this.MyMarkers.SetActiveMarker(am);
                } while (this.AdvancePoint(1) && this.ActiveMarkerListPos() == currentList);
                this.MyMarkers.SetActiveList(currentList);
                this.MyMarkers.SetActiveMarker(sam);
                this.RemoveTrailingPoints();
                if (oldChild1 != null) {
                    if (oldChild1.Parent1List == oldChild1) {
                        oldChild1.Parent1List = this.MyMarkers.GetMarkerList(newListNr);
                    }
                    if (oldChild1.Parent2List == oldChild1) {
                        oldChild1.Parent2List = this.MyMarkers.GetMarkerList(newListNr);
                    }
                    this.MyMarkers.GetMarkerList((int)newListNr).Child1List = oldChild1;
                }
                if (oldChild2 != null) {
                    if (oldChild2.Parent1List == oldChild2) {
                        oldChild2.Parent1List = this.MyMarkers.GetMarkerList(newListNr);
                    }
                    if (oldChild2.Parent2List == oldChild2) {
                        oldChild2.Parent2List = this.MyMarkers.GetMarkerList(newListNr);
                    }
                    this.MyMarkers.GetMarkerList((int)newListNr).Child2List = oldChild2;
                }
                this.MyMarkers.SetActiveList(currentList);
            } else {
                this.SetMarker(px, py, pz, this.MyMarkers.GetMarkerList(currentList).GetColor());
            }
            this.NewMarkerList(currentList, "b");
            this.SetMarker(px, py, pz, this.MyMarkers.GetMarkerList(currentList).GetColor());
        }
    }

    void RemoveMarkerList() {
        this.MyMarkers.RemoveList();
    }

    void AdvanceMarkerList(int howmany) {
        this.MyMarkers.AdvanceList(howmany, this.TrackDirection);
    }

    void ToggleMarkerListColor(int howmany) {
        this.MyMarkers.ToggleColor();
    }

    String GetMarkerListName(int listnr) {
        return this.MyMarkers.GetMarkerList(listnr).GetMarkerListName();
    }

    APoint MarkerFromPosition(double px, double py, int dir, double dx, double dy) {
        APoint Pt = this.MyMarkers.MarkerFromPosition(px, py, dir, dx, dy, this);
        return Pt;
    }

    public int AddLookUpTable(int MapSize, byte[] Reds, byte[] Greens, byte[] Blues) {
        int lastLUT = 0;
        lastLUT = 13 + Bundle.AddLookUpTable(MapSize, Reds, Greens, Blues);
        this.SetColorModelNr(this.ActiveElement, lastLUT);
        this.GetBundleAt(this.ActiveElement).CompCMap();
        return lastLUT;
    }

    void cleanup() {
        if (this.MyElements == null) {
            return;
        }
        for (int e = 0; e < this.Elements; ++e) {
            for (int t = 0; t < this.Times; ++t) {
                this.ElementAt((int)e, (int)t).DataToHistogramX = null;
                this.ElementAt((int)e, (int)t).DataToHistogramY = null;
                this.ElementAt((int)e, (int)t).DataToHistogramZ = null;
                this.ElementAt(e, t).DeleteData();
            }
            this.GetBundleAt((int)e).cmapRed = null;
            this.GetBundleAt((int)e).cmapGreen = null;
            this.GetBundleAt((int)e).cmapBlue = null;
            this.ProjAt((int)0, (int)e).my1DProjVoxels = null;
            this.ProjAt((int)0, (int)e).mySlice = null;
            this.ProjAt((int)1, (int)e).my1DProjVoxels = null;
            this.ProjAt((int)1, (int)e).mySlice = null;
            this.ProjAt((int)2, (int)e).my1DProjVoxels = null;
            this.ProjAt((int)2, (int)e).mySlice = null;
        }
        this.MyElements = null;
        this.MyTimes = null;
        this.MyProjections = null;
        this.MyColorProjection = null;
        this.MySlice = null;
        this.MyColorSlice = null;
        this.Elements = -1;
        this.Times = -1;
        System.gc();
    }

    void SetMarker(double x, double y, double z, double e, double t) {
        APoint p = new APoint(x, y, z, e, t);
        if (this.MarkerToMax) {
            p = this.IterativeClosestMax(p, this.SearchX, this.SearchY, this.SearchZ);
        }
        this.ClippedCOI(p, this.COMX, this.COMY, this.COMZ, this.UseCOI);
        this.AddPoint(p);
    }

    void SetMarker(double x, double y, double z) {
        this.SetMarker(x, y, z, this.ActiveElement, this.ActiveTime);
    }

    void SetMarker(double x, double y, double z, int mycolor) {
        this.SetMarker(x, y, z);
        this.GetActiveMarker().mycolor = mycolor;
    }

    void TagMarker() {
        this.GetActiveMarker().Tag(-1);
    }

    void ResetOffsets() {
        for (int pt = 0; pt < this.Times; ++pt) {
            for (int pe = 0; pe < this.Elements; ++pe) {
                this.ElementAt((int)pe, (int)pt).DisplayOffset[0] = 0.0;
                this.ElementAt((int)pe, (int)pt).DisplayOffset[1] = 0.0;
                this.ElementAt((int)pe, (int)pt).DisplayOffset[2] = 0.0;
            }
        }
    }

    void AlignOffsetsToTrack() {
        if (this.TrackDirection < 3) {
            System.out.println("WARNING: Attempted to align Data to a marker trace even though the current tracking direction is not elements or time! Aborted.\n");
            return;
        }
        APoint APt = this.GetPoint(-1);
        if (APt == null) {
            return;
        }
        int PNr = this.ActiveMarkerPos();
        double x0 = APt.coord[0];
        double y0 = APt.coord[1];
        double z0 = APt.coord[2];
        int alist = this.GetActMarkerListNr();
        APoint Pt = this.GetPoint(PNr);
        double preve = Pt.coord[3];
        double prevt = Pt.coord[4];
        double PrevOffsetX = this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[0];
        double PrevOffsetY = this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[1];
        double PrevOffsetZ = this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[2];
        alist = this.GetFirstAncestorNr(alist);
        do {
            int NumM = this.NumMarkers(alist);
            for (PNr = 0; PNr < NumM; ++PNr) {
                double emax;
                double emin;
                Pt = this.GetPoint(PNr, alist);
                double pe = Pt.coord[3];
                double pt = Pt.coord[4];
                if (this.TrackDirection != 4) {
                    emin = pe;
                    emax = pe;
                } else {
                    emin = 0.0;
                    emax = this.Elements - 1;
                }
                for (pe = emin; pe <= emax; pe += 1.0) {
                    this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[0] = (int)(PrevOffsetX - Pt.coord[0] + x0);
                    this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[1] = (int)(PrevOffsetY - Pt.coord[1] + y0);
                    this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[2] = (int)(PrevOffsetZ - Pt.coord[2] + z0);
                }
            }
        } while ((alist = this.GetPrefChildListNr(alist)) >= 0);
    }

    int TestValidPoint(APoint Pt) {
        int TrackState = 0;
        this.TotalMax = Math.max(this.TotalMax, Pt.max);
        this.TotalMin = Math.min(this.TotalMin, Pt.min);
        this.TotalInt = Math.max(this.TotalInt, Pt.integral);
        this.TotalIntDiff = Math.max(this.TotalIntDiff, Pt.integralAboveMin);
        double myMeasure = 0.0;
        switch (this.FinishMeasure) {
            case 0: {
                myMeasure = Pt.max / this.TotalMax;
                break;
            }
            case 1: {
                myMeasure = Pt.integral / this.TotalInt;
                break;
            }
            case 2: {
                myMeasure = Pt.integralAboveMin / this.TotalIntDiff;
            }
        }
        if (myMeasure < this.ThreshValue) {
            switch (this.FinishMode) {
                case 0: {
                    TrackState = 0;
                    break;
                }
                case 1: {
                    TrackState = 1;
                    break;
                }
                case 2: {
                    TrackState = 2;
                }
            }
        }
        return TrackState;
    }

    void AutoTrack() {
        APoint Pt = this.GetPoint(-1);
        if (Pt == null) {
            return;
        }
        int PNr = this.ActiveMarkerPos();
        double preve = Pt.coord[3];
        double prevt = Pt.coord[4];
        this.TotalMax = Pt.max;
        this.TotalMin = Pt.min;
        this.TotalInt = Pt.integral;
        this.TotalIntDiff = Pt.integralAboveMin;
        for (int myP = 1; myP <= PNr; ++myP) {
            this.TestValidPoint(this.GetPoint(PNr));
        }
        int TrackState = 0;
        double px = Pt.coord[0];
        double py = Pt.coord[1];
        double pz = Pt.coord[2];
        double pe = Pt.coord[3];
        double pt = Pt.coord[4];
        while (this.NumMarkers(-1) > 0 && this.ActiveMarkerPos() >= 0 && this.ActiveMarkerPos() < this.NumMarkers(-1) - 1 && TrackState < 2) {
            this.AdvancePoint(1);
            Pt = this.GetPoint(-1);
            px = Pt.coord[0];
            py = Pt.coord[1];
            pz = Pt.coord[2];
            pe = Pt.coord[3];
            pt = Pt.coord[4];
            px = px - this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[0] + this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[0];
            py = py - this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[1] + this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[1];
            pz = pz - this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[2] + this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[2];
            this.UpdateMarker(Pt);
            Pt = this.GetPoint(-1);
            px = Pt.coord[0];
            py = Pt.coord[1];
            pz = Pt.coord[2];
            pe = Pt.coord[3];
            pt = Pt.coord[4];
            TrackState = this.TestValidPoint(Pt);
            if (TrackState > 0) {
                System.out.println("Marker frozen@ " + PNr + "\n");
                this.RemovePoint();
                Pt = this.GetPoint(-1);
                px = Pt.coord[0];
                py = Pt.coord[1];
                pz = Pt.coord[2];
                pe = Pt.coord[3];
                pt = Pt.coord[4];
            }
            if (TrackState >= 2) {
                System.out.println("Track ended@ " + PNr + "\n");
                this.RemoveTrailingPoints();
                return;
            }
            preve = pe;
            prevt = pt;
            PNr = this.ActiveMarkerPos();
            System.out.println("Active Marker: " + PNr + ", " + this.NumMarkers(-1) + "\n");
            System.out.println("pxyz: " + px + ", " + py + ", " + pz + "\n");
        }
        int TrackSize = 0;
        boolean ix = false;
        boolean iy = false;
        boolean iz = false;
        boolean ie = false;
        boolean it = false;
        int tpos = 0;
        switch (this.TrackDirection) {
            case 0: {
                TrackSize = this.SizeX;
                ix = true;
                tpos = (int)px + 1;
                break;
            }
            case 1: {
                TrackSize = this.SizeY;
                iy = true;
                tpos = (int)py + 1;
                break;
            }
            case 2: {
                TrackSize = this.SizeZ;
                iz = true;
                tpos = (int)pz + 1;
                break;
            }
            case 3: {
                TrackSize = this.Elements;
                ie = true;
                tpos = (int)pe + 1;
                break;
            }
            case 4: {
                TrackSize = this.Times;
                it = true;
                tpos = (int)pt + 1;
            }
        }
        preve = pe;
        prevt = pt;
        px += (double)ix;
        py += (double)iy;
        pz += (double)iz;
        pe += (double)ie;
        pt += (double)it;
        while (tpos < TrackSize & TrackState < 2) {
            System.out.println("Extend Active MarkerPos: " + this.ActiveMarkerPos() + "\n");
            px = px - this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[0] + this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[0];
            py = py - this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[1] + this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[1];
            pz = pz - this.ElementAt((int)((int)pe), (int)((int)pt)).DisplayOffset[2] + this.ElementAt((int)((int)preve), (int)((int)prevt)).DisplayOffset[2];
            this.SetMarker(px, py, pz, pe, pt);
            Pt = this.GetPoint(-1);
            px = Pt.coord[0];
            py = Pt.coord[1];
            pz = Pt.coord[2];
            pe = Pt.coord[3];
            TrackState = this.TestValidPoint(Pt);
            if (TrackState > 0) {
                System.out.println("Marker frozen@ " + px + ", " + py + ", " + pz + "\n");
                if (TrackState > 1) {
                    System.out.println("Track ended@ " + px + ", " + py + ", " + pz + "\n");
                }
                this.RemovePoint();
            }
            preve = pe;
            prevt = pt;
            px += (double)ix;
            py += (double)iy;
            pz += (double)iz;
            pe += (double)ie;
            pt += (double)it;
            ++tpos;
        }
    }

    void SubtractTrackedSpot() {
        int NumM = this.NumMarkers(-1);
        for (int PNr = this.ActiveMarkerPos(); PNr < NumM; ++PNr) {
            this.SetActiveMarker(PNr);
            APoint Pt = this.GetPoint(PNr);
            this.ElementAt((int)Pt.coord[3], (int)Pt.coord[4]).SubtractGauss(Pt.coord[0], Pt.coord[1], Pt.coord[2], Pt.integral, this.COMX, this.COMY, this.COMZ, this.FWHM);
        }
    }

    void UpdateMarker(APoint Pt) {
        if (this.MarkerToMax) {
            APoint p = (APoint)Pt.clone();
            APoint q = this.IterativeClosestMax(p, this.SearchX, this.SearchY, this.SearchZ);
            Pt.copy(q);
        }
        this.ClippedCOI(Pt, this.COMX, this.COMY, this.COMZ, this.UseCOI);
    }

    void ToggleMarkerToMax(int val) {
        this.MarkerToMax = val < 0 ? !this.MarkerToMax : val != 0;
    }

    void Penalize(APoint aPt) {
        if (this.Repulsion) {
            this.MyMarkers.Penalize(aPt, this.FWHM, this.TrackDirection);
        }
    }

    double Penalty(APoint aPt) {
        if (this.Repulsion) {
            return this.MyMarkers.Penalty(aPt, this.FWHM, this.TrackDirection, AnElement.ComputeIntMaxScale(this.COMX, this.COMY, this.COMZ, this.FWHM));
        }
        return 0.0;
    }

    double Restrict(double val, int limit) {
        if (val >= (double)limit) {
            return limit - 1;
        }
        if (val < 0.0) {
            return 0.0;
        }
        return val;
    }

    APoint LimitPoint(APoint p) {
        APoint np = (APoint)p.clone();
        for (int i = 0; i < 5; ++i) {
            np.coord[i] = this.Restrict(p.coord[i], this.sizes[i]);
        }
        return np;
    }

    APoint ClosestMax(APoint pt, int dx, int dy, int dz) {
        int x = (int)(pt.coord[0] + 0.5);
        int y = (int)(pt.coord[1] + 0.5);
        int z = (int)(pt.coord[2] + 0.5);
        int e = (int)(pt.coord[3] + 0.5);
        int t = (int)(pt.coord[4] + 0.5);
        boolean didnegate = false;
        if (this.TrackMode == 1) {
            didnegate = true;
            this.ElementAt((int)e, (int)t).ScaleV = -this.ElementAt((int)e, (int)t).ScaleV;
        }
        double maxv = this.ElementAt(e, t).GetValueWithBounds(x, y, z);
        double px = x;
        double py = y;
        double pz = z;
        APoint p = (APoint)pt.clone();
        maxv -= this.Penalty(p);
        for (int zz = z - dz; zz <= z + dz; ++zz) {
            p.coord[2] = zz;
            for (int yy = y - dy; yy <= y + dy; ++yy) {
                p.coord[1] = yy;
                for (int xx = x - dx; xx <= x + dx; ++xx) {
                    p.coord[0] = xx;
                    double val = this.ElementAt(e, t).GetValueWithBounds(xx, yy, zz);
                    if (!(val > maxv) || !((val -= this.Penalty(p)) > maxv)) continue;
                    maxv = val;
                    px = xx;
                    py = yy;
                    pz = zz;
                }
            }
        }
        p.coord[0] = px;
        p.coord[1] = py;
        p.coord[2] = pz;
        p.max = maxv;
        if (didnegate) {
            this.ElementAt((int)e, (int)t).ScaleV = -this.ElementAt((int)e, (int)t).ScaleV;
        }
        return p;
    }

    APoint IterativeClosestMax(APoint p, int dx, int dy, int dz) {
        APoint p1 = (APoint)p.clone();
        APoint p2 = this.ClosestMax(p, dx, dy, dz);
        int iter = 0;
        while (p1.SqrDistTo(p2) > 0.1) {
            p1 = p2;
            p2 = this.ClosestMax(p1, dx, dy, dz);
            ++iter;
        }
        p2.mycolor = p.mycolor;
        return p2;
    }

    void ConstrainPoint(APoint p) {
        if (p.coord[0] > (double)(this.SizeX - 1)) {
            p.coord[0] = (double)this.SizeX - 1.0;
        }
        if (p.coord[0] < 0.0) {
            p.coord[0] = 0.0;
        }
        if (p.coord[1] > (double)(this.SizeY - 1)) {
            p.coord[1] = (double)this.SizeY - 1.0;
        }
        if (p.coord[1] < 0.0) {
            p.coord[1] = 0.0;
        }
        if (p.coord[2] > (double)(this.SizeZ - 1)) {
            p.coord[2] = (double)this.SizeZ - 1.0;
        }
        if (p.coord[2] < 0.0) {
            p.coord[2] = 0.0;
        }
        if (p.coord[3] > (double)(this.Elements - 1)) {
            p.coord[3] = (double)this.Elements - 1.0;
        }
        if (p.coord[3] < 0.0) {
            p.coord[3] = 0.0;
        }
        if (p.coord[4] > (double)(this.Times - 1)) {
            p.coord[4] = (double)this.Times - 1.0;
        }
        if (p.coord[4] < 0.0) {
            p.coord[4] = 0.0;
        }
    }

    void ClippedCOI(APoint p, int dx, int dy, int dz, boolean doCOI) {
        int x = (int)(p.coord[0] + 0.5);
        int y = (int)(p.coord[1] + 0.5);
        int z = (int)(p.coord[2] + 0.5);
        int e = (int)(p.coord[3] + 0.5);
        int t = (int)(p.coord[4] + 0.5);
        boolean didnegate = false;
        if (this.TrackMode == 1) {
            didnegate = true;
            this.ElementAt((int)e, (int)t).ScaleV = -this.ElementAt((int)e, (int)t).ScaleV;
        }
        double maxv = this.ElementAt(e, t).GetValueWithBounds(x, y, z);
        double sum = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        double minv = maxv;
        double nump = 0.0;
        AnElement GateElement = this.GetGateElem(t);
        for (int zz = z - dz; zz <= z + dz; ++zz) {
            for (int yy = y - dy; yy <= y + dy; ++yy) {
                for (int xx = x - dx; xx <= x + dx; ++xx) {
                    if (GateElement.GetIntValueWithBounds(xx, yy, zz) <= 0 || !this.ElementAt(e, t).InsideBounds(xx, yy, zz)) continue;
                    double val = this.ElementAt(e, t).GetValueAt(xx, yy, zz);
                    sx += val * (double)xx;
                    sy += val * (double)yy;
                    sz += val * (double)zz;
                    sum += val;
                    if (val < minv) {
                        minv = val;
                    }
                    if (val > maxv) {
                        maxv = val;
                    }
                    nump += 1.0;
                }
            }
        }
        if (minv >= maxv) {
            minv = 0.0;
        }
        p.integral = sum;
        p.max = maxv;
        p.min = minv;
        p.integralAboveMin = sum -= nump * minv;
        if (sum == 0.0) {
            sum = 1.0;
        }
        if (nump == 0.0) {
            return;
        }
        double px = (sx - minv * nump * (double)x) / sum;
        double py = (sy - minv * nump * (double)y) / sum;
        double pz = (sz - minv * nump * (double)z) / sum;
        if (px < 0.0) {
            px = 0.0;
        }
        if (py < 0.0) {
            py = 0.0;
        }
        if (pz < 0.0) {
            pz = 0.0;
        }
        if (doCOI && maxv > minv) {
            p.coord[0] = px;
            p.coord[1] = py;
            p.coord[2] = pz;
            p.coord[3] = e;
            p.coord[4] = t;
        }
        if (didnegate) {
            this.ElementAt((int)e, (int)t).ScaleV = -this.ElementAt((int)e, (int)t).ScaleV;
        }
    }

    boolean MarkerDisplayed(APoint Pt, int[] ActPosition) {
        return this.ShowAllTrack || Pt.coord[this.TrackDirection] == (double)((int)((double)ActPosition[this.TrackDirection] + 0.5));
    }

    void MarkerListDialog() {
        this.MyMarkers.MarkerListDialog(-1);
    }

    void setMarkerInitTrackDir(int TD, int SX, int SY, int SZ, boolean UC, int CX, int CY, int CZ) {
        this.TrackDirection = TD;
        this.SearchX = SX;
        this.SearchY = SY;
        this.SearchZ = SZ;
        this.UseCOI = UC;
        this.COMX = CX;
        this.COMY = CY;
        this.COMZ = CZ;
    }

    void MarkerDialog() {
        ANGenericDialog md = new ANGenericDialog("Marker positioning");
        md.addCheckbox("Display connecting lines", this.ConnectionShown);
        md.addCheckbox("Show all lines", this.ShowFullTrace);
        md.addCheckbox("Show all lists", this.ShowAllLists);
        md.addCheckbox("Show all trees", this.ShowAllTrees);
        md.addCheckbox("Show markers along track", this.ShowAllTrack);
        md.addCheckbox("Annotate with List Nr.", this.Annotate);
        md.addCheckbox("Advance each marker", this.Advance);
        md.addChoice("Tracking Mode: ", this.TrackModes, this.TrackModes[this.TrackMode]);
        md.addChoice("Tracking direction: ", this.TrackDirections, this.TrackDirections[this.TrackDirection]);
        md.addChoice("Finnish Mode: ", this.FinishModes, this.FinishModes[this.FinishMode]);
        md.addChoice("Finnish Metric: ", this.FinishMeasures, this.FinishMeasures[this.FinishMeasure]);
        md.addNumericFields("Threshold", this.ThreshValue, 3, 3);
        md.addCheckbox("Spectral Display for Track", this.ShowSpectralTrack);
        md.addMessage("For automatic marker positioning an iterative search for the nearest\r\nmaximum signal is performed. The region to be searched is defined by the\r\nnumber of voxels to include in each direction, beyond the current plane.\r\nTo restrict the update to any plane or line choose zero in the\r\nappropriate fields below.");
        md.addCheckbox("Use automatic maximum finding", this.MarkerToMax);
        md.addNumericFields("X Neighbours: ", this.SearchX, 3, 3);
        md.addNumericFields("Y:", this.SearchY, 3, 3);
        md.addNumericFields("Z:", this.SearchZ, 3, 3);
        md.addCheckbox("Subpixel positions by Center of Mass", this.UseCOI);
        md.addNumericFields("X Center of Intensity: ", this.COMX, 3, 3);
        md.addNumericFields("Y:", this.COMY, 3, 3);
        md.addNumericFields("Z:", this.COMZ, 3, 3);
        md.addNumericField("FWHM of Gaussian for subtaction: ", this.FWHM, 3);
        md.addCheckbox("Repulsion", this.Repulsion);
        md.addCheckbox("Focus Display to Marker", this.FocusDispToMarker);
        md.addInFile("MarkerFileIn: ", this.markerInfilename);
        md.addOutFile("MarkerFileOut: ", this.markerOutfilename);
        md.addCheckbox("Append Version Number", this.AppendVersionNumber);
        boolean newAppendV = this.AppendVersionNumber;
        md.showDialog();
        if (!md.wasCanceled()) {
            this.ConnectionShown = md.getNextBoolean();
            this.ShowFullTrace = md.getNextBoolean();
            this.ShowAllLists = md.getNextBoolean();
            this.ShowAllTrees = md.getNextBoolean();
            this.ShowAllTrack = md.getNextBoolean();
            this.Annotate = md.getNextBoolean();
            this.Advance = md.getNextBoolean();
            this.TrackMode = md.getNextChoiceIndex();
            this.TrackDirection = md.getNextChoiceIndex();
            this.FinishMode = md.getNextChoiceIndex();
            this.FinishMeasure = md.getNextChoiceIndex();
            this.ThreshValue = md.getNextNumber();
            this.ShowSpectralTrack = md.getNextBoolean();
            this.MarkerToMax = md.getNextBoolean();
            this.SearchX = (int)md.getNextNumber();
            this.SearchY = (int)md.getNextNumber();
            this.SearchZ = (int)md.getNextNumber();
            this.UseCOI = md.getNextBoolean();
            this.COMX = (int)md.getNextNumber();
            this.COMY = (int)md.getNextNumber();
            this.COMZ = (int)md.getNextNumber();
            this.FWHM = md.getNextNumber();
            this.Repulsion = md.getNextBoolean();
            this.FocusDispToMarker = md.getNextBoolean();
            this.markerInfilename = md.getInFile();
            this.markerOutfilename = md.getOutFile();
            newAppendV = md.getNextBoolean();
            if (this.AppendVersionNumber != newAppendV && newAppendV && !this.didSwitchAppendVersionNumber) {
                this.didSwitchAppendVersionNumber = true;
                ANGenericDialog ms = new ANGenericDialog("Marker positioning");
                String newName = System.getProperty("os.name").startsWith("Windows") ? "C:\\temp\\markers001.txt" : "/tmp/markers001.txt";
                ms.addMessage("Change marker filename to " + newName + "?\n");
                ms.showDialog();
                if (!md.wasCanceled()) {
                    this.markerOutfilename = newName;
                }
            }
            this.AppendVersionNumber = newAppendV;
        }
        switch (this.TrackDirection) {
            case 0: {
                this.SearchX = 0;
                this.COMX = 0;
                break;
            }
            case 1: {
                this.SearchY = 0;
                this.COMY = 0;
                break;
            }
            case 2: {
                this.SearchZ = 0;
                this.COMZ = 0;
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public void toggleGate(int toggle) {
        if (toggle < 0) {
            this.GateActive = !this.GateActive;
        } else {
            boolean bl = this.GateActive = toggle == 1;
        }
        if (this.GateActive) {
            this.CThreshToValThresh(this.GateElem, 0.0, 1.0);
        }
        this.InvalidateSlices();
        this.InvalidateProjs(-1);
    }

    public void setGate() {
        this.GateElem = this.ActiveElement;
        if (this.GateActive) {
            this.InvalidateSlices();
            this.InvalidateProjs(-1);
            this.CThreshToValThresh(-1, 0.0, 1.0);
        }
    }

    public void setModelThresh() {
        this.setModelThresh(this.ActiveElement);
    }

    public void setModelThresh(int e) {
        this.GetBundleAt(e).CompCMap();
    }

    public int GetActiveColorModelNr() {
        return this.GetBundleAt((int)this.ActiveElement).ElementModelNr;
    }

    public int GetColorModelNr(int e) {
        return this.GetBundleAt((int)e).ElementModelNr;
    }

    public void SetColorModelNr(int e, int actModel) {
        this.GetBundleAt((int)e).ElementModelNr = actModel;
    }

    public Bundle GetBundleAt(int e) {
        return this.MyBundle.elementAt(e);
    }

    public void ToggleLog(int newVal) {
        this.ToggleLog(this.ActiveElement, newVal);
    }

    public void ToggleConnection(int newVal) {
        this.ConnectionShown = newVal < 0 ? !this.ConnectionShown : newVal != 0;
    }

    public void ToggleLog(int e, int newVal) {
        this.GetBundleAt(e).ToggleLog(newVal);
        if (this.elementsLinked) {
            this.copyLinkedProperties(e);
        }
    }

    public void SetGamma(int e, double gamma) {
        this.GetBundleAt(e).SetGamma(gamma);
    }

    public double GetGamma(int e) {
        return this.GetBundleAt(e).GetGamma();
    }

    public void ToggleOvUn(int newVal) {
        boolean resOvUn = this.GetBundleAt(this.ActiveElement).ToggleOvUn(newVal);
        newVal = resOvUn ? 1 : 0;
        if (this.elementsLinked) {
            this.copyLinkedProperties(this.ActiveElement);
        }
    }

    public void ToggleModel(int elem, int newModel) {
        this.GetBundleAt(elem).ToggleModel(newModel);
        if (elem == this.ActiveElement) {
            IndexColorModel mymodel = this.GetBundleAt((int)elem).ElementModel;
            this.MySlice[0].TakeModel(mymodel);
            this.MySlice[1].TakeModel(mymodel);
            this.MySlice[2].TakeModel(mymodel);
        }
        if (this.GetBundleAt((int)elem).DispOverlay) {
            this.InvalidateColor();
        }
        if (this.elementsLinked) {
            this.copyLinkedProperties(elem);
        }
    }

    public void ToggleModel(int newModel) {
        this.ToggleModel(this.ActiveElement, newModel);
    }

    public void InvertCMap() {
        this.GetBundleAt((int)this.ActiveElement).cmapIsInverse = !this.GetBundleAt((int)this.ActiveElement).cmapIsInverse;
    }

    private double Getmincs(int elem) {
        return this.GetBundleAt(elem).GetMincs();
    }

    private double Getmaxcs(int elem) {
        return this.GetBundleAt(elem).GetMaxcs();
    }

    public double GetScaledMincs(int elem) {
        return this.GetMinThresh(elem) * this.ElementAt((int)elem).ScaleV + this.ElementAt((int)elem).OffsetV;
    }

    public double GetScaledMaxcs(int elem) {
        return this.GetMaxThresh(elem) * this.ElementAt((int)elem).ScaleV + this.ElementAt((int)elem).OffsetV;
    }

    public double GetScaledRange(int elem) {
        if (elem < 0) {
            return 0.0;
        }
        return this.ElementAt((int)elem).ScaleV * (this.GetMaxThresh(elem) - this.GetMinThresh(elem));
    }

    public void transferThresh(int elem) {
        for (int t = 0; t < this.Times; ++t) {
            this.ElementAt(elem, t).SetScaleShift(this.Getmincs(elem), this.Getmaxcs(elem));
        }
    }

    public boolean SetThresh(double min, double max) {
        return this.SetThresh(this.ActiveElement, min, max);
    }

    public boolean SetThresh(int e, double min, double max) {
        if (this.GetBundleAt(e).GetMincs() != min || this.GetBundleAt(e).GetMaxcs() != max) {
            this.GetBundleAt((int)e).cmapcHigh = Short.MAX_VALUE;
            this.GetBundleAt((int)e).cmapcLow = 0;
            this.GetBundleAt(e).CompCMap();
            this.GetBundleAt(e).SetMincs(min);
            this.GetBundleAt(e).SetMaxcs(max);
            return false;
        }
        return true;
    }

    public boolean SetScaledMinMaxcs(int elem, double Min, double Max) {
        return this.SetThresh(elem, (Min - this.ElementAt((int)elem).OffsetV) / this.ElementAt((int)elem).ScaleV, (Max - this.ElementAt((int)elem).OffsetV) / this.ElementAt((int)elem).ScaleV);
    }

    public boolean AdjustThresh(int elementNum) {
        boolean valid = true;
        this.GetBundleAt((int)elementNum).cmapcHigh = Short.MAX_VALUE;
        this.GetBundleAt((int)elementNum).cmapcLow = 0;
        this.GetBundleAt(elementNum).CompCMap();
        double min = this.ElementAt(elementNum).ROIMinimum(this.ROIAt(elementNum));
        double max = this.ElementAt(elementNum).ROIMaximum(this.ROIAt(elementNum));
        valid = this.SetThresh(elementNum, min, max);
        this.transferThresh(elementNum);
        return valid;
    }

    public void AdjustThresh(boolean allelements) {
        if (!allelements) {
            if (!this.AdjustThresh(this.ActiveElement)) {
                this.InvalidateSlices();
            }
        } else {
            boolean valid = true;
            for (int e = 0; e < this.Elements; ++e) {
                if (this.AdjustThresh(e)) continue;
                valid = false;
            }
            if (!valid) {
                this.InvalidateSlices();
            }
        }
    }

    public void AdjustThresh() {
        if (this.elementsLinked) {
            this.AdjustThreshGlobal();
        } else {
            this.AdjustThresh(true);
        }
    }

    public double GlobalMin() {
        double min = this.ElementAt(0).ROIMinimum(this.ROIAt(0));
        for (int elementNum = 1; elementNum < this.Elements; ++elementNum) {
            double amin = this.ElementAt(elementNum).ROIMinimum(this.ROIAt(elementNum));
            if (!(amin < min)) continue;
            min = amin;
        }
        return min;
    }

    public double GlobalMax() {
        double max = this.ElementAt(0).ROIMaximum(this.ROIAt(0));
        for (int elementNum = 1; elementNum < this.Elements; ++elementNum) {
            double amax = this.ElementAt(elementNum).ROIMaximum(this.ROIAt(elementNum));
            if (!(amax > max)) continue;
            max = amax;
        }
        return max;
    }

    public boolean AdjustThreshGlobal() {
        double min = this.GlobalMin();
        double max = this.GlobalMax();
        boolean valid = true;
        for (int elementNum = 0; elementNum < this.Elements; ++elementNum) {
            this.GetBundleAt((int)elementNum).cmapcHigh = Short.MAX_VALUE;
            this.GetBundleAt((int)elementNum).cmapcLow = 0;
            this.GetBundleAt(elementNum).CompCMap();
            if (!this.SetThresh(elementNum, min, max)) {
                valid = false;
            }
            this.transferThresh(elementNum);
        }
        return valid;
    }

    public void copyLinkedProperties(int anElement) {
        double TLow = this.GetBundleAt(anElement).GetMincs();
        double THigh = this.GetBundleAt(anElement).GetMaxcs();
        boolean ShowOvUn = this.GetBundleAt((int)anElement).ShowOvUn;
        boolean LogScale = this.GetBundleAt((int)anElement).LogScale;
        boolean cmapIsInverse = this.GetBundleAt((int)anElement).cmapIsInverse;
        int ElementModelNr = this.GetBundleAt((int)anElement).ElementModelNr;
        double Gamma = this.GetBundleAt((int)anElement).Gamma;
        for (int elementNum = 0; elementNum < this.Elements; ++elementNum) {
            this.GetBundleAt(elementNum).SetMincs(TLow);
            this.GetBundleAt(elementNum).SetMaxcs(THigh);
            this.GetBundleAt((int)elementNum).ShowOvUn = ShowOvUn;
            this.GetBundleAt((int)elementNum).LogScale = LogScale;
            this.GetBundleAt((int)elementNum).cmapIsInverse = cmapIsInverse;
            this.GetBundleAt((int)elementNum).ElementModelNr = ElementModelNr;
            this.GetBundleAt((int)elementNum).Gamma = Gamma;
            if (this.GetBundleAt((int)elementNum).cmapcLow > 0) {
                this.GetBundleAt(elementNum).CompCMap();
                continue;
            }
            this.CThreshToValThresh(elementNum, 0.25, 1.0);
        }
    }

    public void setColorMapThresh(int elem, int low, int high) {
        this.GetBundleAt((int)elem).cmapcLow = low;
        this.GetBundleAt((int)elem).cmapcHigh = high;
        this.GetBundleAt(elem).CompCMap();
    }

    public void adjustColorMapLThresh(double howmuch) {
        double howmany = howmuch * 32768.0;
        double max = this.GetBundleAt((int)this.ActiveElement).cmapcHigh;
        double min = this.GetBundleAt((int)this.ActiveElement).cmapcLow;
        if (howmany < 0.0 || max > min + howmany) {
            this.GetBundleAt((int)this.ActiveElement).cmapcLow += (int)howmany;
        }
        if (this.GetBundleAt((int)this.ActiveElement).cmapcLow > 0) {
            this.GetBundleAt(this.ActiveElement).CompCMap();
        } else {
            this.CThreshToValThresh(this.ActiveElement, 0.25, 1.0);
        }
    }

    public void adjustColorMapUThresh(double howmuch) {
        double howmany = howmuch * 32768.0;
        double max = this.GetBundleAt((int)this.ActiveElement).cmapcHigh;
        double min = this.GetBundleAt((int)this.ActiveElement).cmapcLow;
        if (howmany > 0.0 || max + howmany > min) {
            this.GetBundleAt((int)this.ActiveElement).cmapcHigh += (int)howmany;
        }
        if (this.GetBundleAt((int)this.ActiveElement).cmapcHigh <= Short.MAX_VALUE) {
            this.GetBundleAt(this.ActiveElement).CompCMap();
        } else {
            this.CThreshToValThresh(this.ActiveElement, 0.0, 0.75);
        }
    }

    public double GetMinThresh(int elem) {
        double max = this.GetBundleAt(elem).GetMaxcs();
        double min = this.GetBundleAt(elem).GetMincs();
        double cmin = this.GetBundleAt((int)elem).cmapcLow;
        double nmin = min + (max - min) * cmin / 32767.0;
        return nmin;
    }

    public double GetMaxThresh(int elem) {
        double max = this.GetBundleAt(elem).GetMaxcs();
        double min = this.GetBundleAt(elem).GetMincs();
        double cmax = this.GetBundleAt((int)elem).cmapcHigh;
        double nmax = min + (max - min) * cmax / 32767.0;
        return nmax;
    }

    public void CThreshToValThresh(int elem, double facmin, double facmax) {
        if (elem < 0) {
            elem = this.ActiveElement;
        }
        double max = this.GetBundleAt(elem).GetMaxcs();
        double min = this.GetBundleAt(elem).GetMincs();
        double cmax = this.GetBundleAt((int)elem).cmapcHigh;
        double cmin = this.GetBundleAt((int)elem).cmapcLow;
        double cmaxnew = (int)(32767.0 * facmax);
        double cminnew = (int)(32767.0 * facmin);
        double scale = (max - min) / 32768.0;
        double scale2 = (cmax - cmin) / (cmaxnew - cminnew);
        double nmax = max - scale * (32768.0 - (cmax + scale2 * (32767.0 - cmaxnew)));
        double nmin = min + scale * (cmin - scale2 * cminnew);
        this.GetBundleAt(elem).SetMincs(nmin);
        this.GetBundleAt(elem).SetMaxcs(nmax);
        this.GetBundleAt((int)elem).cmapcLow = (int)cminnew;
        this.GetBundleAt((int)elem).cmapcHigh = (int)cmaxnew;
        this.InvalidateSlices();
        this.InvalidateProjs(elem);
        this.transferThresh(elem);
        this.GetBundleAt(elem).CompCMap();
    }

    public void addLThresh(double howmuch) {
        double howmany = howmuch * this.ActElement().MaxValue;
        double max = this.GetBundleAt(this.ActiveElement).GetMaxcs();
        double min = this.GetBundleAt(this.ActiveElement).GetMincs();
        if (howmany < 0.0 || max > min + howmany) {
            this.GetBundleAt(this.ActiveElement).SetMincs(min + howmany);
            this.InvalidateSlices();
            this.InvalidateProjs(this.ActiveElement);
        }
        this.transferThresh(this.ActiveElement);
    }

    public void addUThresh(double howmuch) {
        double howmany = howmuch * this.ActElement().MaxValue;
        double max = this.GetBundleAt(this.ActiveElement).GetMaxcs();
        double min = this.GetBundleAt(this.ActiveElement).GetMincs();
        if (howmany > 0.0 || max + howmany > min) {
            this.GetBundleAt(this.ActiveElement).SetMaxcs(max + howmany);
            this.InvalidateSlices();
            this.InvalidateProjs(this.ActiveElement);
        }
        this.transferThresh(this.ActiveElement);
    }

    public void initThresh() {
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt((int)e).cmapcLow = 0;
            this.GetBundleAt((int)e).cmapcHigh = Short.MAX_VALUE;
            this.GetBundleAt(e).CompCMap();
            AnElement ne = this.ElementAt(e);
            if (ne instanceof FloatElement || ne instanceof DoubleElement) {
                this.GetBundleAt(e).SetMincs(ne.Min);
                this.GetBundleAt(e).SetMaxcs(ne.Max);
            } else {
                this.GetBundleAt(e).SetMincs(ne.OffsetV);
                this.GetBundleAt(e).SetMaxcs(ne.MaxValue);
            }
            this.ToggleLog(e, 0);
            this.transferThresh(e);
        }
        this.InvalidateSlices();
    }

    public void initGlobalThresh() {
        int e;
        AnElement ne = this.ElementAt(0);
        double min = ne.Min;
        double max = ne.Max;
        for (e = 1; e < this.Elements; ++e) {
            ne = this.ElementAt(e);
            if (ne.Min < min) {
                min = ne.Min;
            }
            if (!(ne.Max > max)) continue;
            max = ne.Max;
        }
        for (e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).SetMincs(min);
            this.GetBundleAt(e).SetMaxcs(max);
            this.ToggleLog(e, 0);
            this.transferThresh(e);
        }
        this.InvalidateSlices();
    }

    public Vector<AnElement> ElementsAtTime(int atime) {
        return this.MyTimes.elementAt(atime);
    }

    public Vector<ASlice>[] ProjsAtTime(int atime) {
        return this.MyTimeProj.elementAt(atime);
    }

    public ASlice[] ColorProjsAtTime(int atime) {
        return this.MyTimeColorProj.elementAt(atime);
    }

    public void GetElementsFromTime() {
        this.MyElements = this.ElementsAtTime(this.ActiveTime);
        this.InvalidateSlices();
    }

    public void GetProjsFromTime() {
        this.MyProjections = this.ProjsAtTime(this.ActiveTime);
        this.MyColorProjection = this.ColorProjsAtTime(this.ActiveTime);
    }

    public void setTime(int num) {
        this.storeMinMaxCs();
        if (num >= this.Times) {
            num %= this.Times;
        }
        if (num < 0) {
            num = (num + this.Times) % this.Times;
        }
        this.ActiveTime = num;
        if (!this.timesLinked) {
            this.retrieveMinMaxCs();
        }
        this.GetElementsFromTime();
        this.GetProjsFromTime();
    }

    public void nextTime(int num) {
        int newtime = this.ActiveTime + num;
        this.setTime(newtime);
    }

    void storeMinMaxCs() {
        Vector<ColorInfo> AllColInfo = new Vector<ColorInfo>();
        ColorInfo ColInfo = null;
        for (int e = 0; e < this.Elements; ++e) {
            ColInfo = new ColorInfo();
            ColInfo.cmapcLow = this.GetBundleAt((int)e).cmapcLow;
            ColInfo.cmapcHigh = this.GetBundleAt((int)e).cmapcHigh;
            ColInfo.MinCs = this.GetBundleAt(e).GetMincs();
            ColInfo.MaxCs = this.GetBundleAt(e).GetMaxcs();
            AllColInfo.add(ColInfo);
        }
        while (this.TimesColorInfo.size() < this.Times) {
            this.TimesColorInfo.add(AllColInfo);
        }
        this.TimesColorInfo.set(this.ActiveTime, AllColInfo);
    }

    void retrieveMinMaxCs() {
        Vector<ColorInfo> AllCol = this.TimesColorInfo.get(this.ActiveTime);
        ColorInfo ColInfo = new ColorInfo();
        for (int e = 0; e < this.Elements; ++e) {
            if (AllCol == null) continue;
            if (e < AllCol.size()) {
                ColInfo = AllCol.get(e);
                this.GetBundleAt(e).SetMincs(ColInfo.MinCs);
                this.GetBundleAt(e).SetMaxcs(ColInfo.MaxCs);
                this.setColorMapThresh(e, ColInfo.cmapcLow, ColInfo.cmapcHigh);
                continue;
            }
            System.out.println("Problem with Element " + e + "\n");
        }
    }

    public void advanceTime(int howmany) {
        this.storeMinMaxCs();
        this.ActiveTime += howmany;
        if (this.ActiveTime < 0) {
            this.ActiveTime += this.Times;
        }
        if (this.ActiveTime < 0) {
            this.ActiveTime = 0;
        }
        if (!this.timesLinked) {
            this.retrieveMinMaxCs();
        }
        this.ActiveTime %= this.Times;
        this.GetElementsFromTime();
        this.GetProjsFromTime();
    }

    public void setElement(int num) {
        if (num >= this.Elements) {
            num = this.Elements - 1;
        }
        if (num < 0) {
            num = 0;
        }
        this.ActiveElement = num;
        this.InvalidateSlices();
    }

    public void advanceElement(int howmany) {
        this.ActiveElement += howmany;
        if (this.ActiveElement < 0) {
            this.ActiveElement += this.Elements;
        }
        if (this.ActiveElement < 0) {
            this.ActiveElement = 0;
        }
        this.ActiveElement %= this.Elements;
        this.InvalidateSlices();
    }

    public int GetNumElements() {
        return this.Elements;
    }

    public int GetNumTimes() {
        return this.Times;
    }

    public int GetSize(int DimNr) {
        return this.sizes[DimNr];
    }

    public double GetROISize(int elem, int dim) {
        if (elem < 0) {
            return this.ActElement().Scales[dim] * this.ActROI().GetROISize(dim);
        }
        return this.ElementAt((int)elem).Scales[dim] * this.ActROI().GetROISize(dim);
    }

    public double GetROISum(int elem) {
        this.DoProject(elem, 0);
        for (int d = 0; d < 3; ++d) {
            if (!this.GetBundleAt((int)elem).ProjValid[d] || !this.ProjAt((int)d, (int)elem).isValid) continue;
            return this.ProjAt((int)d, (int)elem).ROISum;
        }
        return this.ProjAt((int)2, (int)elem).ROISum;
    }

    public double GetROIVoxels(int elem) {
        this.DoProject(elem, 0);
        for (int d = 0; d < 3; ++d) {
            if (!this.GetBundleAt((int)elem).ProjValid[d] || !this.ProjAt((int)d, (int)elem).isValid) continue;
            return this.ProjAt((int)d, (int)elem).ROIVoxels;
        }
        return this.ProjAt((int)2, (int)elem).ROIVoxels;
    }

    public double GetROIAvg(int elem) {
        this.DoProject(elem, 0);
        for (int d = 0; d < 3; ++d) {
            if (!this.GetBundleAt((int)elem).ProjValid[d] || !this.ProjAt((int)d, (int)elem).isValid) continue;
            return this.ProjAt((int)d, (int)elem).ROIAvg;
        }
        return this.ProjAt((int)2, (int)elem).ROIAvg;
    }

    public double GetROIMax(int elem) {
        this.DoProject(elem, 0);
        for (int d = 0; d < 3; ++d) {
            if (!this.GetBundleAt((int)elem).ProjValid[d] || !this.ProjAt((int)d, (int)elem).isValid) continue;
            return this.ProjAt((int)d, (int)elem).ROIMax;
        }
        return this.ProjAt((int)2, (int)elem).ROIMax;
    }

    public double GetROIMin(int elem) {
        this.DoProject(elem, 0);
        for (int d = 0; d < 3; ++d) {
            if (!this.GetBundleAt((int)elem).ProjValid[d] || !this.ProjAt((int)d, (int)elem).isValid) continue;
            return this.ProjAt((int)d, (int)elem).ROIMin;
        }
        return this.ProjAt((int)2, (int)elem).ROIMin;
    }

    public double GetROIVal(int elem) {
        if (this.GetMIPMode(0)) {
            return this.GetROIMax(elem);
        }
        return this.GetROIAvg(elem);
    }

    public String GetDataTypeName(int elem) {
        return this.ElementAt(elem).GetDataTypeName();
    }

    public double GetValueScale(int elem) {
        return this.ElementAt((int)elem).ScaleV;
    }

    public double GetScale(int elem, int dim) {
        return this.ElementAt((int)elem).Scales[dim];
    }

    public double[] GetScale(int elem) {
        return this.ElementAt((int)elem).Scales;
    }

    public double GetOffset(int elem, int dim) {
        return this.ElementAt((int)elem).Offsets[dim];
    }

    public double[] GetOffset(int elem) {
        return this.ElementAt((int)elem).Offsets;
    }

    public void SetValueScale(int elem, double ScaleV, double Off, String NameV, String UnitV) {
        this.ElementAt(elem).SetScales(ScaleV, Off, NameV, UnitV);
    }

    public void SetOffsets(int elem, double OfX, double OfY, double OfZ) {
        this.ElementAt((int)elem).Offsets[0] = OfX;
        this.ElementAt((int)elem).Offsets[1] = OfY;
        this.ElementAt((int)elem).Offsets[2] = OfZ;
    }

    public String GetValueName(int elem) {
        return this.ElementAt((int)elem).NameV;
    }

    public String GetValueUnit(int elem) {
        return this.ElementAt((int)elem).UnitV;
    }

    public String[] GetAxisUnits() {
        return this.ActElement().Units;
    }

    public String[] GetAxisNames() {
        return this.ActElement().Names;
    }

    void AxesUnitsDialog() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AGenericDialog md = new AGenericDialog("Axes Units and Scalings");
                int e = My3DData.this.ActiveElement;
                md.addStringField("NameX: ", My3DData.this.GetAxisNames()[0]);
                md.addStringField("UnitX: ", My3DData.this.GetAxisUnits()[0]);
                md.addNumericField("ScaleX: ", My3DData.this.GetScale(e, 0), 5);
                md.addNumericField("OffsetX: ", My3DData.this.GetOffset(e, 0), 5);
                md.addStringField("NameY: ", My3DData.this.GetAxisNames()[1]);
                md.addStringField("UnitY: ", My3DData.this.GetAxisUnits()[1]);
                md.addNumericField("ScaleY: ", My3DData.this.GetScale(e, 1), 5);
                md.addNumericField("OffsetY: ", My3DData.this.GetOffset(e, 1), 5);
                md.addStringField("NameZ: ", My3DData.this.GetAxisNames()[2]);
                md.addStringField("UnitZ: ", My3DData.this.GetAxisUnits()[2]);
                md.addNumericField("ScaleZ: ", My3DData.this.GetScale(e, 2), 5);
                md.addNumericField("OffsetZ: ", My3DData.this.GetOffset(e, 2), 5);
                md.addStringField("NameE: ", My3DData.this.GetAxisNames()[3]);
                md.addStringField("UnitE: ", My3DData.this.GetAxisUnits()[3]);
                md.addNumericField("ScaleE: ", My3DData.this.GetScale(e, 3), 5);
                md.addNumericField("OffsetE: ", My3DData.this.GetOffset(e, 3), 5);
                md.addStringField("NameT: ", My3DData.this.GetAxisNames()[4]);
                md.addStringField("UnitT: ", My3DData.this.GetAxisUnits()[4]);
                md.addNumericField("ScaleT: ", My3DData.this.GetScale(e, 4), 5);
                md.addNumericField("OffsetT: ", My3DData.this.GetOffset(e, 4), 5);
                md.showDialog();
                if (!md.wasCanceled()) {
                    String[] Units = new String[5];
                    String[] Names = new String[5];
                    Names[0] = md.getNextString();
                    Units[0] = md.getNextString();
                    double SX = md.getNextNumber();
                    double OX = md.getNextNumber();
                    Names[1] = md.getNextString();
                    Units[1] = md.getNextString();
                    double SY = md.getNextNumber();
                    double OY = md.getNextNumber();
                    Names[2] = md.getNextString();
                    Units[2] = md.getNextString();
                    double SZ = md.getNextNumber();
                    double OZ = md.getNextNumber();
                    Names[3] = md.getNextString();
                    Units[3] = md.getNextString();
                    double SE = md.getNextNumber();
                    double OE = md.getNextNumber();
                    Names[4] = md.getNextString();
                    Units[4] = md.getNextString();
                    double ST = md.getNextNumber();
                    double OT = md.getNextNumber();
                    for (int i = 0; i < My3DData.this.Elements; ++i) {
                        My3DData.this.ElementAt((int)i).Scales[0] = SX;
                        My3DData.this.ElementAt((int)i).Scales[1] = SY;
                        My3DData.this.ElementAt((int)i).Scales[2] = SZ;
                        My3DData.this.ElementAt((int)i).Scales[3] = SE;
                        My3DData.this.ElementAt((int)i).Scales[4] = ST;
                        My3DData.this.ElementAt((int)i).Offsets[0] = OX;
                        My3DData.this.ElementAt((int)i).Offsets[1] = OY;
                        My3DData.this.ElementAt((int)i).Offsets[2] = OZ;
                        My3DData.this.ElementAt((int)i).Offsets[3] = OE;
                        My3DData.this.ElementAt((int)i).Offsets[4] = OT;
                        My3DData.this.ElementAt((int)i).Names = Names;
                        My3DData.this.ElementAt((int)i).Units = Units;
                    }
                }
            }
        };
        try {
            EventQueue.invokeLater(runnable);
        }
        catch (Exception e) {
            System.out.println("Exception appeared in dialogue \n");
            e.printStackTrace();
        }
    }

    void ValueUnitsDialog() {
        AGenericDialog md = new AGenericDialog("Value Unit and Scaling");
        int e = this.ActiveElement;
        double[] DispOffset = this.GetDisplayOffset(e);
        md.addStringField("ValueName: ", this.GetValueName(e));
        md.addStringField("ValueUnit: ", this.GetValueUnit(e));
        md.addNumericField("ValueScale: ", this.GetValueScale(e), 5);
        md.addNumericField("ValueOffset: ", this.GetValueOffset(e), 5);
        md.addNumericField("Threshold Min: ", this.GetScaledMincs(e), 5);
        md.addNumericField("Threshold Max: ", this.GetScaledMaxcs(e), 5);
        md.addNumericField("DisplayOffset X: ", DispOffset[0], 5);
        md.addNumericField("DisplayOffset Y: ", DispOffset[1], 5);
        md.addNumericField("DisplayOffset Z: ", DispOffset[2], 5);
        md.addNumericField("Display Gamma: ", this.GetGamma(e), 5);
        md.addCheckbox("Elements Linked", this.elementsLinked);
        md.addCheckbox("Time Linked", this.timesLinked);
        md.showDialog();
        if (!md.wasCanceled()) {
            String NV = md.getNextString();
            String UV = md.getNextString();
            double SV = md.getNextNumber();
            double OV = md.getNextNumber();
            double Min = md.getNextNumber();
            double Max = md.getNextNumber();
            DispOffset[0] = md.getNextNumber();
            DispOffset[1] = md.getNextNumber();
            DispOffset[2] = md.getNextNumber();
            double Gamma = md.getNextNumber();
            this.elementsLinked = md.getNextBoolean();
            this.ElementAt(e).SetScales(SV, OV, NV, UV);
            this.SetScaledMinMaxcs(e, Min, Max);
            this.SetGamma(e, Gamma);
            if (this.elementsLinked) {
                this.copyLinkedProperties(this.ActiveElement);
            }
            this.timesLinked = md.getNextBoolean();
            this.InvalidateSlices();
        }
    }

    public double GetValueOffset(int elem) {
        return this.ElementAt((int)elem).OffsetV;
    }

    public double[] GetDisplayOffset(int elem) {
        return this.ElementAt((int)elem).DisplayOffset;
    }

    public void SetValueOffset(int elem, double value) {
        this.ElementAt((int)elem).OffsetV = value;
    }

    public int GetActiveElement() {
        return this.ActiveElement;
    }

    public int GetActiveTime() {
        return this.ActiveTime;
    }

    public boolean GetColorMode() {
        return this.colormode;
    }

    public int GetChannel(int col) {
        if (col == 0) {
            return this.elemR;
        }
        if (col == 1) {
            return this.elemG;
        }
        if (col == 2) {
            return this.elemB;
        }
        return -1;
    }

    public void InvalidateColor(int time) {
        this.MyColorSlice[0].Invalidate();
        this.MyColorSlice[1].Invalidate();
        this.MyColorSlice[2].Invalidate();
        this.MyColorProjection[0].Invalidate();
        this.MyColorProjection[1].Invalidate();
        this.MyColorProjection[2].Invalidate();
    }

    public void InvalidateColor() {
        for (int t = 0; t < this.Times; ++t) {
            this.InvalidateColor(t);
        }
    }

    public void InvalidateSlices() {
        this.MyColorSlice[0].Invalidate();
        this.MyColorSlice[1].Invalidate();
        this.MyColorSlice[2].Invalidate();
        this.MySlice[0].Invalidate();
        this.MySlice[1].Invalidate();
        this.MySlice[2].Invalidate();
    }

    public void InvalidateProjs(int which, int time) {
        if (which < 0) {
            for (int e = 0; e < this.Elements; ++e) {
                this.ProjsAtTime(time)[0].elementAt(e).Invalidate();
                this.ProjsAtTime(time)[1].elementAt(e).Invalidate();
                this.ProjsAtTime(time)[2].elementAt(e).Invalidate();
                this.GetBundleAt(e).Invalidate();
            }
            this.ColorProjsAtTime(time)[0].Invalidate();
            this.ColorProjsAtTime(time)[1].Invalidate();
            this.ColorProjsAtTime(time)[2].Invalidate();
        } else {
            this.ProjsAtTime(time)[0].elementAt(which).Invalidate();
            this.ProjsAtTime(time)[1].elementAt(which).Invalidate();
            this.ProjsAtTime(time)[2].elementAt(which).Invalidate();
            this.GetBundleAt(which).Invalidate();
            if (this.InOverlayDispl(which)) {
                this.ColorProjsAtTime(time)[0].Invalidate();
                this.ColorProjsAtTime(time)[1].Invalidate();
                this.ColorProjsAtTime(time)[2].Invalidate();
            }
        }
    }

    public void InvalidateProjs(int which) {
        for (int t = 0; t < this.Times; ++t) {
            this.InvalidateProjs(which, t);
        }
    }

    public void ClearChannel(int col) {
        if (col == 0) {
            if (this.elemR >= 0) {
                this.GetBundleAt(this.elemR).ToggleOverlayDispl(0);
                this.GetBundleAt(this.elemR).ToggleMulDispl(0);
                this.GetBundleAt(this.elemR).ToggleModel(0);
            }
            this.elemR = -1;
        }
        if (col == 1) {
            if (this.elemG >= 0) {
                this.GetBundleAt(this.elemG).ToggleOverlayDispl(0);
                this.GetBundleAt(this.elemR).ToggleMulDispl(0);
                this.GetBundleAt(this.elemG).ToggleModel(0);
            }
            this.elemG = -1;
        }
        if (col == 2) {
            if (this.elemB >= 0) {
                this.GetBundleAt(this.elemB).ToggleOverlayDispl(0);
                this.GetBundleAt(this.elemR).ToggleMulDispl(0);
                this.GetBundleAt(this.elemB).ToggleModel(0);
            }
            this.elemB = -1;
        }
        this.InvalidateColor();
    }

    public void MarkChannel(int col) {
        this.MarkChannel(this.ActiveElement, col);
    }

    public void MarkChannel(int elem, int col) {
        if (col == 0) {
            this.elemR = elem;
            this.GetBundleAt(this.elemR).ToggleOverlayDispl(1);
            this.GetBundleAt(this.elemR).ToggleModel(1);
        }
        if (col == 1) {
            this.elemG = elem;
            this.GetBundleAt(this.elemG).ToggleOverlayDispl(1);
            this.GetBundleAt(this.elemG).ToggleModel(2);
        }
        if (col == 2) {
            this.elemB = elem;
            this.GetBundleAt(this.elemB).ToggleOverlayDispl(1);
            this.GetBundleAt(this.elemB).ToggleModel(3);
        }
        this.InvalidateColor();
    }

    public void MarkAsHistoDim(int dim) {
        System.out.println("Element " + this.ActiveElement + " marked as HistoDim " + dim);
        if (dim == 0 && this.HistoX != this.ActiveElement) {
            this.HistoX = this.ActiveElement;
        }
        if (dim == 1) {
            this.HistoY = this.HistoY == this.ActiveElement && this.HistoZ == -1 ? -1 : this.ActiveElement;
        }
        if (dim == 2) {
            this.HistoZ = this.HistoZ == this.ActiveElement ? -1 : this.ActiveElement;
        }
    }

    public void ToggleSquareROIs() {
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).ToggleROI();
        }
        this.InvalidateProjs(-1);
    }

    public boolean SquareROIs() {
        return this.GetBundleAt(this.ActiveElement).SquareROIs();
    }

    public void ToggleColor(boolean set) {
        this.colormode = set;
    }

    public void ToggleColor() {
        this.colormode = !this.colormode;
    }

    public void ComputeColorProj(int dim) {
        this.MyColorProjection[dim].ClearColor();
        for (int e = 0; e < this.Elements; ++e) {
            if (this.GetBundleAt(e).MulOverlayDispl()) {
                this.ElementAt(e).SetScaleShift(this.Getmincs(e), this.Getmaxcs(e));
                this.MyColorProjection[dim].MulToColorSlice(this.ProjAt(dim, e), this.GetBundleAt((int)e).cmapRed, this.GetBundleAt((int)e).cmapGreen, this.GetBundleAt((int)e).cmapBlue, this.ProjAt(dim, this.GateElem), this.GateActive, this.ElementAt(this.ActiveElement));
            }
            if (!this.GetBundleAt(e).InOverlayDispl()) continue;
            this.ElementAt(e).SetScaleShift(this.Getmincs(e), this.Getmaxcs(e));
            this.MyColorProjection[dim].SumToColorSlice(this.ProjAt(dim, e), this.GetBundleAt((int)e).cmapRed, this.GetBundleAt((int)e).cmapGreen, this.GetBundleAt((int)e).cmapBlue, this.ProjAt(dim, this.GateElem), this.GateActive, this.ElementAt(this.ActiveElement));
        }
        this.MyColorProjection[dim].isValid = true;
    }

    private AnElement GNE(AnElement oldelem, Vector<AnElement> ElementsList, Vector<ASlice>[] ProjList) {
        AnElement ne = null;
        if (oldelem.DataType == AnElement.IntegerType) {
            IntegerElement AE = (IntegerElement)oldelem;
            ne = new IntegerElement(AE.Sizes[0], AE.Sizes[1], AE.Sizes[2], AE.NumBytes, AE.MaxValue);
        } else if (oldelem.DataType == AnElement.FloatType) {
            ne = new FloatElement(oldelem.Sizes[0], oldelem.Sizes[1], oldelem.Sizes[2], 1000.0f);
        } else if (oldelem.DataType == AnElement.DoubleType) {
            ne = new DoubleElement(oldelem.Sizes[0], oldelem.Sizes[1], oldelem.Sizes[2], 1000.0);
        } else if (oldelem.DataType == AnElement.ComplexType) {
            ne = new ComplexElement(oldelem.Sizes[0], oldelem.Sizes[1], oldelem.Sizes[2], 1000.0);
        } else if (oldelem.DataType == AnElement.ByteType) {
            ne = new ByteElement(oldelem.Sizes[0], oldelem.Sizes[1], oldelem.Sizes[2]);
        } else if (oldelem.DataType == AnElement.ShortType) {
            ne = new ShortElement(oldelem.Sizes[0], oldelem.Sizes[1], oldelem.Sizes[2]);
        } else {
            System.out.println("Fatal Error! Element of unknown type: " + oldelem.DataType + "\n");
            throw new IllegalArgumentException("Unknown Element type\n");
        }
        ElementsList.addElement(ne);
        ProjList[0].addElement(new ASlice(0, ne));
        ProjList[1].addElement(new ASlice(1, ne));
        ProjList[2].addElement(new ASlice(2, ne));
        ne.SetScales(oldelem);
        return ne;
    }

    private void GNE(AnElement oldelem) {
        for (int t = 0; t < this.Times; ++t) {
            this.GNE(oldelem, this.ElementsAtTime(t), this.ProjsAtTime(t));
        }
        ++this.Elements;
    }

    public void CloneElement(AnElement oldelem) {
        if (this.Elements == 1) {
            this.MarkChannel(0);
        }
        this.GNE(oldelem);
        this.MyBundle.addElement((Bundle)this.GetBundleAt(this.Elements - 2).clone());
        this.TimesColorInfo.add(null);
        this.ActiveElement = this.Elements - 1;
        if (this.Elements == 2) {
            this.MarkChannel(1);
        }
        if (this.Elements == 3) {
            this.MarkChannel(2);
        }
        this.InvalidateSlices();
        this.InvalidateColor();
    }

    public void CloneLastElements() {
        for (int t = 0; t < this.Times; ++t) {
            this.CloneElement(this.ElementsAtTime(t).lastElement());
        }
    }

    private AnElement new_element(int DataType, int NumBytes, int NumBits) {
        AnElement ne = null;
        double MaxValue = (2 << NumBits - 1) - 1;
        if (DataType == AnElement.IntegerType) {
            ne = new IntegerElement(this.SizeX, this.SizeY, this.SizeZ, NumBytes, MaxValue);
        }
        if (DataType == AnElement.FloatType) {
            ne = new FloatElement(this.SizeX, this.SizeY, this.SizeZ, 1000.0f);
        }
        if (DataType == AnElement.DoubleType) {
            ne = new DoubleElement(this.SizeX, this.SizeY, this.SizeZ, 1000.0);
        }
        if (DataType == AnElement.ComplexType) {
            ne = new ComplexElement(this.SizeX, this.SizeY, this.SizeZ, 1000.0);
        }
        if (DataType == AnElement.ByteType) {
            ne = new ByteElement(this.SizeX, this.SizeY, this.SizeZ);
        }
        if (DataType == AnElement.ShortType) {
            ne = new ShortElement(this.SizeX, this.SizeY, this.SizeZ);
        }
        if (DataType == AnElement.UnsignedShortType) {
            ne = new UnsignedShortElement(this.SizeX, this.SizeY, this.SizeZ);
        }
        return ne;
    }

    private AnElement GNE(int DataType, int NumBytes, int NumBits, Vector<AnElement> ElementList, Vector<ASlice>[] ProjList) {
        AnElement ne = this.new_element(DataType, NumBytes, NumBits);
        ElementList.addElement(ne);
        ProjList[0].addElement(new ASlice(0, ne));
        ProjList[1].addElement(new ASlice(1, ne));
        ProjList[2].addElement(new ASlice(2, ne));
        return ne;
    }

    private int GenerateNewElement(int DataType, int NumBytes, int NumBits, double[] Scales, double[] Offsets, double ScaleV, double OffsetV, String[] Names, String[] Units, Vector<AnElement> ElementList, Vector<ASlice>[] ProjList) {
        int mynewnr = this.Elements;
        AnElement ne = this.GNE(DataType, NumBytes, NumBits, ElementList, ProjList);
        ne.SetScales(Scales, Offsets, ScaleV, OffsetV);
        ne.Names = Names;
        ne.Units = Units;
        return mynewnr;
    }

    public int GenerateNewElement(int DataType, int NumBytes, int NumBits, double[] Scales, double[] Offsets, double ScaleV, double OffsetV, String[] Names, String[] Units) {
        int ne = 0;
        for (int t = 0; t < this.Times; ++t) {
            ne = this.GenerateNewElement(DataType, NumBytes, NumBits, Scales, Offsets, ScaleV, OffsetV, Names, Units, this.ElementsAtTime(t), this.ProjsAtTime(t));
        }
        double MaxValue = (2 << NumBits - 1) - 1;
        Bundle nb = DataType == AnElement.FloatType ? new Bundle(0, 0.0, 1000.0) : (DataType == AnElement.ByteType ? new Bundle(0, 0.0, MaxValue) : new Bundle(0, 0.0, MaxValue));
        this.MyBundle.addElement(nb);
        this.TimesColorInfo.addElement(null);
        nb.TakeSqrROIs(this.ProjMin, this.ProjMax);
        nb.TakePolyROIs(this.ROIPolygons);
        nb.ActiveROI = ne > 0 ? (this.GetBundleAt((int)0).ActiveROI == this.GetBundleAt((int)0).rectROI ? nb.rectROI : nb.polyROI) : nb.rectROI;
        this.sizes[3] = ++this.Elements;
        this.sizes[4] = this.Times;
        return ne;
    }

    public int GenerateNewTime(int DataType, int NumBytes, int NumBits, double[] Scales, double[] Offsets, double ScaleV, double OffsetV, String[] Names, String[] Units, int NewElements) {
        int e;
        int ne = 0;
        this.ActiveTime = 0;
        Vector<AnElement> newElements = new Vector<AnElement>();
        this.MyProjections = new Vector[3];
        this.MyProjections[0] = new Vector();
        this.MyProjections[1] = new Vector();
        this.MyProjections[2] = new Vector();
        for (e = 0; e < NewElements; ++e) {
            ne = this.GenerateNewElement(DataType, NumBytes, NumBits, Scales, Offsets, ScaleV, OffsetV, Names, Units, newElements, this.MyProjections);
        }
        for (e = NewElements; e < this.Elements; ++e) {
            AnElement ref_el = this.ElementAt(e);
            int nb = 4;
            int nbits = 64;
            if (ref_el instanceof IntegerElement) {
                nb = ((IntegerElement)ref_el).NumBytes;
            }
            ne = this.GenerateNewElement(ref_el.DataType, nb, nbits, Scales, Offsets, ScaleV, OffsetV, Names, Units, newElements, this.MyProjections);
        }
        this.MyColorProjection = new ASlice[3];
        this.MyColorProjection[0] = new ASlice(0, newElements.firstElement());
        this.MyColorProjection[1] = new ASlice(1, newElements.firstElement());
        this.MyColorProjection[2] = new ASlice(2, newElements.firstElement());
        this.sizes[3] = this.Elements;
        this.sizes[4] = ++this.Times;
        this.MyTimeProj.addElement(this.MyProjections);
        this.MyTimeColorProj.addElement(this.MyColorProjection);
        this.MyTimes.addElement(newElements);
        this.ActiveTime = this.Times - 1;
        this.MyElements = this.ElementsAtTime(this.ActiveTime);
        return this.Times - 1;
    }

    public void AdjustOffsetToROIMean() {
        int elem = this.ActiveElement;
        double val = this.GetROIAvg(elem);
        this.SetValueOffset(elem, this.GetValueOffset(elem) - val);
        this.InvalidateProjs(elem);
        this.InvalidateSlices();
    }

    int GetPartnerElem() {
        int myelem = this.GateElem;
        if (myelem < 0) {
            myelem = this.Elements - 1;
        }
        return myelem;
    }

    public void AddMarkedElement() {
        int myelem = this.GetPartnerElem();
        if (myelem >= 0) {
            for (int t = 0; t < this.Times; ++t) {
                this.ElementAt(this.ActiveElement, t).Add(this.ElementAt(myelem, t));
            }
        }
        this.InvalidateSlices();
    }

    public void SubMarkedElement() {
        int myelem = this.GetPartnerElem();
        if (myelem >= 0) {
            for (int t = 0; t < this.Times; ++t) {
                this.ElementAt(this.ActiveElement, t).Sub(this.ElementAt(myelem, t));
            }
        }
        this.InvalidateSlices();
    }

    public void MulMarkedElement() {
        int myelem = this.GetPartnerElem();
        if (myelem >= 0) {
            for (int t = 0; t < this.Times; ++t) {
                this.ElementAt(this.ActiveElement, t).Mul(this.ElementAt(myelem, t));
            }
        }
        this.InvalidateSlices();
    }

    public void DivMarkedElement() {
        int myelem = this.GetPartnerElem();
        if (myelem >= 0) {
            for (int t = 0; t < this.Times; ++t) {
                this.ElementAt(this.ActiveElement, t).Div(this.ElementAt(myelem, t));
            }
        }
        this.InvalidateSlices();
    }

    public void DeleteActElement(Vector<AnElement> ElementList) {
        if (this.Elements <= 1) {
            return;
        }
        if (this.elemR == this.ActiveElement) {
            this.elemR = -1;
        } else if (this.elemR > this.ActiveElement) {
            --this.elemR;
        }
        if (this.elemG == this.ActiveElement) {
            this.elemG = -1;
        } else if (this.elemG > this.ActiveElement) {
            --this.elemG;
        }
        if (this.elemB == this.ActiveElement) {
            this.elemB = -1;
        } else if (this.elemB > this.ActiveElement) {
            --this.elemB;
        }
        if (this.GateElem == this.ActiveElement) {
            this.GateElem = 0;
        } else if (this.GateElem > this.ActiveElement) {
            --this.GateElem;
        }
        ElementList.removeElementAt(this.ActiveElement);
    }

    public void DeleteActElement() {
        if (this.Elements > 1) {
            for (int t = 0; t < this.Times; ++t) {
                this.DeleteActElement(this.ElementsAtTime(t));
                try {
                    if (this.TimesColorInfo == null || this.TimesColorInfo.get(t) == null) continue;
                    this.TimesColorInfo.get(t).removeElement(this.ActiveElement);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.MyBundle.removeElementAt(this.ActiveElement);
            this.MyProjections[0].removeElementAt(this.ActiveElement);
            this.MyProjections[1].removeElementAt(this.ActiveElement);
            this.MyProjections[2].removeElementAt(this.ActiveElement);
            --this.Elements;
            if (this.ActiveElement >= this.Elements) {
                this.ActiveElement = this.Elements - 1;
            }
            this.InvalidateSlices();
            this.InvalidateColor();
        }
    }

    public void DeleteActTime() {
        if (this.Times > 1) {
            for (int e = 0; e < this.Elements; ++e) {
                this.ElementsAtTime(this.ActiveTime).removeElementAt(0);
                try {
                    if (this.TimesColorInfo == null || this.TimesColorInfo.size() <= this.ActiveTime || this.TimesColorInfo.get(this.ActiveTime) == null) continue;
                    this.TimesColorInfo.get(this.ActiveTime).removeElement(0);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.MyTimeProj.removeElementAt(this.ActiveTime);
            this.MyTimeColorProj.removeElementAt(this.ActiveTime);
            this.MyTimes.removeElementAt(this.ActiveTime);
            --this.Times;
            if (this.ActiveTime >= this.Times) {
                this.ActiveTime = this.Times - 1;
            }
            this.InvalidateSlices();
            this.InvalidateColor();
            this.MyElements = this.ElementsAtTime(this.ActiveTime);
            this.sizes[4] = this.Times;
        }
    }

    public Color GetMarkerColor(int e) {
        int Red = 0;
        int Green = 0;
        int Blue = 0;
        int MaxC = this.GetBundleAt((int)e).cmapcHigh;
        if (MaxC > 32768) {
            MaxC = 32768;
        }
        Red = this.GetBundleAt((int)e).cmapRed[MaxC - 2];
        Green = this.GetBundleAt((int)e).cmapGreen[MaxC - 2];
        Blue = this.GetBundleAt((int)e).cmapBlue[MaxC - 2];
        if (Red < 0) {
            Red += 256;
        }
        if (Green < 0) {
            Green += 256;
        }
        if (Blue < 0) {
            Blue += 256;
        }
        if (Red < 50) {
            Red = 50;
        }
        if (Green < 50) {
            Green = 50;
        }
        if (Blue < 50) {
            Blue = 50;
        }
        return new Color(Red, Green, Blue);
    }

    public Color GetCMapColor(int e, int pos, int mysize) {
        return this.GetBundleAt(e).GetCMapColor(pos, mysize);
    }

    public double Normalize(double val, int e) {
        return (val - this.GetMinThresh(e)) / (this.GetMaxThresh(e) - this.GetMinThresh(e));
    }

    public double NormedValueAt(int x, int y, int z, int e) {
        double val = 0.0;
        try {
            val = this.ElementAt(e).GetRawValueAtOffset(x, y, z, this.ElementAt(this.ActiveElement));
        }
        catch (ArrayIndexOutOfBoundsException exept) {
            return 0.0;
        }
        double min = this.GetMinThresh(e);
        double max = this.GetMaxThresh(e);
        double Gamma = this.GetBundleAt((int)e).Gamma;
        if (!this.GetBundleAt((int)e).LogScale) {
            if (Gamma == 1.0) {
                return (val - min) / (max - min);
            }
            return Math.pow((val - min) / (max - min), Gamma);
        }
        if (val > 0.0) {
            double vl = 0.1;
            double vh = 1.0;
            if (min > 0.0) {
                vl = min;
            }
            if (max > 0.0) {
                vh = max;
            }
            return (Math.log(val) - Math.log(vl)) / (Math.log(vh) - Math.log(vl));
        }
        return -10.0;
    }

    public int GetIntValueAt(int x, int y, int z, int e) {
        return this.ElementAt(e).GetIntValueAt(x, y, z);
    }

    public Color GetColColor(int e, int x, int y, int z) {
        int val = this.GetIntValueAt(x, y, z, e);
        if (val < 0) {
            val = 0;
        }
        if (val > Short.MAX_VALUE) {
            val = Short.MAX_VALUE;
        }
        int red = this.GetBundleAt((int)e).cmapRed[val] & 0xFF;
        int green = this.GetBundleAt((int)e).cmapGreen[val] & 0xFF;
        int blue = this.GetBundleAt((int)e).cmapBlue[val] & 0xFF;
        return new Color(red, green, blue);
    }

    public double NormedProjValueAt(int dir, int pos, int e) {
        this.DoProject(e, dir);
        int xdir = 0;
        switch (dir) {
            case 0: {
                xdir = 1;
                break;
            }
            case 1: {
                xdir = 0;
                break;
            }
            case 2: {
                xdir = 2;
            }
        }
        double val = this.ProjAt(dir, e).GetNormed1DProjValue(pos + (int)this.ElementAt((int)this.ActiveElement).DisplayOffset[xdir]);
        if (!this.GetBundleAt((int)e).LogScale) {
            return val;
        }
        if (val > 0.0) {
            return (Math.log(val) - Math.log(0.01)) / -Math.log(0.01);
        }
        return -10.0;
    }

    public double ProjValueAt(int dir, int pos, int e) {
        this.DoProject(e, dir);
        int xdir = 0;
        switch (dir) {
            case 0: {
                xdir = 1;
                break;
            }
            case 1: {
                xdir = 0;
                break;
            }
            case 2: {
                xdir = 2;
            }
        }
        return this.ProjAt(dir, e).Get1DProjValue(pos + (int)this.ElementAt((int)this.ActiveElement).DisplayOffset[xdir]);
    }

    public double ValueAt(int x, int y, int z, int e) {
        return this.ElementAt(e).GetValueAtOffset(x, y, z, this.ElementAt(this.ActiveElement));
    }

    public void ApplyHistSelection() {
        if (this.DataToHistogram == null) {
            System.out.println("Error: No data connected to this histogram");
        } else {
            this.DataToHistogram.GenerateNewElement(AnElement.IntegerType, 4, 32, this.DataToHistogram.GetScale(0), this.DataToHistogram.GetOffset(0), 1.0, 0.0, this.DataToHistogram.GetAxisNames(), this.DataToHistogram.GetAxisUnits());
            this.DataToHistogram.setElement(this.DataToHistogram.Elements - 1);
            AnElement ne = this.DataToHistogram.ActElement();
            this.ActElement().ComputeHistMask(ne, this.ActROI());
            this.DataToHistogram.GetBundleAt(this.DataToHistogram.Elements - 1).SetMaxcs(ne.Max);
            this.DataToHistogram.GetBundleAt(this.DataToHistogram.Elements - 1).SetMincs(ne.Min);
        }
    }

    public void CloneFloat() {
        int prevActElem = this.ActiveElement;
        int ne = this.GenerateNewElement(AnElement.FloatType, 4, 32, this.GetScale(this.ActiveElement), this.GetOffset(this.ActiveElement), 1.0, 0.0, this.GetAxisNames(), this.GetAxisUnits());
        for (int t = 0; t < this.Times; ++t) {
            this.ElementAt(ne, t).CopyVal(this.ElementAt(prevActElem, t));
        }
    }

    public void CloneShort() {
        int prevActElem = this.ActiveElement;
        int ne = this.GenerateNewElement(AnElement.ShortType, 2, 16, this.GetScale(this.ActiveElement), this.GetOffset(this.ActiveElement), 1.0, 0.0, this.GetAxisNames(), this.GetAxisUnits());
        for (int t = 0; t < this.Times; ++t) {
            ((IntegerElement)this.ElementAt(ne, t)).CopyIntVal(this.ElementAt(prevActElem, t), this.Getmincs(prevActElem), this.Getmaxcs(prevActElem));
        }
    }

    public void GenerateMask(int dim) {
        int prevActElem = this.ActiveElement;
        int ne = 0;
        if (this.ProjMode[dim]) {
            ne = this.GenerateNewElement(this.ActElement().DataType, this.ActElement().GetStdByteNum(), this.ActElement().GetStdBitNum(), this.GetScale(this.ActiveElement), this.GetOffset(this.ActiveElement), 1.0, 0.0, this.GetAxisNames(), this.GetAxisUnits());
            this.ElementAt(ne).GenerateMask(this.ROIAt(prevActElem), this.GetGateElem(), this.ElementAt(prevActElem), true);
        } else {
            ne = this.GenerateNewElement(AnElement.ByteType, 1, 8, this.GetScale(this.ActiveElement), this.GetOffset(this.ActiveElement), 1.0, 0.0, this.GetAxisNames(), this.GetAxisUnits());
            this.ElementAt(ne).SetScales(1.0, 0.0, "inside ROI", "a.u.");
            this.ElementAt(ne).GenerateMask(this.ROIAt(prevActElem), this.GetGateElem(), this.ElementAt(prevActElem), false);
            this.GetBundleAt(ne).SetMaxcs(1.0);
            this.GetBundleAt(ne).SetMincs(0.0);
        }
        this.setElement(ne);
    }

    public AnElement ElementAt(int num, int time) {
        if (num >= 0 && time >= 0) {
            return this.ElementsAtTime(time).elementAt(num);
        }
        return null;
    }

    public AnElement ElementAt(int num) {
        if (num >= 0) {
            return this.MyElements.elementAt(num);
        }
        return null;
    }

    public AnElement ActElement() {
        return this.ElementAt(this.ActiveElement);
    }

    ROI ROIAt(int elem) {
        return this.GetBundleAt((int)elem).ActiveROI;
    }

    ROI ActROI() {
        return this.ROIAt(this.ActiveElement);
    }

    public int GetPolyROISize(int dir) {
        if (this.ROIPolygons == null) {
            return 0;
        }
        if (this.ROIPolygons[dir] != null) {
            return this.ROIPolygons[dir].npoints;
        }
        return 0;
    }

    public void GetPolyROICoords(int dir, int segment, float[] coords) {
        if (this.ROIPolygons[dir] != null) {
            coords[0] = this.ROIPolygons[dir].xpoints[segment];
            coords[1] = this.ROIPolygons[dir].ypoints[segment];
        }
    }

    public void MovePolyROI(int DX, int DY, int dir) {
        this.ROIPolygons[dir].translate(DX, DY);
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).TakePolyROIs(this.ROIPolygons);
            this.InvalidateProjs(e);
            this.DoProject(e, dir);
        }
    }

    public void MoveSqrROI(int DX, int DY, int dir) {
        Rectangle r2 = this.GetSqrROI(dir);
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).UpdateSqrROI(r2.x + DX, r2.y + DY, r2.x + r2.width + DX, r2.y + r2.height + DY, dir);
            this.InvalidateProjs(e);
            this.DoProject(e, dir);
        }
    }

    public void MoveROI(int DX, int DY, int dir) {
        if (this.SquareROIs()) {
            this.MoveSqrROI(DX, DY, dir);
        } else {
            this.MovePolyROI(DX, DY, dir);
        }
    }

    public void TakePolyROI(Polygon myNewROI, int dir) {
        this.ROIPolygons[dir] = myNewROI;
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).TakePolyROIs(this.ROIPolygons);
            this.InvalidateProjs(e);
            this.DoProject(e, dir);
        }
    }

    public void ClearPolyROIs(int dir) {
        this.ROIPolygons[dir] = null;
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).TakePolyROIs(this.ROIPolygons);
        }
        this.InvalidateProjs(-1);
    }

    public void ClearPolyROIs() {
        this.ROIPolygons[0] = null;
        this.ROIPolygons[1] = null;
        this.ROIPolygons[2] = null;
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).TakePolyROIs(this.ROIPolygons);
        }
        this.InvalidateProjs(-1);
    }

    public void TakeLineROI(int ROIX, int ROIY, int ROIXe, int ROIYe, int dir) {
        int ROIXs = 0;
        int ROIYs = 0;
        int ROIZs = 0;
        double vecx = 0.0;
        double vecy = 0.0;
        double vecz = 0.0;
        if (dir == 0) {
            vecx = 0.0;
            ROIZs = ROIX;
            vecy = ROIXe - ROIX;
            ROIYs = ROIY;
            vecz = -(ROIYe - ROIY);
        } else if (dir == 1) {
            vecy = 0.0;
            ROIXs = ROIX;
            vecz = ROIXe - ROIX;
            ROIZs = ROIY;
            vecx = -(ROIYe - ROIY);
        } else {
            vecz = 0.0;
            ROIXs = ROIX;
            vecy = ROIXe - ROIX;
            ROIYs = ROIY;
            vecx = -(ROIYe - ROIY);
        }
        this.PlanesS[0].addElement(ROIXs);
        this.PlanesS[1].addElement(ROIYs);
        this.PlanesS[2].addElement(ROIZs);
        this.PlanesD[0].addElement(vecx);
        this.PlanesD[1].addElement(vecy);
        this.PlanesD[2].addElement(vecz);
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).TakePlaneROIs(this.PlanesS, this.PlanesD);
        }
        this.InvalidateProjs(-1);
    }

    public void ClearLineROIs() {
        this.PlanesS[0].removeAllElements();
        this.PlanesS[1].removeAllElements();
        this.PlanesS[2].removeAllElements();
        this.PlanesD[0].removeAllElements();
        this.PlanesD[1].removeAllElements();
        this.PlanesD[2].removeAllElements();
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).TakePlaneROIs(this.PlanesS, this.PlanesD);
        }
        this.InvalidateProjs(-1);
    }

    public Rectangle GetSqrROI(int dim) {
        return this.GetBundleAt((int)this.ActiveElement).rectROI.GetSqrROI(dim);
    }

    public void TakeROI(int ROIX, int ROIY, int ROIXe, int ROIYe, int dir) {
        int tmp;
        if (ROIX > ROIXe) {
            tmp = ROIX;
            ROIX = ROIXe;
            ROIXe = tmp;
        }
        if (ROIY > ROIYe) {
            tmp = ROIY;
            ROIY = ROIYe;
            ROIYe = tmp;
        }
        if (dir == 0) {
            this.ProjMin[2] = ROIX;
            this.ProjMax[2] = ROIXe;
            this.ProjMin[1] = ROIY;
            this.ProjMax[1] = ROIYe;
        } else if (dir == 1) {
            this.ProjMin[0] = ROIX;
            this.ProjMax[0] = ROIXe;
            this.ProjMin[2] = ROIY;
            this.ProjMax[2] = ROIYe;
        } else {
            this.ProjMin[0] = ROIX;
            this.ProjMax[0] = ROIXe;
            this.ProjMin[1] = ROIY;
            this.ProjMax[1] = ROIYe;
        }
        for (int e = 0; e < this.Elements; ++e) {
            this.GetBundleAt(e).UpdateSqrROI(ROIX, ROIY, ROIXe, ROIYe, dir);
        }
        this.InvalidateProjs(-1);
    }

    public void TakeDataToHistogram(My3DData data) {
        this.ActElement().DataToHistogramX = data.ElementAt(data.HistoX);
        this.ActElement().DataToHistogramY = data.ElementAt(data.HistoY);
        this.ActElement().DataToHistogramZ = data.ElementAt(data.HistoZ);
        this.DataToHistogram = data;
    }

    AnElement GetGateElem(int t) {
        AnElement gate = null;
        gate = this.GateElem >= 0 && this.GateActive ? this.ElementAt(this.GateElem, t) : new OneElement(this.SizeX, this.SizeY, this.SizeZ);
        return gate;
    }

    AnElement GetGateElem() {
        return this.GetGateElem(this.ActiveTime);
    }

    void ComputeHistogram() {
        this.ActElement().ComputeHistogram(this.DataToHistogram.GetGateElem(), this.DataToHistogram.ActROI());
        this.GetBundleAt(this.ActiveElement).SetMaxcs(this.ActElement().Max);
        this.GetBundleAt(this.ActiveElement).SetMincs(this.ActElement().Min);
        this.ToggleLog(1);
        this.ToggleOvUn(0);
    }

    void SetMinMaxCalib(ImagePlus myim, int dim) {
        double[] coeff = new double[]{this.GetValueOffset(this.ActiveElement), this.GetValueScale(this.ActiveElement)};
        if (!this.colormode) {
            if (dim >= 0) {
                myim.getProcessor().setMinAndMax(0.0, 32768.0);
            } else {
                myim.getProcessor().setMinAndMax((this.GetScaledMincs(this.ActiveElement) - coeff[0]) / coeff[1], (this.GetScaledMaxcs(this.ActiveElement) - coeff[0]) / coeff[1]);
            }
        }
        Calibration myCal = myim.getCalibration();
        double sx = this.GetScale(this.ActiveElement, 0);
        double sy = this.GetScale(this.ActiveElement, 1);
        double sz = this.GetScale(this.ActiveElement, 2);
        double ox = this.GetOffset(this.ActiveElement, 0);
        double oy = this.GetOffset(this.ActiveElement, 1);
        double oz = this.GetOffset(this.ActiveElement, 2);
        myCal.pixelWidth = sx;
        myCal.pixelHeight = sy;
        myCal.pixelDepth = sz;
        myCal.xOrigin = ox;
        myCal.yOrigin = oy;
        myCal.zOrigin = oz;
        myCal.setUnit(this.GetAxisUnits()[0]);
        if (dim >= 0) {
            switch (dim) {
                case 0: {
                    sx = this.GetScale(this.ActiveElement, 2);
                    ox = this.GetOffset(this.ActiveElement, 2);
                    sy = this.GetScale(this.ActiveElement, 1);
                    oy = this.GetOffset(this.ActiveElement, 1);
                    break;
                }
                case 1: {
                    sx = this.GetScale(this.ActiveElement, 0);
                    ox = this.GetOffset(this.ActiveElement, 0);
                    sy = this.GetScale(this.ActiveElement, 2);
                    oy = this.GetOffset(this.ActiveElement, 2);
                    break;
                }
                case 2: {
                    sx = this.GetScale(this.ActiveElement, 0);
                    ox = this.GetOffset(this.ActiveElement, 0);
                    sy = this.GetScale(this.ActiveElement, 1);
                    oy = this.GetOffset(this.ActiveElement, 1);
                }
            }
        } else {
            myCal.setFunction(0, coeff, this.GetValueUnit(this.ActiveElement));
        }
    }

    void Export(int dim, int pos) {
        ImagePlus myim = null;
        if (dim >= 0) {
            myim = this.colormode ? this.getDisplayedSlice(dim, pos).ColorExport() : this.getDisplayedSlice(dim, pos).Export();
        } else {
            if (this.ActElement() instanceof ByteElement) {
                myim = NewImage.createByteImage((String)"View5D Volume", (int)this.SizeX, (int)this.SizeY, (int)this.SizeZ, (int)1);
            }
            if (this.ActElement() instanceof ShortElement) {
                myim = NewImage.createShortImage((String)"View5D Volume", (int)this.SizeX, (int)this.SizeY, (int)this.SizeZ, (int)1);
            }
            if (this.ActElement() instanceof IntegerElement) {
                myim = NewImage.createShortImage((String)"View5D Volume", (int)this.SizeX, (int)this.SizeY, (int)this.SizeZ, (int)1);
            }
            if (this.ActElement() instanceof FloatElement) {
                myim = NewImage.createFloatImage((String)"View5D Volume", (int)this.SizeX, (int)this.SizeY, (int)this.SizeZ, (int)1);
            }
            if (this.ActElement() instanceof DoubleElement) {
                myim = NewImage.createFloatImage((String)"View5D Volume", (int)this.SizeX, (int)this.SizeY, (int)this.SizeZ, (int)1);
            }
            for (int i = 0; i < this.SizeZ; ++i) {
                this.ActElement().CopySliceToSimilar(i, myim.getImageStack().getPixels(i + 1));
            }
        }
        this.SetMinMaxCalib(myim, dim);
        myim.show();
        myim.updateAndDraw();
    }

    public void SetUp(int DataType, View5D_ myv3d, int elements, int times, int ImageType) {
        if (this.SizeX * this.SizeY * this.SizeZ == 0) {
            myv3d.add("South", new Label("Error ! Image has zero sizes !\n"));
            System.out.println("Error: Image has zero size");
            myv3d.setVisible(true);
        }
        int ijslice = 0;
        int z = 0;
        int elem = 0;
        int t = 0;
        try {
            if (ImageType == 4) {
                elements /= 3;
            }
            for (t = 0; t < times; ++t) {
                for (elem = 0; elem < elements; ++elem) {
                    for (z = 0; z < this.SizeZ; ++z) {
                        switch (this.DimensionOrder) {
                            case 0: {
                                ijslice = t * elements * this.SizeZ + elem * this.SizeZ + z;
                                break;
                            }
                            case 1: {
                                ijslice = t * elements * this.SizeZ + z * elements + elem;
                                break;
                            }
                            case 2: {
                                ijslice = elem * times * this.SizeZ + t * this.SizeZ + z;
                                break;
                            }
                            case 3: {
                                ijslice = elem * times * this.SizeZ + z * elements + t;
                                break;
                            }
                            case 4: {
                                ijslice = z * elements * times + t * elements + elem;
                                break;
                            }
                            case 5: {
                                ijslice = z * elements * times + elem * times + t;
                            }
                        }
                        if (ImageType == 4) {
                            int[] slice = (int[])myv3d.GetImp().getImageStack().getPixels(ijslice + 1);
                            this.ElementAt(this.Elements - 3 * elements + elem, this.Times - times + t).ConvertSliceFromRGB(z, 0, slice, 1, 0, 2);
                            this.ElementAt(this.Elements - 3 * elements + elem + 1, this.Times - times + t).ConvertSliceFromRGB(z, 0, slice, 1, 0, 1);
                            this.ElementAt(this.Elements - 3 * elements + elem + 2, this.Times - times + t).ConvertSliceFromRGB(z, 0, slice, 1, 0, 0);
                            continue;
                        }
                        this.ElementAt(this.Elements - elements + elem, this.Times - times + t).ConvertSliceFromSimilar(z, 0, myv3d.GetImp().getImageStack().getPixels(ijslice + 1), 1, 0);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception appeared during data setup ! (" + this.SizeX + ", " + this.SizeY + ", " + this.SizeZ + ", z: " + z + ", ijslice: " + ijslice + ") \n");
            System.out.println("Element (" + this.Elements + ", " + elements + ", " + elem + ", T " + this.Times + ", " + times + ", " + t + ") \n");
            System.out.println("Exception was : " + e);
            System.out.println("Setup loading ImageJ image");
            e.printStackTrace();
            myv3d.setVisible(true);
        }
        this.sizes[3] = this.Elements;
        this.sizes[4] = this.Times;
    }

    public void SaveMarkers() {
        try {
            System.out.println("Saving marker file: " + this.markerOutfilename);
            FileOutputStream os = new FileOutputStream(this.markerOutfilename);
            if (this.AppendVersionNumber) {
                String MyNumber;
                int nBeg;
                this.markerInfilename = this.markerOutfilename;
                int nEnd = this.markerOutfilename.length();
                int Num = 1;
                try {
                    for (nBeg = this.markerOutfilename.length() - 1; nBeg >= 0; --nBeg) {
                        MyNumber = this.markerOutfilename.substring(nBeg, nEnd);
                        Num = Integer.parseInt(MyNumber);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nBeg == nEnd - 1) {
                    nBeg -= 4;
                    nEnd -= 4;
                    try {
                        while (nBeg >= 0) {
                            MyNumber = this.markerOutfilename.substring(nBeg, nEnd);
                            Num = Integer.parseInt(MyNumber);
                            --nBeg;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                NumberFormat nf = NumberFormat.getIntegerInstance(Locale.US);
                nf.setMinimumIntegerDigits(nEnd - nBeg - 1);
                this.markerOutfilename = this.markerOutfilename.substring(0, nBeg + 1) + nf.format(Num + 1) + this.markerOutfilename.substring(nEnd, this.markerOutfilename.length());
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
            out.write(this.GetMarkerPrintout(this));
            ((Writer)out).close();
            os.close();
        }
        catch (IOException e) {
            System.out.println("saving markers, IOException:" + e);
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("saving markers, Memoryexception! " + e + "\n");
            e.printStackTrace();
        }
    }

    public void LoadMarkers() {
        URL myurl = null;
        try {
            if (this.markerInfilename == null) {
                System.out.println("Markerfile == null  !?\n");
            }
            myurl = this.markerInfilename.startsWith("http:") || this.markerInfilename.startsWith("file:") || this.markerInfilename.startsWith("ftp:") ? new URL(this.markerInfilename) : new URL("file:///" + this.markerInfilename);
            System.out.println("Opening Markerfile " + myurl + "\n");
            InputStream ifs = myurl.openStream();
            StreamTokenizer is = new StreamTokenizer(new BufferedReader(new InputStreamReader(ifs)));
            is.commentChar(35);
            is.slashSlashComments(true);
            is.slashStarComments(true);
            is.parseNumbers();
            this.MyMarkers.ListOffset = this.MyMarkers.NumLists;
            while (this.MyMarkers.readline(is, this)) {
            }
            this.MyMarkers.DeleteDublicateMarkerLists();
            ifs.close();
        }
        catch (MalformedURLException e) {
            System.out.println("In Markerfile " + myurl + "\n");
            System.out.println("reading markers, URLException:" + e);
            this.applet.add("South", new Label("URLException:" + e + "\n"));
            e.printStackTrace();
            this.applet.setVisible(true);
        }
        catch (IOException e) {
            System.out.println("In Markerfile " + myurl + "\n");
            System.out.println("reading markers, URLException:" + e);
            this.applet.add("South", new Label("IOException: " + e + "\n"));
            e.printStackTrace();
            this.applet.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("In Markerfile " + myurl + "\n");
            this.applet.add("South", new Label("Exception appeared during load! \n" + e + "\n"));
            System.out.println("reading markers, Memoryexception! " + e + "\n");
            e.printStackTrace();
            this.applet.setVisible(true);
        }
    }

    public void Load(int DataType, int NumBytes, int NumBits, String URLname) {
        try {
            URL myurl = new URL(URLname);
            BufferedInputStream is = new BufferedInputStream(myurl.openStream());
            this.PrevType = DataType;
            this.PrevBytes = NumBytes;
            this.PrevBits = NumBits;
            int tread = 0;
            int bread = 0;
            int slice = 0;
            this.ActiveElement = 0;
            int elem = 0;
            int time = 0;
            int SliceSize = this.SizeX * this.SizeY;
            byte[] Ibuffer = null;
            System.out.println("Loading ... ");
            System.out.println("Type Nr (from # bytes, -1 = float): [0: byte, 1: int, 2: float, 3:double, 4:complex(float)]" + DataType);
            System.out.println("Number of Bytes :" + NumBytes);
            System.out.println("Number of Bits :" + NumBits);
            Ibuffer = new byte[NumBytes * this.SizeX * this.SizeY * this.SizeZ];
            System.out.println("SliceSize :" + (SliceSize *= NumBytes));
            while (true) {
                if ((tread += (bread = is.read(Ibuffer, tread + slice * SliceSize, SliceSize - tread))) < SliceSize && bread != -1) {
                    continue;
                }
                tread = 0;
                if (bread != -1) {
                    this.ElementAt(elem, time).ConvertSliceFromByte(slice, slice, Ibuffer, 1, 0);
                    if (++slice == this.SizeZ) {
                        if (time < this.Times - 1) {
                            ++time;
                        } else {
                            time = 0;
                            ++elem;
                        }
                        slice = 0;
                    }
                }
                if (bread == -1) break;
            }
            for (int e = 0; e < this.Elements; ++e) {
                AnElement ne = this.ElementAt(e);
                ne.SetMinMax();
                if (!(ne instanceof FloatElement) && !(ne instanceof DoubleElement)) continue;
                ne.MaxValue = ne.Max;
                ne.shift = ne.Min;
            }
            is.close();
        }
        catch (MalformedURLException e) {
            System.out.println("URLException:" + e);
            this.applet.add("South", new Label("URLException:" + e + "\n"));
            e.printStackTrace();
            this.applet.setVisible(true);
        }
        catch (IOException e) {
            System.out.println("URLException:" + e);
            this.applet.add("South", new Label("IOException:" + e + "\n"));
            this.applet.add("South", new Label("Error: Unable to load file \n"));
            e.printStackTrace();
            this.applet.setVisible(true);
        }
        catch (Exception e) {
            this.applet.add("South", new Label("Exception appeared during load!\n" + e + "\n"));
            System.out.println("Memoryexception appeared during data setup ! Element: " + e + "\n");
            e.printStackTrace();
            this.applet.setVisible(true);
        }
    }

    public boolean GetProjectionMode(int DimNr) {
        return this.ProjMode[DimNr];
    }

    public boolean GetMIPMode(int DimNr) {
        return this.GetBundleAt((int)this.ActiveElement).MIPMode;
    }

    public boolean GetLogMode() {
        return this.GetBundleAt((int)this.ActiveElement).LogScale;
    }

    ASlice ActProj(int DimNr) {
        return this.MyProjections[DimNr].elementAt(this.ActiveElement);
    }

    ASlice ProjAt(int DimNr, int e) {
        return this.MyProjections[DimNr].elementAt(e);
    }

    public void ToggleProj(int DimNr, boolean mipmode) {
        if (mipmode != this.GetBundleAt((int)this.ActiveElement).MIPMode) {
            this.InvalidateProjs(-1);
        }
        this.GetBundleAt((int)this.ActiveElement).MIPMode = mipmode;
        this.ProjMode[DimNr] = !this.ProjMode[DimNr];
    }

    public My3DData(My3DData other) {
        this.DataToHistogram = other.DataToHistogram;
        this.applet = other.applet;
        this.SizeX = other.SizeX;
        this.sizes[0] = other.sizes[0];
        this.SizeY = other.SizeY;
        this.sizes[1] = other.sizes[1];
        this.SizeZ = other.SizeZ;
        this.sizes[2] = other.sizes[2];
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (this.markerInfilename == null) {
                this.markerInfilename = "C:\\temp\\markers.txt";
            }
            if (this.markerOutfilename == null) {
                this.markerOutfilename = "C:\\temp\\markers.txt";
            }
        } else {
            if (this.markerInfilename == null) {
                this.markerInfilename = "/tmp/markers.txt";
            }
            if (this.markerOutfilename == null) {
                this.markerOutfilename = "/tmp/markers.txt";
            }
        }
        this.Elements = other.Elements;
        this.sizes[3] = other.sizes[3];
        this.Times = other.Times;
        this.sizes[4] = other.sizes[4];
        this.PrevBytes = other.PrevBytes;
        this.PrevBits = other.PrevBits;
        this.MyMarkers = other.MyMarkers;
        this.HistoX = other.HistoX;
        this.HistoY = other.HistoY;
        this.HistoZ = other.HistoZ;
        this.elemR = other.elemR;
        this.elemG = other.elemG;
        this.elemB = other.elemB;
        this.GateElem = other.GateElem;
        this.GateActive = other.GateActive;
        this.PlanesS = new Vector[3];
        this.PlanesD = new Vector[3];
        this.PlanesS[0] = new Vector();
        this.PlanesS[1] = new Vector();
        this.PlanesS[2] = new Vector();
        this.PlanesD[0] = new Vector();
        this.PlanesD[1] = new Vector();
        this.PlanesD[2] = new Vector();
        this.ROIPolygons = new Polygon[3];
        this.ProjMin = new int[3];
        this.ProjMax = new int[3];
        this.ProjMin[0] = other.ProjMin[0];
        this.ProjMin[1] = other.ProjMin[1];
        this.ProjMin[2] = other.ProjMin[2];
        this.ProjMax[0] = other.ProjMax[0];
        this.ProjMax[1] = other.ProjMax[1];
        this.ProjMax[2] = other.ProjMax[2];
        this.ProjMode = new boolean[3];
        this.ProjMode[0] = other.ProjMode[0];
        this.ProjMode[1] = other.ProjMode[1];
        this.ProjMode[2] = other.ProjMode[2];
        this.MySlice = new ASlice[3];
        this.MyColorSlice = new ASlice[3];
        try {
            int t;
            this.MyElements = other.MyElements;
            this.Elements = other.Elements;
            this.MyTimes = other.MyTimes;
            this.Times = other.Times;
            this.MyBundle = new Vector();
            this.TimesColorInfo = new Vector();
            this.MyTimeProj = new Vector();
            this.MyTimeColorProj = new Vector();
            for (int e = 0; e < other.Elements; ++e) {
                this.MyBundle.addElement((Bundle)other.GetBundleAt(e).clone());
            }
            for (t = 0; t < other.Times; ++t) {
                this.MyProjections = new Vector[3];
                this.MyProjections[0] = new Vector();
                this.MyProjections[1] = new Vector();
                this.MyProjections[2] = new Vector();
                for (int e = 0; e < other.Elements; ++e) {
                    this.MyProjections[0].addElement(new ASlice(0, other.ElementAt(e)));
                    this.MyProjections[1].addElement(new ASlice(1, other.ElementAt(e)));
                    this.MyProjections[2].addElement(new ASlice(2, other.ElementAt(e)));
                }
                this.MyTimeProj.addElement(this.MyProjections);
            }
            this.MyElements = this.MyTimes.elementAt(0);
            this.MyProjections = this.MyTimeProj.elementAt(0);
            this.MySlice[0] = new ASlice(0, this.MyElements.firstElement());
            this.MySlice[1] = new ASlice(1, this.MyElements.firstElement());
            this.MySlice[2] = new ASlice(2, this.MyElements.firstElement());
            this.MyColorSlice[0] = new ASlice(0, this.MyElements.firstElement());
            this.MyColorSlice[1] = new ASlice(1, this.MyElements.firstElement());
            this.MyColorSlice[2] = new ASlice(2, this.MyElements.firstElement());
            for (t = 0; t < other.Times; ++t) {
                this.MyColorProjection = new ASlice[3];
                this.MyColorProjection[0] = new ASlice(0, this.ElementsAtTime(t).firstElement());
                this.MyColorProjection[1] = new ASlice(1, this.ElementsAtTime(t).firstElement());
                this.MyColorProjection[2] = new ASlice(2, this.ElementsAtTime(t).firstElement());
                this.MyTimeColorProj.addElement(this.MyColorProjection);
            }
            this.MyColorProjection = this.MyTimeColorProj.elementAt(0);
            this.ActiveElement = other.ActiveElement;
            this.ActiveTime = other.ActiveTime;
        }
        catch (Exception e) {
            System.out.println("Exception appeared during spawning viewer !\n");
            e.printStackTrace();
            this.applet.add("South", new Label("Exception appeared during spawning viewer!\n"));
            this.applet.setVisible(true);
        }
        this.ClearPolyROIs();
        this.InvalidateProjs(-1);
        this.InvalidateColor();
        this.InvalidateSlices();
        this.colormode = other.colormode;
        this.ShowAllLists = other.ShowAllLists;
        this.ShowAllTrees = other.ShowAllTrees;
        this.ShowAllTrack = other.ShowAllTrack;
        this.ShowFullTrace = other.ShowFullTrace;
        this.ShowSpectralTrack = other.ShowSpectralTrack;
        this.TrackDirection = other.TrackDirection;
    }

    public My3DData(Container myapp, int sizex, int sizey, int sizez, int elements, int times, int redEl, int greenEl, int blueEl, int hisx, int hisy, int hisz, int myType, int NumBytes, int NumBits, double[] Scales, double[] Offsets, double ScaleV, double OffsetV, String[] Names, String[] Units) {
        this.applet = myapp;
        this.DataToHistogram = null;
        this.SizeX = sizex;
        this.sizes[0] = sizex;
        this.SizeY = sizey;
        this.sizes[1] = sizey;
        this.SizeZ = sizez;
        this.sizes[2] = sizez;
        this.sizes[3] = elements;
        this.sizes[4] = times;
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (this.markerInfilename == null) {
                this.markerInfilename = "C:\\temp\\markers.txt";
            }
            if (this.markerOutfilename == null) {
                this.markerOutfilename = "C:\\temp\\markers.txt";
            }
        } else {
            if (this.markerInfilename == null) {
                this.markerInfilename = "/tmp/markers.txt";
            }
            if (this.markerOutfilename == null) {
                this.markerOutfilename = "/tmp/markers.txt";
            }
        }
        try {
            this.ProjMin = new int[3];
            this.ProjMax = new int[3];
            this.ProjMin[0] = 0;
            this.ProjMin[1] = 0;
            this.ProjMin[2] = 0;
            this.ProjMax[0] = this.SizeX - 1;
            this.ProjMax[1] = this.SizeY - 1;
            this.ProjMax[2] = this.SizeZ - 1;
            this.ProjMode = new boolean[3];
            this.ProjMode[0] = false;
            this.ProjMode[1] = false;
            this.ProjMode[2] = false;
            this.PlanesS = new Vector[3];
            this.PlanesD = new Vector[3];
            this.PlanesS[0] = new Vector();
            this.PlanesS[1] = new Vector();
            this.PlanesS[2] = new Vector();
            this.PlanesD[0] = new Vector();
            this.PlanesD[1] = new Vector();
            this.PlanesD[2] = new Vector();
            this.ROIPolygons = new Polygon[3];
            this.MySlice = new ASlice[3];
            this.MyColorSlice = new ASlice[3];
            this.MyMarkers = new MarkerLists();
            this.HistoX = hisx;
            this.HistoY = hisy;
            this.HistoZ = hisz;
        }
        catch (Exception e) {
            System.out.println("Initialization exception !\n");
            e.printStackTrace();
            this.applet.add("South", new Label("Error initializing !\n"));
            this.applet.setVisible(true);
        }
        try {
            this.MyTimes = new Vector();
            this.MyTimeProj = new Vector();
            this.MyTimeColorProj = new Vector();
            this.MyBundle = new Vector();
            this.TimesColorInfo = new Vector();
            this.Elements = 0;
            this.Times = times;
            for (int t = 0; t < times; ++t) {
                this.MyElements = new Vector();
                this.MyTimes.addElement(this.MyElements);
                this.MyProjections = new Vector[3];
                this.MyProjections[0] = new Vector();
                this.MyProjections[1] = new Vector();
                this.MyProjections[2] = new Vector();
                this.MyTimeProj.addElement(this.MyProjections);
            }
            this.MyElements = this.MyTimes.elementAt(0);
            this.MyProjections = this.MyTimeProj.elementAt(0);
            String[] nNames = (String[])Names.clone();
            String[] nUnits = (String[])Units.clone();
            for (int e = 0; e < elements; ++e) {
                this.GenerateNewElement(myType, NumBytes, NumBits, Scales, Offsets, ScaleV, OffsetV, nNames, nUnits);
            }
            for (int t = 0; t < times; ++t) {
                this.MyColorProjection = new ASlice[3];
                this.MyColorProjection[0] = new ASlice(0, this.ElementsAtTime(t).firstElement());
                this.MyColorProjection[1] = new ASlice(1, this.ElementsAtTime(t).firstElement());
                this.MyColorProjection[2] = new ASlice(2, this.ElementsAtTime(t).firstElement());
                this.MyTimeColorProj.addElement(this.MyColorProjection);
            }
            this.MyColorProjection = this.MyTimeColorProj.elementAt(0);
        }
        catch (Exception e) {
            System.out.println("Memoryexception appeared ! Need more space for array !\n");
            e.printStackTrace();
            this.applet.add("South", new Label("Memoryexception appeared ! Need more space for array !\n"));
            this.applet.setVisible(true);
        }
        if (this.Elements != elements) {
            System.out.println("Error initializing elements: Wrong count: Elements = " + this.Elements + ", elements = " + elements + "\n");
        }
        this.MySlice[0] = new ASlice(0, this.MyElements.firstElement());
        this.MySlice[1] = new ASlice(1, this.MyElements.firstElement());
        this.MySlice[2] = new ASlice(2, this.MyElements.firstElement());
        this.MyColorSlice[0] = new ASlice(0, this.MyElements.firstElement());
        this.MyColorSlice[1] = new ASlice(1, this.MyElements.firstElement());
        this.MyColorSlice[2] = new ASlice(2, this.MyElements.firstElement());
        this.ClearPolyROIs();
        this.elemR = -1;
        this.elemG = -1;
        this.elemB = -1;
        if (redEl >= 0) {
            this.MarkChannel(redEl, 0);
        }
        if (greenEl >= 0) {
            this.MarkChannel(greenEl, 1);
        }
        if (blueEl >= 0) {
            this.MarkChannel(blueEl, 2);
        }
    }

    private void DoProject(int elem, int dim) {
        if (this.GetBundleAt((int)elem).ProjValid[dim] && this.ProjAt((int)dim, (int)elem).isValid) {
            return;
        }
        this.ActProj(dim).setMIPMode(this.GetBundleAt((int)elem).MIPMode);
        this.ProjAt(dim, elem).DoProject(dim, this.ElementAt(elem), this.GetGateElem(), this.ActROI());
        this.GetBundleAt((int)elem).ProjValid[dim] = true;
        this.MyColorProjection[dim].Invalidate();
    }

    boolean InOverlayDispl(int e) {
        return this.GetBundleAt(e).InOverlayDispl();
    }

    public void ToggleOverlayDispl(int val) {
        this.GetBundleAt(this.ActiveElement).ToggleOverlayDispl(val);
    }

    public void ToggleMulDispl(int val) {
        this.GetBundleAt(this.ActiveElement).ToggleMulDispl(val);
    }

    Image GiveSection(int dim, int pos) {
        ASlice ms = this.getDisplayedSlice(dim, pos);
        if (this.colormode) {
            if (!this.ProjMode[dim]) {
                ms.ClearColor();
                for (int e = 0; e < this.Elements; ++e) {
                    if (this.GetBundleAt(e).MulOverlayDispl()) {
                        this.ElementAt(e).SetScaleShift(this.Getmincs(e), this.Getmaxcs(e));
                        ms.MulToColorSlice(pos, this.ElementAt(e), this.GetBundleAt((int)e).cmapRed, this.GetBundleAt((int)e).cmapGreen, this.GetBundleAt((int)e).cmapBlue, this.GetGateElem(), this.ElementAt(this.ActiveElement));
                    }
                    if (!this.GetBundleAt(e).InOverlayDispl()) continue;
                    this.ElementAt(e).SetScaleShift(this.Getmincs(e), this.Getmaxcs(e));
                    ms.SumToColorSlice(pos, this.ElementAt(e), this.GetBundleAt((int)e).cmapRed, this.GetBundleAt((int)e).cmapGreen, this.GetBundleAt((int)e).cmapBlue, this.GetGateElem(), this.ElementAt(this.ActiveElement));
                }
            } else {
                for (int e = 0; e < this.Elements; ++e) {
                    if (!this.GetBundleAt(e).InOverlayDispl()) continue;
                    this.DoProject(e, dim);
                }
                this.ComputeColorProj(dim);
            }
            return ms.GenColorImage(this.applet);
        }
        ms.TakeModel(this.GetBundleAt((int)this.ActiveElement).ElementModel);
        return ms.GenImage(this.applet);
    }

    ASlice getDisplayedSlice(int dim, int pos) {
        if (this.colormode) {
            if (this.ProjMode[dim]) {
                return this.MyColorProjection[dim];
            }
            return this.MyColorSlice[dim];
        }
        AnElement mye = this.ActElement();
        mye.SetScaleShift(this.Getmincs(this.ActiveElement), this.Getmaxcs(this.ActiveElement));
        if (this.ProjMode[dim]) {
            this.DoProject(this.ActiveElement, dim);
            return this.ActProj(dim);
        }
        this.MySlice[dim].UpdateSlice(pos, mye, this.GetGateElem());
        return this.MySlice[dim];
    }

    void Clear(int e) {
        this.ElementAt(e).Clear();
    }

    class ColorInfo {
        public Double MinCs;
        public Double MaxCs;
        public Integer cmapcLow;
        public Integer cmapcHigh;

        ColorInfo() {
        }
    }
}

