/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

class Concatenation<T>
implements Convolution<T> {
    private final List<Convolution<T>> steps;

    Concatenation(List<? extends Convolution<T>> steps) {
        this.steps = new ArrayList<Convolution<T>>(steps);
    }

    @Override
    @Deprecated
    public void setExecutor(ExecutorService executor) {
        for (Convolution<T> step : this.steps) {
            step.setExecutor(executor);
        }
    }

    @Override
    public Interval requiredSourceInterval(Interval targetInterval) {
        Interval result = targetInterval;
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            result = this.steps.get(i).requiredSourceInterval(result);
        }
        return result;
    }

    @Override
    public T preferredSourceType(T targetType) {
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            targetType = this.steps.get(i).preferredSourceType(targetType);
        }
        return targetType;
    }

    @Override
    public void process(RandomAccessible<? extends T> source, RandomAccessibleInterval<? extends T> target) {
        List<Pair<Object, Interval>> srcIntervals = this.tmpIntervals((T)Util.getTypeFromInterval(target), (Interval)target);
        IntervalView currentSource = Views.interval(source, (Interval)((Interval)srcIntervals.get(0).getB()));
        IntervalView available = null;
        for (int i = 0; i < this.steps.size(); ++i) {
            IntervalView currentTarget;
            Convolution<T> step = this.steps.get(i);
            Object targetType = srcIntervals.get(i + 1).getA();
            Interval targetInterval = (Interval)srcIntervals.get(i + 1).getB();
            Object object = currentTarget = i == this.steps.size() - 1 ? target : null;
            if (currentTarget == null && available != null && Intervals.contains(available, (Interval)targetInterval) && Util.getTypeFromInterval(available).getClass().equals(targetType.getClass())) {
                currentTarget = Views.interval(available, (Interval)targetInterval);
            }
            if (currentTarget == null) {
                currentTarget = Concatenation.createImage((NativeType)Concatenation.uncheckedCast(targetType), targetInterval);
            }
            step.process((RandomAccessible<T>)currentSource, (RandomAccessibleInterval<T>)currentTarget);
            if (i > 0) {
                available = currentSource;
            }
            currentSource = currentTarget;
        }
    }

    private static <T extends NativeType<T>> RandomAccessibleInterval<T> createImage(T targetType, Interval targetInterval) {
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)targetInterval);
        Img ts = Util.getArrayOrCellImgFactory((Dimensions)targetInterval, targetType).create(dimensions);
        return Views.translate((RandomAccessibleInterval)ts, (long[])Intervals.minAsLongArray((Interval)targetInterval));
    }

    private static <T> T uncheckedCast(Object in) {
        Object in1 = in;
        return (T)in1;
    }

    private List<Pair<T, Interval>> tmpIntervals(T type, Interval interval) {
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(this.steps.size() + 1, null));
        result.set(this.steps.size(), new ValuePair(type, (Object)interval));
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            Convolution<T> step = this.steps.get(i);
            interval = step.requiredSourceInterval(interval);
            type = step.preferredSourceType(type);
            result.set(i, new ValuePair(type, (Object)interval));
        }
        return result;
    }
}

