/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.algorithm.kdtree.ClipConvexPolytopeKDTreeImpl;
import net.imglib2.algorithm.kdtree.ConvexPolytope;
import net.imglib2.algorithm.kdtree.KDTreeNodeIterable;

public class ClipConvexPolytopeKDTree<T> {
    private final ClipConvexPolytopeKDTreeImpl impl;
    private final KDTreeNodeIterable<T> insideNodes;
    private final KDTreeNodeIterable<T> outsideNodes;

    public ClipConvexPolytopeKDTree(KDTree<T> tree) {
        this.impl = new ClipConvexPolytopeKDTreeImpl(tree.impl());
        this.insideNodes = new KDTreeNodeIterable<T>(this.impl.getInsideNodes(), tree);
        this.outsideNodes = new KDTreeNodeIterable<T>(this.impl.getOutsideNodes(), tree);
    }

    public int numDimensions() {
        return this.impl.numDimensions();
    }

    public void clip(ConvexPolytope polytope) {
        this.impl.clip(polytope);
    }

    public void clip(double[][] planes) {
        this.impl.clip(planes);
    }

    public Iterable<KDTreeNode<T>> getInsideNodes() {
        return this.insideNodes;
    }

    public Iterable<KDTreeNode<T>> getOutsideNodes() {
        return this.outsideNodes;
    }
}

