/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.KDTree;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.converter.Converter;
import net.imglib2.neighborsearch.NearestNeighborSearchOnKDTree;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class KDTreeRadiusSource<I extends RealType<I>, O extends RealType<O>>
extends Point
implements OFunction<O>,
RandomAccess<O>,
RandomAccessible<O> {
    private final KDTree<I> kdtree;
    private final NearestNeighborSearchOnKDTree<I> search;
    private final Cursor<O> cursor;
    private final O scrap;
    private final double radius;
    private final double radius_squared;
    private final I outside;
    private final O outsideO;
    private final Converter<RealType<?>, O> converter;
    private final Interval interval;

    public KDTreeRadiusSource(O scrap, Converter<RealType<?>, O> converter, KDTree<I> kdtree, double radius, I outside, Interval interval) {
        super(kdtree.numDimensions());
        this.scrap = scrap;
        this.converter = converter;
        this.kdtree = kdtree;
        this.radius = radius;
        this.radius_squared = radius * radius;
        this.outside = outside;
        this.search = new NearestNeighborSearchOnKDTree(kdtree);
        this.outsideO = (RealType)scrap.createVariable();
        converter.convert(outside, this.outsideO);
        this.interval = interval;
        this.cursor = Views.zeroMin((RandomAccessibleInterval)Views.interval((RandomAccessible)this, (Interval)interval)).cursor();
    }

    public O get() {
        this.search.search((RealLocalizable)this);
        if (this.search.getSquareDistance() < this.radius_squared) {
            this.converter.convert(this.search.getSampler().get(), this.scrap);
            return this.scrap;
        }
        return this.outsideO;
    }

    public O getType() {
        return this.scrap;
    }

    public RandomAccess<O> copy() {
        return new KDTreeRadiusSource<I, RealType>((RealType)this.scrap.createVariable(), this.converter, this.kdtree, this.radius, this.outside, this.interval);
    }

    public RandomAccess<O> randomAccess() {
        return this;
    }

    public RandomAccess<O> randomAccess(Interval interval) {
        return this;
    }

    @Override
    public final O eval() {
        return (O)((RealType)this.cursor.next());
    }

    @Override
    public O eval(Localizable loc) {
        this.setPosition(loc);
        return this.get();
    }

    @Override
    public List<OFunction<O>> children() {
        return Arrays.asList(new OFunction[0]);
    }

    @Override
    public final double evalDouble() {
        return ((RealType)this.cursor.next()).getRealDouble();
    }

    @Override
    public final double evalDouble(Localizable loc) {
        this.setPosition(loc);
        return this.get().getRealDouble();
    }
}

