/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.Sampler;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public abstract class HypersphereNeighborhoodLocalizableSampler<T>
extends AbstractEuclideanSpace
implements Localizable,
Sampler<Neighborhood<T>> {
    protected final RandomAccessible<T> source;
    protected final long radius;
    protected final Interval sourceInterval;
    protected final HyperSphereNeighborhoodFactory<T> neighborhoodFactory;
    protected final Neighborhood<T> currentNeighborhood;
    protected final long[] currentPos;

    public HypersphereNeighborhoodLocalizableSampler(RandomAccessible<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory, Interval accessInterval) {
        super(source.numDimensions());
        this.source = source;
        this.radius = radius;
        this.neighborhoodFactory = factory;
        this.currentPos = new long[this.n];
        if (accessInterval == null && source instanceof Interval) {
            accessInterval = (Interval)source;
        }
        if (accessInterval == null) {
            this.sourceInterval = null;
        } else {
            long[] accessMin = new long[this.n];
            long[] accessMax = new long[this.n];
            accessInterval.min(accessMin);
            accessInterval.max(accessMax);
            int d = 0;
            while (d < this.n) {
                int n = d;
                accessMin[n] = accessMin[n] - radius;
                int n2 = d++;
                accessMax[n2] = accessMax[n2] + radius;
            }
            this.sourceInterval = new FinalInterval(accessMin, accessMax);
        }
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, radius, this.sourceInterval == null ? source.randomAccess() : source.randomAccess(this.sourceInterval));
    }

    protected HypersphereNeighborhoodLocalizableSampler(HypersphereNeighborhoodLocalizableSampler<T> c) {
        super(c.n);
        this.source = c.source;
        this.radius = c.radius;
        this.sourceInterval = c.sourceInterval;
        this.neighborhoodFactory = c.neighborhoodFactory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.radius, this.sourceInterval == null ? this.source.randomAccess() : this.source.randomAccess(this.sourceInterval));
    }

    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    public Neighborhood<T> getType() {
        return this.currentNeighborhood;
    }

    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }

    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }
}

