/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptService;
import org.scijava.util.FileUtils;

public class ScriptFinder
extends AbstractContextual {
    private static final String SCRIPT_ICON = "/icons/script_code.png";
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private LogService log;
    private final String pathPrefix;

    public ScriptFinder(Context context) {
        this(context, "scripts");
    }

    public ScriptFinder(Context context, String pathPrefix) {
        this.setContext(context);
        this.pathPrefix = pathPrefix;
    }

    public void findScripts(List<ScriptInfo> scripts) {
        List<File> directories = this.scriptService.getScriptDirectories();
        HashSet<URL> urls = new HashSet<URL>();
        int scriptCount = 0;
        scriptCount += this.scanResources(scripts, urls);
        for (File dir : directories) {
            scriptCount += this.scanDirectory(scripts, urls, dir);
        }
        this.log.debug("Found " + scriptCount + " scripts");
    }

    private int scanResources(List<ScriptInfo> scripts, Set<URL> urls) {
        if (this.pathPrefix == null) {
            return 0;
        }
        Map<String, URL> scriptMap = FileUtils.findResources(null, this.pathPrefix, null);
        return this.createInfos(scripts, urls, scriptMap, null);
    }

    private int scanDirectory(List<ScriptInfo> scripts, Set<URL> urls, File dir) {
        if (!dir.exists()) {
            String path = dir.getAbsolutePath();
            this.log.debug("Ignoring non-existent scripts directory: " + path);
            return 0;
        }
        MenuPath menuPrefix = this.scriptService.getMenuPrefix(dir);
        try {
            Set<URL> dirURL = Collections.singleton(dir.toURI().toURL());
            Map<String, URL> scriptMap = FileUtils.findResources(null, dirURL);
            return this.createInfos(scripts, urls, scriptMap, menuPrefix);
        }
        catch (MalformedURLException exc) {
            this.log.error("Invalid script directory: " + dir, exc);
            return 0;
        }
    }

    private int createInfos(List<ScriptInfo> scripts, Set<URL> urls, Map<String, URL> scriptMap, MenuPath menuPrefix) {
        int scriptCount = 0;
        for (String path : scriptMap.keySet()) {
            URL url;
            if (!this.scriptService.canHandleFile(path)) {
                this.log.debug("Ignoring unsupported script: " + path);
                continue;
            }
            int dot = path.lastIndexOf(46);
            String basePath = dot <= 0 ? path : path.substring(0, dot);
            String friendlyPath = basePath.replace('_', ' ');
            MenuPath menuPath = new MenuPath(menuPrefix);
            menuPath.addAll(new MenuPath(friendlyPath, "/", false));
            if (menuPath.size() == 1) {
                menuPath.add(0, new MenuEntry("Plugins"));
                menuPath.add(1, new MenuEntry("Scripts"));
            }
            if (urls.contains(url = scriptMap.get(path))) continue;
            urls.add(url);
            try {
                ScriptInfo info = new ScriptInfo(this.getContext(), url, path);
                info.setMenuPath(menuPath);
                menuPath.getLeaf().setIconPath(SCRIPT_ICON);
                scripts.add(info);
                ++scriptCount;
            }
            catch (IOException exc) {
                this.log.error("Invalid script URL: " + url, exc);
            }
        }
        return scriptCount;
    }

    @Deprecated
    public ScriptFinder(ScriptService scriptService) {
        this(scriptService.context());
    }
}

