/*
 * Decompiled with CFR 0.152.
 */
package knn;

import bijnum.BIJmatrix;
import knn.Feature;
import knn.StereoFilterBank;
import volume.Convolver;
import volume.DoG2D;
import volume.Transformer;

public class DOGFilterBank
extends StereoFilterBank {
    public DOGFilterBank(float[] scales, float[] xshifts) {
        this.scales = scales;
        this.xshifts = xshifts;
    }

    @Override
    public String toString(int filternumber, String preString) {
        double[] params = this.params(filternumber);
        String name = "<unknown " + filternumber + ">";
        if (params != null) {
            name = DOGFilterBank.name((int)params[0], params[1], 0.0, preString);
        }
        return name;
    }

    protected static String name(double scale, double xshift, double yshift, String extraText) {
        if (yshift == 0.0) {
            return extraText + "DOG delta (" + xshift + " pixels) scale=" + scale;
        }
        return extraText + "DOG delta (" + xshift + ", " + yshift + " pixels) scale=" + scale;
    }

    @Override
    public Feature filter(int filternumber, float[] left_image, float[] right_image, int width, String extraText) {
        Feature f = null;
        double[] params = this.params(filternumber);
        f = DOGFilterBank.DOG(left_image, right_image, width, params[0], params[1], extraText);
        return f;
    }

    public static Feature DOG(float[] image_left, float[] image_right, int width, double scale, double xshift, String extraText) {
        Feature f = null;
        float[] dogl = BIJmatrix.copy(image_left);
        int ishift = (int)Math.round(xshift);
        float[] dogr = Transformer.quick(image_right, width, ishift, 0);
        if (scale > 0.0) {
            DoG2D dog = new DoG2D(scale);
            Convolver.convolvexy(dogl, width, image_left.length / width, dog);
            Convolver.convolvexy(dogr, width, image_left.length / width, dog);
        }
        float[] delta = BIJmatrix.sub(dogl, dogr);
        f = new Feature(DOGFilterBank.name(scale, ishift, 0.0, extraText), delta);
        return f;
    }
}

