/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.roi.Masks;
import net.imglib2.roi.RealMask;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.function.Functions;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;
import org.scijava.ops.flim.FitWorker;
import org.scijava.ops.flim.ParamEstimator;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public abstract class AbstractFitRAI<I extends RealType<I>, K extends RealType<K>>
implements Functions.Arity4<FitParams<I>, RealMask, RandomAccessibleInterval<K>, FitWorker.FitEventHandler<I>, FitResults> {
    @OpDependency(name="filter.convolve")
    private Functions.Arity3<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, I, RandomAccessibleInterval<I>> convolveOp;

    public FitResults apply(FitParams<I> params, @Nullable RealMask mask, @Nullable RandomAccessibleInterval<K> kernel, @Nullable FitWorker.FitEventHandler<I> handler) {
        this.assertConformity(params, mask, (RandomAccessibleInterval<K>)kernel);
        if (mask == null) {
            mask = Masks.allRealMask((int)0);
        }
        if (kernel != null) {
            kernel = Views.permute(kernel, (int)2, (int)params.ltAxis);
        }
        params = params.copy();
        if (kernel != null) {
            params.transMap = (RandomAccessibleInterval)this.convolveOp.apply(params.transMap, (Object)kernel, (Object)((RealType)Util.getTypeFromInterval(params.transMap)));
        }
        List<int[]> roiPos = this.getRoiPositions(mask, params.ltAxis, params.transMap);
        ParamEstimator<I> est = new ParamEstimator<I>(params, roiPos);
        est.estimateStartEnd();
        est.estimateIThreshold();
        FitResults rslts = new FitResults();
        FitWorker<I> fitWorker = this.createWorker(params, rslts);
        this.initRslt(params, fitWorker, est, rslts);
        fitWorker.fitBatch(roiPos, handler);
        return rslts;
    }

    private void assertConformity(FitParams<I> in, RealMask roi, RandomAccessibleInterval<K> kernel) {
        if (in.transMap.numDimensions() != 3) {
            throw new IllegalArgumentException("Fitting requires 3-dimensional input");
        }
        if (in.ltAxis < 0 || in.ltAxis >= in.transMap.numDimensions()) {
            throw new IllegalArgumentException("Lifetime axis must be 0, 1, or 2");
        }
        if (roi != null && roi.numDimensions() != 2) {
            throw new IllegalArgumentException("Mask must be 2-dimensional");
        }
        if (kernel != null && kernel.numDimensions() != 3) {
            throw new IllegalArgumentException("Kernel must be 3-dimensional");
        }
    }

    public abstract FitWorker<I> createWorker(FitParams<I> var1, FitResults var2);

    private void initRslt(FitParams<I> params, FitWorker<I> fitWorker, ParamEstimator<I> est, FitResults rslts) {
        int lifetimeAxis = params.ltAxis;
        long[] dimFit = new long[params.transMap.numDimensions()];
        params.transMap.dimensions(dimFit);
        if (params.getParamMap) {
            dimFit[lifetimeAxis] = fitWorker.nParamOut();
            rslts.paramMap = ArrayImgs.floats((long[])dimFit);
        }
        if (params.getFittedMap) {
            dimFit[lifetimeAxis] = fitWorker.nDataOut();
            rslts.fittedMap = ArrayImgs.floats((long[])dimFit);
        }
        if (params.getResidualsMap) {
            dimFit[lifetimeAxis] = fitWorker.nDataOut();
            rslts.residualsMap = ArrayImgs.floats((long[])dimFit);
        }
        if (params.getReturnCodeMap) {
            dimFit[lifetimeAxis] = 1L;
            rslts.retCodeMap = ArrayImgs.ints((long[])dimFit);
        }
        if (params.getChisqMap) {
            dimFit[lifetimeAxis] = 1L;
            rslts.chisqMap = ArrayImgs.floats((long[])dimFit);
        }
        rslts.ltAxis = lifetimeAxis;
        rslts.intensityMap = est.getIntensityMap();
    }

    private List<int[]> getRoiPositions(RealMask roi, int lifetimeAxis, RandomAccessibleInterval<I> trans) {
        ArrayList<int[]> interested = new ArrayList<int[]>();
        IntervalView xyPlane = Views.hyperSlice(trans, (int)lifetimeAxis, (long)0L);
        Cursor xyCursor = xyPlane.localizingCursor();
        while (xyCursor.hasNext()) {
            xyCursor.fwd();
            if (!roi.test((Object)xyCursor)) continue;
            int[] pos = new int[3];
            xyCursor.localize(pos);
            for (int i = 2; i > lifetimeAxis; --i) {
                int tmp = pos[i];
                pos[i] = pos[i - 1];
                pos[i - 1] = tmp;
            }
            pos[lifetimeAxis] = 0;
            interested.add(pos);
        }
        return interested;
    }
}

